<section class="main-slider" id="hero-slider">
    <?php
    $slider_query = new WP_Query([
        'post_type'      => 'slides',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
        'post_status'    => 'publish'
    ]);
    ?>
    
     <div class="swiper-container thm-swiper__slider" data-swiper-options='{
        "slidesPerView": 1,
        "loop": true,
        "effect": "fade",
        "pagination": {
            "el": "#main-slider-pagination",
            "type": "bullets",
            "clickable": true
        },
        "navigation": {
            "nextEl": "#main-slider__swiper-button-next",
            "prevEl": "#main-slider__swiper-button-prev"
        },
        "autoplay": {
            "delay": 5000
        }
    }'>
        <div class="swiper-wrapper">
            <?php if ($slider_query->have_posts()): ?>
                <?php while ($slider_query->have_posts()): $slider_query->the_post();
                    $title = get_the_title();
                    $url = get_permalink();
                    $backgroundImg = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?>
                    <div class="swiper-slide">
                        <?php if ($backgroundImg): ?>
                            <div class="image-layer" style="background-image: url('<?php echo esc_url($backgroundImg); ?>');"></div>
                        <?php else: ?>
                            <div class="image-layer" style="background-color: #333;"></div>
                        <?php endif; ?>
                        <div class="slider-overlay"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-content">
                                        <div class="main-slider-content__inner">
                                            <h2 class="slide-title"><?php echo esc_html($title); ?></h2>
                                            <div class="hero-buttons">
                                                <a href="<?php echo esc_url($url); ?>" class="buttons buttons-primary">Learn More</a>
                                                <a href="<?php echo esc_url($url); ?>" class="buttons buttons-secondary">UEGCL Services</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="swiper-slide">
                    <div class="image-layer" style="background-color: #333;"></div>
                    <div class="slider-overlay"></div>
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="main-slider-content">
                                    <div class="main-slider-content__inner">
                                        <h2 class="slide-title">No Slides Found</h2>
                                        <div class="hero-buttons">
                                            <a href="<?php echo admin_url('edit.php?post_type=slides'); ?>" class="buttons buttons-primary">Add Slides</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="swiper-pagination"></div>
        
        <!-- Scroll Button -->
        <div class="scroll-button" onclick="scrollToNext()">
            <div class="scroll-circle">
                <span class="scroll-text">SCROLL</span>
            </div>
        </div>
    </div>
    <?php wp_reset_postdata(); ?>
</section>


<style>
    /* Navigation buttons */
.swiper-button-next,
.swiper-button-prev {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    z-index: 10;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    transition: all 0.3s ease;
}

.swiper-button-next:hover,
.swiper-button-prev:hover {
    background: rgba(255,255,255,0.4);
}

.swiper-button-next {
    right: 20px;
}

.swiper-button-prev {
    left: 20px;
}

.swiper-button-next:after,
.swiper-button-prev:after {
    font-size: 20px;
    font-weight: bold;
}
</style>