<?php
get_header();
include get_template_directory() . '/inc/menus/menu.php';
?>
<main role="main">
<?php 
// Store original post before any modifications
global $post;
$original_post = $post;
?>
<section class="hero-section" style="background-color: var(--kpy-primary); position: relative;">
    
    <!-- Animated background layer -->
    <div class="hero-animated-bg"></div>
    
    <!-- Corporate overlay -->
    <div class="hero-overlay-uegcl"></div>
    
    <div class="hero-content-uegcl">
        <div class="container-xxl">
            <h2 class="page-hero-title-uegcl"><?php the_title(); ?></h2>
            <p class="page-hero-subtitle-uegcl">20 years of Generating for GENERATIONS</p>
            <div class="page-hero-breadcrumb-uegcl">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>
    
    <!-- Wave bottom decoration -->
    <div class="hero-wave-bottom"></div>
</section>

 <?php 
    // Reset to original post
    $post = $original_post;
    setup_postdata($post);
    
    if (have_posts()): while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php the_content(); ?>
        </article>
    <?php endwhile; ?>
    <?php else: ?>
        <article>
            <h2><?php _e('Sorry, nothing to display.', 'kipya'); ?></h2>
        </article>
    <?php endif; ?>
    <?php edit_post_link(); ?>
</main>
<?php get_footer(); ?>