/** ============================================================
 *  JS File for Kipya Template
 *===============================================================*/
$(document).ready(function() {
    $('.menu-item').hover(
        function() {
            $(this).children('.sub-menu').stop(true, true).slideDown(200); // Adjust the speed as needed
        },
        function() {
            $(this).children('.sub-menu').stop(true, true).slideUp(200);
        }
    );
});

/** ============================================================================
 * HEADER SCROLL
*=============================================================================*/
 document.addEventListener('DOMContentLoaded', function() {
            // Search Toggle
            const searchToggle = document.getElementById('searchToggle');
            const headerSearchBar = document.getElementById('headerSearchBar');
            
            searchToggle.addEventListener('click', function() {
                headerSearchBar.classList.toggle('active');
            });
            
            // Mobile Navigation Toggle
            const mobileNavToggle = document.getElementById('mobileNavToggle');
            const mobileNavMenu = document.getElementById('mobileNavMenu');
            const mobileNavClose = document.getElementById('mobileNavClose');
            const mobileNavOverlay = document.getElementById('mobileNavOverlay');
            
            mobileNavToggle.addEventListener('click', function() {
                mobileNavMenu.classList.add('active');
                mobileNavOverlay.classList.add('active');
            });
            
            mobileNavClose.addEventListener('click', function() {
                mobileNavMenu.classList.remove('active');
                mobileNavOverlay.classList.remove('active');
            });
            
            mobileNavOverlay.addEventListener('click', function() {
                mobileNavMenu.classList.remove('active');
                mobileNavOverlay.classList.remove('active');
            });
            
            // Close search when clicking outside
            document.addEventListener('click', function(event) {
                if (!searchToggle.contains(event.target) && !headerSearchBar.contains(event.target)) {
                    headerSearchBar.classList.remove('active');
                }
            });
            
            // Add scroll effect to header
            window.addEventListener('scroll', function() {
                const header = document.querySelector('.main-header');
                if (window.scrollY > 50) {
                    header.style.boxShadow = '0 5px 20px rgba(0, 0, 0, 0.1)';
                } else {
                    header.style.boxShadow = '0 2px 15px rgba(0, 0, 0, 0.1)';
                }
            });
        });



// Multi-Level Mobile Accordion Dropdowns
document.addEventListener('DOMContentLoaded', () => {
  const mobileMenu = document.getElementById('mobileNavMenu');

  mobileMenu.addEventListener('click', function (e) {
    const link = e.target.closest('.has-children > a');
    if (link) {
      e.preventDefault();
      const parentLi = link.parentElement;
      const submenu = parentLi.querySelector(':scope > .mobile-submenu');

      // Close sibling dropdowns at the same level
      const siblingLis = parentLi.parentElement.querySelectorAll('.has-children');
      siblingLis.forEach(sibling => {
        if (sibling !== parentLi) {
          sibling.classList.remove('open');
          const siblingSub = sibling.querySelector(':scope > .mobile-submenu');
          if (siblingSub) siblingSub.classList.remove('active');
        }
      });

      // Toggle this submenu
      if (submenu) {
        submenu.classList.toggle('active');
        parentLi.classList.toggle('open');
      }
    }
  });
});


/**====================================================
   * Slides - Animation JS
   *====================================================**/


(function () {
  'use strict';

  // -----------------------------
  // Utilities
  // -----------------------------
  function parseOptions(raw) {
    if (!raw) return {};
    if (typeof raw === 'object') return raw;
    try { return JSON.parse(raw); } catch (err) { console.warn('Invalid JSON in data-swiper-options:', err, raw); return {}; }
  }

  function findLocalOrNull(container, selector) {
    if (!selector) return null;
    try {
      if (typeof selector === 'string') {
        // if selector exists globally, keep it
        if (document.querySelector(selector)) return selector;
        var local = container.querySelector(selector);
        if (local) return local;
        return null;
      }
      if (selector && selector.nodeType) return selector;
    } catch (e) { return null; }
    return null;
  }

  function isInitialized(container) { return !!(container && container.dataset && container.dataset.swiperInited === '1'); }
  function markInitialized(container) { if (container && container.dataset) container.dataset.swiperInited = '1'; }

  // -----------------------------
  // Build options safely
  // -----------------------------
  function buildOptions(container, rawOptions) {
    var opts = parseOptions(rawOptions || {});
    var defaults = {
      slidesPerView: 1,
      loop: true,
      effect: 'fade',
      fadeEffect: { crossFade: true },
      autoplay: { delay: 5000, disableOnInteraction: false },
      observer: true,
      observeParents: true
    };
    var merged = Object.assign({}, defaults, opts);

    // pagination fallback
    if (merged.pagination) {
      var pag = merged.pagination;
      var found = findLocalOrNull(container, pag.el);
      if (!found) {
        var localPagNode = container.querySelector('.swiper-pagination');
        if (localPagNode) merged.pagination.el = localPagNode; else delete merged.pagination;
      } else merged.pagination.el = found;
    } else {
      var localPag = container.querySelector('.swiper-pagination');
      if (localPag) merged.pagination = { el: localPag, type: 'bullets', clickable: true };
    }

    // navigation fallback
    if (merged.navigation) {
      var nav = merged.navigation;
      var nNext = findLocalOrNull(container, nav.nextEl);
      var nPrev = findLocalOrNull(container, nav.prevEl);
      if (nNext && nPrev) {
        merged.navigation.nextEl = nNext;
        merged.navigation.prevEl = nPrev;
      } else {
        var nextBtn = container.querySelector('.swiper-button-next');
        var prevBtn = container.querySelector('.swiper-button-prev');
        if (nextBtn && prevBtn) merged.navigation = { nextEl: nextBtn, prevEl: prevBtn };
        else delete merged.navigation;
      }
    }

    return merged;
  }

  // -----------------------------
  // Single slider init
  // -----------------------------
  function initSingleSlider(container) {
    if (!container) return null;
    if (typeof Swiper === 'undefined') { console.error('Swiper not loaded.'); return null; }
    if (isInitialized(container)) return container._swiperInstance || null;

    var raw = container.getAttribute('data-swiper-options') || container.dataset.swiperOptions;
    var opts = buildOptions(container, raw);

    try {
      var inst = new Swiper(container, opts);
      container._swiperInstance = inst;
      markInitialized(container);
      try { if (inst && inst.autoplay && inst.autoplay.start) inst.autoplay.start(); } catch (e) {}

      // debug hook
      if (window.location && window.location.search && window.location.search.indexOf('debug-swiper') !== -1) {
        console.log('Swiper init for', container, opts, inst);
      }

      return inst;
    } catch (err) { console.error('Failed to init Swiper for container', container, err); return null; }
  }

  // -----------------------------
  // Init all theme sliders
  // -----------------------------
  function thmSwiperInit() {
    var els = document.querySelectorAll('.thm-swiper__slider, .swiper-container.thm-swiper__slider, .thm-swiper');
    if (!els || els.length === 0) return;
    els.forEach(function (el) { initSingleSlider(el); });
  }

  // -----------------------------
  // Thumbnail + main slider original behavior
  // -----------------------------
  function initThumbnailAndMainIfPresent() {
    try {
      var thumbEl = document.querySelector('.thumbnail-swiper');
      var mainEl = document.querySelector('.main-swiper');
      if (thumbEl && mainEl && typeof Swiper !== 'undefined') {
        if (!isInitialized(thumbEl)) {
          var thumb = new Swiper(thumbEl, {
            slidesPerView: 'auto', spaceBetween: 10, freeMode: true,
            watchSlidesProgress: true, centeredSlides: true,
            breakpoints: { 320: { slidesPerView: 3 }, 768: { slidesPerView: 5 }, 1024: { slidesPerView: 7 } }
          });
          markInitialized(thumbEl); thumbEl._swiperInstance = thumb;
        }

        if (!isInitialized(mainEl)) {
          var mainSwiperInst = new Swiper(mainEl, {
            loop: true, effect: 'fade', fadeEffect: { crossFade: true },
            autoplay: { delay: 5000, disableOnInteraction: false },
            navigation: { nextEl: mainEl.querySelector('.swiper-button-next') || '.swiper-button-next', prevEl: mainEl.querySelector('.swiper-button-prev') || '.swiper-button-prev' },
            thumbs: { swiper: thumbEl._swiperInstance || undefined }
          });
          mainEl._swiperInstance = mainSwiperInst; markInitialized(mainEl);
        }
      }
    } catch (e) { console.warn('thumbnail/main init error', e); }
  }

  // -----------------------------
  // Legacy jQuery-based behaviors (vegas, wow, etc.)
  // -----------------------------
  function legacyOnLoadJQuery() {
    if (typeof jQuery === 'undefined') return;
    (function ($) {
      if ($('.banner-bg-slide').length) {
        $('.banner-bg-slide').each(function () {
          var Self = $(this); var bgSlideOptions = Self.data('options'); Self.vegas && Self.vegas(bgSlideOptions);
        });
      }

      if ($('.wow').length) {
        try { var wow = new WOW({ boxClass: 'wow', animateClass: 'animated', mobile: true, live: true }); wow.init(); } catch (e) {}
      }

      // Existing load handlers many themes rely on
      $(window).on('load', function () {
        try { thmSwiperInit(); } catch (e) {}
        try { handlePreloader && handlePreloader(); } catch (e) {}
        try { languageSwitcher && languageSwitcher(); } catch (e) {}
        try { projectMasonaryLayout && projectMasonaryLayout(); } catch (e) {}

        // quantity spinner
        if ($('.quantity-spinner').length) { try { $("input.quantity-spinner").TouchSpin({ verticalbuttons: true }); } catch (e) {} }
      });

    })(jQuery);
  }

  // -----------------------------
  // DOM ready initialization
  // -----------------------------
  document.addEventListener('DOMContentLoaded', function () {
    try { thmSwiperInit(); } catch (e) { console.error('thmSwiperInit error', e); }
    try { initThumbnailAndMainIfPresent(); } catch (e) { console.warn('thumb/main init error', e); }

    // schedule a re-check after a short delay for dynamic content
    setTimeout(function () { try { thmSwiperInit(); } catch (e) {} }, 120);

    // init legacy jQuery behaviors if jQuery exists
    try { legacyOnLoadJQuery(); } catch (e) {}
  });

  // expose a re-init hook for debugging
  window.KPY_THEME = window.KPY_THEME || {};
  window.KPY_THEME.reinitSliders = function () { thmSwiperInit(); initThumbnailAndMainIfPresent(); };

  // helpful console method to quickly check swiper status
  window.KPY_THEME.debugStatus = function() {
    console.log('typeof Swiper =', typeof Swiper);
    try { console.log('Swiper.version =', Swiper && (Swiper.version || (Swiper.prototype && Swiper.prototype.constructor && Swiper.prototype.constructor.version)) ); } catch(e) {}
    console.log('.thm-swiper__slider count =', document.querySelectorAll('.thm-swiper__slider').length);
    console.log('.swiper-slide-active count =', document.querySelectorAll('.swiper-slide-active').length);
  };

})();


/**====================================
* AOS
=====================================**/
     document.addEventListener('DOMContentLoaded', function () {
    // Initialize AOS for each column
    if (typeof AOS !== 'undefined') {
        AOS.init({
            duration: 1000,
            easing: 'ease-in-out',
            once: true,
            mirror: false,
        });
    }
});
 /**====================================
     * HIDE OVERFLOW
=====================================**/
     
(function ($, root, undefined) {
	
	$(function () {
		
		'use strict';
		
		// DOM ready, take it away
		$("html").attr("style", "overflow-x:hidden;");
		
	});
	
})(jQuery, this);


document.addEventListener('DOMContentLoaded', function() {
  const counters = document.querySelectorAll('.kpy-counter');
  const speed = 500000; // Animation duration in ms
  
  function animateCounters() {
    counters.forEach(counter => {
      const target = +counter.getAttribute('data-target');
      const count = +counter.innerText.replace('+','');
      const increment = target / speed;
      
      if (count < target) {
        counter.innerText = Math.ceil(count + increment) + '+';
        setTimeout(animateCounters, 1);
      } else {
        counter.innerText = target.toLocaleString() + '+';
      }
    });
  }
  
  // Trigger on scroll
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        animateCounters();
        observer.unobserve(entry.target);
      }
    });
  }, { threshold: 0.5 });
  
  document.querySelector('.kpy-impact-metrics').style.opacity = '1';
  observer.observe(document.querySelector('.kpy-impact-metrics'));
});


document.addEventListener("DOMContentLoaded", function () {
  const sections = document.querySelectorAll('.scroll-section');

  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add('visible');
        // Uncomment to trigger only once
        // observer.unobserve(entry.target);
      }
    });
  }, {
    threshold: 0.1
  });

  sections.forEach(section => {
    observer.observe(section);
  });
});



document.addEventListener('DOMContentLoaded', function() {
  const eventsSection = document.querySelector('.kpy-events-section');
  
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add('in-view');
      }
    });
  }, { threshold: 0.1 });
  
  if (eventsSection) {
    observer.observe(eventsSection);
  }
});


/* Add this JavaScript to trigger animations on scroll */
document.addEventListener('DOMContentLoaded', function() {
  const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        entry.target.classList.add('in-view');
      }
    });
  }, { threshold: 0.1 });
  
  document.querySelectorAll('.kpy-story-section, .kpy-values-section').forEach(section => {
    observer.observe(section);
  });
});


