<?php /* Template Name: Main Pages Template */ get_header(); 
    include get_template_directory() . '/inc/menus/menu1.php'; 
?>
	<main role="main">
	    <section class="page-header shadow-sm">
	        <div class="container">
	            <div class="row">
	                <div class="col-md-7 col-sm-7" data-aos="fade-up">
	                    <h1 class="entry-title"><?php the_title(); ?></h1>
	                    <p class="excerpt"><?php the_excerpt(); ?></p>
	                </div><!-- Title & Excerpt !-->
	                <div class="col-md-5 col-sm-5 align-self-center">
	                    <?php custom_breadcrumb(); ?>
	                </div><!-- breadcrumb !-->
	            </div><!-- row !-->
	        </div><!-- container !-->
	    </section><!-- Header Section !-->
		<section>
		    <div class="container page-content">
		        <?php if (have_posts()): while (have_posts()) : the_post(); ?>

			<!-- article -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php the_content(); ?>

				<?php comments_template( '', true ); // Remove if you don't want comments ?>

				<br class="clear">

				<?php edit_post_link(); ?>

			</article>
			<!-- /article -->

		<?php endwhile; ?>

		<?php else: ?>

			<!-- article -->
			<article>

				<h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>

			</article>
			<!-- /article -->

		<?php endif; ?>
		    </div>
		</section>
		<!-- /section -->
 </main>


<?php get_footer(); ?>
