<!-- Sliding Photos and Videos !-->
<div id="carouselExampleFade" class="carousel slide carousel-fade" data-bs-ride="carousel">
    <?php
    $slider_query = new WP_Query(array('post_type' => 'slides', 'posts_per_page' => -1));
    ?>
    <div class="carousel-inner">
        <?php if ($slider_query->have_posts()) : ?>
            <?php $first_slide = true; ?>
            <?php while ($slider_query->have_posts()) : ?>
                <?php 
                $slider_query->the_post();
                $title = get_the_title();
                $description = get_the_excerpt();
                $url = get_post_meta(get_the_ID(), 'slide_url', true); 
                $video_url = get_post_meta(get_the_ID(), '_slide_video_url', true); 
                $backgroundImg = get_the_post_thumbnail_url(get_the_ID());
                ?>
                <div class="carousel-item <?= $first_slide ? 'active' : '' ?>" data-bs-interval="<?= $video_url ? '10000' : '5000'; ?>">
                    <?php if ($video_url) : ?>
                        <!-- Embed video -->
                        <video autoplay loop muted class="d-block w-100 video-slide">
                            <source src="<?= esc_url($video_url); ?>" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    <?php else : ?>
                        <!-- Display image -->
                        <img src="<?= esc_url($backgroundImg); ?>" class="d-block w-100" alt="<?= esc_html($title); ?>">
                    <?php endif; ?>
                    <div class="carousel-caption">
                        <h2 data-aos="fade-down"><?= esc_html($title); ?></h2>
                        <p data-aos="flash" data-aos-delay="1000"><?= esc_html($description); ?></p>
                        <a href="#down" data-aos="fade-up" data-aos-delay="1200"><svg xmlns="http://www.w3.org/2000/svg" height="40px" viewBox="0 -960 960 960" width="40px" fill="#ffffff"><path d="M480-80 200-360l56-57 184 184v-287h80v287l184-183 56 56L480-80Zm-40-520v-120h80v120h-80Zm0-200v-80h80v80h-80Z"/></svg></a>
                    </div><!-- carousel-caption -->
                </div><!-- carousel-item -->
                <?php $first_slide = false; ?>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        <?php else : ?>
            <p>No slides available.</p>
        <?php endif; ?>
    </div><!-- carousel-inner -->

    <!-- Controls -->
    <button class="carousel-control-prev d-none" type="button" data-bs-target="#carouselExampleFade" data-bs-slide="prev">
        <span class="carousel-control-prev-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Previous</span>
    </button>
    <button class="carousel-control-next d-none" type="button" data-bs-target="#carouselExampleFade" data-bs-slide="next">
        <span class="carousel-control-next-icon" aria-hidden="true"></span>
        <span class="visually-hidden">Next</span>
    </button>
</div><!-- carouselExampleFade -->

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const carousel = document.getElementById('carouselExampleFade');
        const videos = carousel.querySelectorAll('video');

        carousel.addEventListener('slide.bs.carousel', function (event) {
            // Pause all videos
            videos.forEach(video => video.pause());

            // Autoplay video if the new slide contains one
            const nextSlide = event.relatedTarget;
            const video = nextSlide.querySelector('video');
            if (video) {
                video.play();
            }
        });
    });
</script>
