<?php
function project_show_list_shortcode($atts) {
    // Shortcode attributes
    $atts = shortcode_atts(array(
        'category' => 'current-projects',
        'order'    => 'DESC',
        'per_page' => -1 // Show all by default
    ), $atts, 'project-show-list');

    // Build query
    $query_args = array(
        'post_type'      => 'page',
        'posts_per_page' => $atts['per_page'],
        'orderby'        => 'date',
        'order'          => $atts['order'],
    );

    if (!empty($atts['category'])) {
        $query_args['tax_query'] = array(
            array(
                'taxonomy' => 'page_category',
                'field'    => 'slug',
                'terms'    => $atts['category'],
            ),
        );
    }

    $query = new WP_Query($query_args);

    ob_start();

    if ($query->have_posts()) :
        echo '<div class="project-list-container">';
        echo '<ul class="project-list">';
        while ($query->have_posts()) : $query->the_post();
            $thumb = get_the_post_thumbnail_url(get_the_ID(), 'thumbnail');
            ?>
            <li class="project-list-item">
                <div class="project-list-content">
                    <h3 class="project-list-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                </div>
            </li>
            <?php
        endwhile;
        echo '</ul>';
        echo '</div>';
    else :
        echo '<p>No projects found.</p>';
    endif;

    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('project-show-list', 'project_show_list_shortcode');

/**
 * Current Projects Shortcode
 */
function current_projects_shortcode($atts) {
    $atts = shortcode_atts(array(
        'number'  => 6,
        'order'   => 'DESC',
    ), $atts, 'current-projects');
    
    $query_args = array(
        'post_type'      => 'page',
        'posts_per_page' => $atts['number'],
        'orderby'        => 'date',
        'order'          => $atts['order'],
        'tax_query'      => array(
            array(
                'taxonomy' => 'page_category',
                'field'    => 'slug',
                'terms'    => 'current-projects',
            ),
        ),
    );
    
    $query = new WP_Query($query_args);
    
    ob_start();
    
    if ($query->have_posts()) : ?>
       <div class="row">
            <?php while ($query->have_posts()) : $query->the_post(); 
                $thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                $excerpt = get_the_excerpt();
            ?>
            <div class="col-md-4">
                <article class="project-card">
                    <a href="<?php the_permalink(); ?>" class="project-card-link">
                        <div class="project-image">
                            <?php if ($thumbnail) : ?>
                                <img src="<?php echo esc_url($thumbnail); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
                            <?php else : ?>
                                <div class="project-image-placeholder"></div>
                            <?php endif; ?>
                        </div>
                        <div class="project-content">
                            <h3 class="project-title"><?php the_title(); ?></h3>
                            <div class="project-excerpt"><?php echo wp_trim_words($excerpt, 20); ?></div>
                            <span class="project-link">View Details</span>
                        </div>
                    </a>
                </article>
            </div>
            <?php endwhile; ?>
        </div>

    <?php else : ?>
        <p class="no-projects">No current projects found.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('current-projects', 'current_projects_shortcode');

/**
 * Past Projects Shortcode
 */
function past_projects_shortcode($atts) {
    $atts = shortcode_atts(array(
        'number'  => 6,
        'order'   => 'DESC',
    ), $atts, 'past-projects');
    
    $query_args = array(
        'post_type'      => 'page',
        'posts_per_page' => $atts['number'],
        'orderby'        => 'date',
        'order'          => $atts['order'],
        'tax_query'      => array(
            array(
                'taxonomy' => 'page_category',
                'field'    => 'slug',
                'terms'    => 'past-projects',
            ),
        ),
    );
    
    $query = new WP_Query($query_args);
    
    ob_start();
    
    if ($query->have_posts()) : ?>
         <div class="row">
            <?php while ($query->have_posts()) : $query->the_post(); 
                $thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                $excerpt = get_the_excerpt();
            ?>
            <div class="col-md-4">
                <article class="project-card">
                    <a href="<?php the_permalink(); ?>" class="project-card-link">
                        <div class="project-image">
                            <?php if ($thumbnail) : ?>
                                <img src="<?php echo esc_url($thumbnail); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
                            <?php else : ?>
                                <div class="project-image-placeholder"></div>
                            <?php endif; ?>
                        </div>
                        <div class="project-content">
                            <h3 class="project-title"><?php the_title(); ?></h3>
                            <div class="project-excerpt"><?php echo wp_trim_words($excerpt, 20); ?></div>
                            <span class="project-link">View Details</span>
                        </div>
                    </a>
                </article>
            </div>
            <?php endwhile; ?>
        </div>
    <?php else : ?>
        <p class="no-projects">No past projects found.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('past-projects', 'past_projects_shortcode');