<?php
 function pastpresident_shortcode($atts) {
    // Define shortcode attributes, if needed
    $atts = shortcode_atts(
        array(
            'category' => 'past-presidents', // Default to empty string if not specified
            'number' => -1, // Default number of posts per page
            'order' => 'DESC', //Default Descending order
        ),
        $atts,
        'team'
    );

    // Custom query to retrieve Teams
    $teams_args = array(
        'post_type' => 'team',
        'posts_per_page' => $atts['number'], // Number of posts per page
        'orderby' => 'date', // Order by date
        'order' => $atts['order'], // order
    );

    // Check if category attribute is provided and not empty
    if (!empty($atts['category'])) {
        $teams_args['tax_query'] = array(
            array(
                'taxonomy' => 'team_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $teams_query = new WP_Query($teams_args);

    ob_start();

    // Check if there are upcoming existing members
    if ($teams_query->have_posts()) : ?>
        <div class="row"> 
        <?php
        while ($teams_query->have_posts()) : $teams_query->the_post();
            $post_id = get_the_ID();

            $designation       = get_post_meta(get_the_ID(), '_designation', true);
            // $excerpt = get_post_meta(get_the_ID(), '_excerpt', true);
            $phone          = get_post_meta(get_the_ID(), '_phone', true);
            $email          = get_post_meta(get_the_ID(), '_email', true);
            $organization     = get_post_meta(get_the_ID(), '_organization', true);
            $website        = get_post_meta(get_the_ID(), '_website', true);
            $facebook       = get_post_meta(get_the_ID(), '_facebook', true);
            $linkedin       = get_post_meta(get_the_ID(), '_linkedin', true);
            $instagram      = get_post_meta(get_the_ID(), '_instagram', true);
            $x              = get_post_meta(get_the_ID(), '_x', true);
            $whatsapp       = get_post_meta(get_the_ID(), '_whatsapp', true);
           
            ?>

            <div class="col-xl-3 col-lg-3 col-md-4 col-sm-6 team">
                <div class="card border-0" data-aos="fade-up">
                    <div class="justify-content-between" data-bs-toggle="modal" data-bs-target="#teamModal-<?= $post_id; ?>">
                      
                        <div class="post-thumbnail">
                            <span aria-hidden="true" class="wp-block-cover__background has-background-dim-90 has-background-dim wp-block-cover__gradient-background has-background-gradient" style="background:linear-gradient(180deg,rgba(0,0,0,0) 0%,rgb(5,5,5) 67%); position: relative; z-index: 90;"></span>
                            <?php // Display the post thumbnail
                                if (has_post_thumbnail()) {
                                    the_post_thumbnail(); 
                                } else {
                                    echo '<img src="'. get_template_directory_uri().'/assets/images/placeholder-image.jpg" alt="HPLNOU" class="img-fluid"/>';
                                }
                            ?>
                        </div><!-- thumbnail !-->
                    
                       
                        <div class="team-details">
                            <h4><?php the_title(); ?></h4>
                            <!--<p class="orgn"><strong>Org: </strong>(<?php echo esc_html($organization); ?>)</p>-->
                            <p class="desig"><?php the_excerpt(); ?></p>
                            <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#teamModal-<?= $post_id; ?>">Full Profile</button>
                        </div><!-- team details !-->
                   
                    </div>
                </div><!-- card !-->
            </div><!-- col !-->
            
            <!-- Full Profile Modal -->
            <div class="modal fade member-details teamPop" id="teamModal-<?= $post_id; ?>" tabindex="-1" aria-labelledby="teamModalLabel-<?= $post_id; ?>" aria-hidden="true" style="">
            <div class="modal-dialog modal-lg">
                <div class="row g-0">
                    <div class="col-sm-6">
                        <?php // Display the post thumbnail
                            if (has_post_thumbnail()) {
                                the_post_thumbnail(); 
                            } else {
                                echo '<img src="'. get_template_directory_uri().'/assets/images/placeholder-image.jpg" alt="NHP" class="img-fluid"/>';
                            }
                        ?>
                    </div><!-- col image !-->
                    <div class="col-sm-6">
                        <div class="modal-content border-0 rounded-0 h-100">
                            <button type="button" class="btn-close btx" data-bs-dismiss="modal" aria-label="Close"></button>
                            <div class="modal-body">
                                <h4 class="modal-title" id="teamModalLabel-<?= $post_id; ?>"><?php the_title(); ?></h4>
                               <small class = "text-danger p-0"><?php echo esc_html(the_excerpt()); ?></small>
                                <p><?php the_content(); ?></p>
                            </div><!-- modal body !-->
                        </div>
                    </div><!-- col details !-->
                </div><!-- row !-->
            </div><!-- modal-dialog !-->
            </div><!-- modal !-->
            <?php
        endwhile;
        wp_reset_postdata();
    else :
        echo 'No Team Members found.';
        
    endif;?>
    </div>
 <?php   
    return ob_get_clean();
}

add_shortcode('past-presidents', 'pastpresident_shortcode');