<?php

//Home Latest News 
function homeNews_shortcode($atts) {
    ob_start(); // Start output buffering
 
    	$news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 3,
		'category_name' => 'news, blog',
		);
    $news_query = new WP_Query($news_args);

    if ($news_query->have_posts()) : ?>
            <?php while ($news_query->have_posts()) :
                $news_query->the_post();
            ?>
            <article>
                <div class="kpy-front-news border-0 mb-2" data-aos="fade-up">
                    <div class="row" data-aos="fade-up">
                        <div class="col-8 ">
                            <a href="<?= esc_url(get_permalink()); ?>">
                                <div class="catz">
                                    <?php echo get_the_date(); ?>
                                </div>
                                <h4><?php the_title(); ?></h4>
                            </a>
                        </div>
                        <div class="col-4 d-flex justify-content-end ">
                            <a href="<?= esc_url(get_permalink()); ?>">
                                <?php 
                                    if (has_post_thumbnail()) {
                                        the_post_thumbnail('thumbnail', ['class' => 'img-fluid']); 
                                    } else {
                                        echo '<img src="' . get_template_directory_uri() . '/assets/images/default-featured.jpg" alt="Default Image" class="img-fluid"/>';
                                    }
                                ?>
                            </a>
                        </div>
                    </div>
                </div>
            </article>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
    <?php else : ?>
        <p>No news found.</p>
    <?php endif;

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('home-news', 'homeNews_shortcode');

//Other Latest News 
function otherNews_shortcode($atts) {
    ob_start(); // Start output buffering

	$news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 3,
		'category_name' => 'news, blog',
		);
	?>																
	<?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			
				<article>
                    <a href="<?= esc_url(get_permalink()); ?>" class="p-0"> 
                        <div class="card card-body kpy-other-news border-0 mb-2" data-aos="fade-up">
                            <div class="row">
                                <div class="col-8">
                                    <div class="catz">
									    <i class="bi bi-calendar-check"></i> <?php
                                        $post_date = get_the_date();
                                        echo $post_date;
                                        ?>
                                    </div><!-- Date !-->
                                    <h3><?php the_title(); ?></h3>
                                    <a href="<?= esc_url(get_permalink()); ?>" class="read-more btn btn-outline-info">Read More</a>
                                </div>
                                <div class="col-4">
                                    <div class="post-thumbnail">
                                        <?php // Display the post thumbnail
                                            if (has_post_thumbnail()) {
                                                the_post_thumbnail('medium'); 
                                            }else{
                                                echo '<img src="'. get_template_directory_uri().'/assets/images/default-featured.jpg" alt="jC" class="img-fluid"/>';
                                            }
                                        ?> 
                                    </div>
                                </div>
                            </div>
                        </div>
						</a>

				</article>
			 
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php
    return ob_get_clean(); // Return the buffered content
}
// Register the shortcode
add_shortcode('other-news', 'otherNews_shortcode');