<?php
function rotary_membership_form_shortcode($atts) {
    $atts = shortcode_atts(array(
        // 'admin_email' => get_option('admin_email'),
        'admin_email' =>'desmondbenja@gmail.com',
        'success_message' => 'Thank you for your interest! We will contact you within 48 hours.',
    ), $atts);
    
    ob_start();
    
    // Process form submission
    if (isset($_POST['submit_rotary_membership']) && wp_verify_nonce($_POST['rotary_membership_nonce'], 'rotary_membership_form')) {
        $result = process_rotary_membership_form($atts['admin_email']);
        if ($result['success']) {
            echo '<div class="alert alert-success alert-dismissible fade show" role="alert">' . esc_html($atts['success_message']) . '<button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>';
        } else {
            echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">' . esc_html($result['message']) . '<button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>';
        }
    }
    ?>
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-8">
                <div class="card shadow-lg border-0 rotary-form-card">
                    <div class="card-header bg-primary text-white text-center py-4">
                        <h2 class="card-title mb-3">Rotary Club of Iganga – Membership Interest Form</h2>
                        <p class="mb-0 lead">Thank you for your interest in joining the Rotary Club of Iganga. Please fill in the form below to register your interest. Our team will follow up with you for the next steps.</p>
                    </div>
                    
                    <div class="card-body p-4">
                        <form method="post" class="needs-validation" novalidate id="rotaryMembershipForm">
                            <?php wp_nonce_field('rotary_membership_form', 'rotary_membership_nonce'); ?>
                            
                            <!-- Section 1: Personal Information -->
                            <div class="mb-5">
                                <h4 class="section-title mb-4">
                                    <span class="badge bg-primary rounded-pill me-2">1</span>
                                    Personal Information
                                </h4>
                                
                                <div class="row g-3">
                                    <div class="col-12">
                                        <label for="full_name" class="form-label">Full Name <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control form-control-lg" id="full_name" name="full_name" required>
                                        <div class="invalid-feedback">Please provide your full name.</div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                                        <input type="email" class="form-control" id="email" name="email" required>
                                        <div class="invalid-feedback">Please provide a valid email address.</div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label for="phone" class="form-label">Phone Number <span class="text-danger">*</span></label>
                                        <input type="tel" class="form-control" id="phone" name="phone" required>
                                        <div class="invalid-feedback">Please provide your phone number.</div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label for="date_of_birth" class="form-label">Date of Birth</label>
                                        <input type="date" class="form-control" id="date_of_birth" name="date_of_birth">
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label class="form-label">Gender</label>
                                        <div class="mt-2">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="gender" id="gender_male" value="Male">
                                                <label class="form-check-label" for="gender_male">Male</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="gender" id="gender_female" value="Female">
                                                <label class="form-check-label" for="gender_female">Female</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" name="gender" id="gender_not_say" value="Prefer not to say">
                                                <label class="form-check-label" for="gender_not_say">Prefer not to say</label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label for="occupation" class="form-label">Occupation/Profession <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="occupation" name="occupation" required>
                                        <div class="invalid-feedback">Please provide your occupation.</div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <label for="organization" class="form-label">Organization (if applicable)</label>
                                        <input type="text" class="form-control" id="organization" name="organization">
                                    </div>
                                    
                                    <div class="col-12">
                                        <label for="location" class="form-label">Location/District <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="location" name="location" required>
                                        <div class="invalid-feedback">Please provide your location.</div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Section 2: Membership Category -->
                            <div class="mb-5">
                                <h4 class="section-title mb-4">
                                    <span class="badge bg-primary rounded-pill me-2">2</span>
                                    Preferred Membership Category
                                </h4>
                                
                                <div class="row g-3">
                                    <div class="col-12">
                                        <div class="form-check p-3 border rounded membership-option">
                                            <input class="form-check-input" type="radio" name="membership_category" id="active_member" value="Active Member">
                                            <label class="form-check-label w-100" for="active_member">
                                                <strong>Active Member</strong><br>
                                                <small class="text-muted">Full participant in club activities, projects, and decision-making.</small>
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="form-check p-3 border rounded membership-option">
                                            <input class="form-check-input" type="radio" name="membership_category" id="honorary_member" value="Honorary Member">
                                            <label class="form-check-label w-100" for="honorary_member">
                                                <strong>Honorary Member</strong><br>
                                                <small class="text-muted">Recognition for meritorious service or contribution to Rotary ideals. No dues required.</small>
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="form-check p-3 border rounded membership-option">
                                            <input class="form-check-input" type="radio" name="membership_category" id="corporate_member" value="Corporate Membership">
                                            <label class="form-check-label w-100" for="corporate_member">
                                                <strong>Corporate Membership</strong><br>
                                                <small class="text-muted">Representing an organization/business within Rotary.</small>
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="form-check p-3 border rounded membership-option">
                                            <input class="form-check-input" type="radio" name="membership_category" id="eclub_member" value="E-Club Member">
                                            <label class="form-check-label w-100" for="eclub_member">
                                                <strong>E-Club Member</strong><br>
                                                <small class="text-muted">Participating mainly through online meetings.</small>
                                            </label>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="form-check p-3 border rounded membership-option">
                                            <input class="form-check-input" type="radio" name="membership_category" id="dual_member" value="Dual Membership">
                                            <label class="form-check-label w-100" for="dual_member">
                                                <strong>Dual Membership (Rotaract + Rotary)</strong><br>
                                                <small class="text-muted">Belong to both Rotaract and Rotary clubs.</small>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Section 3: Areas of Interest -->
                            <div class="mb-5">
                                <h4 class="section-title mb-4">
                                    <span class="badge bg-primary rounded-pill me-2">3</span>
                                    Areas of Interest in Rotary Service
                                </h4>
                                
                                <div class="row g-2">
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Community Development" id="interest1">
                                            <label class="form-check-label" for="interest1">Community Development</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Youth Empowerment" id="interest2">
                                            <label class="form-check-label" for="interest2">Youth Empowerment</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Health and WASH" id="interest3">
                                            <label class="form-check-label" for="interest3">Health and WASH</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Education and Literacy" id="interest4">
                                            <label class="form-check-label" for="interest4">Education and Literacy</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Environmental Protection" id="interest5">
                                            <label class="form-check-label" for="interest5">Environmental Protection</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Vocational Training" id="interest6">
                                            <label class="form-check-label" for="interest6">Vocational Training</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Peacebuilding and Conflict Resolution" id="interest7">
                                            <label class="form-check-label" for="interest7">Peacebuilding and Conflict Resolution</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="interests[]" value="Fundraising and Partnerships" id="interest8">
                                            <label class="form-check-label" for="interest8">Fundraising and Partnerships</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Section 4: Motivation -->
                            <div class="mb-5">
                                <h4 class="section-title mb-4">
                                    <span class="badge bg-primary rounded-pill me-2">4</span>
                                    Why Do You Want to Join Rotary?
                                </h4>
                                
                                <div class="col-12">
                                    <label for="motivation" class="form-label">Please share a short motivation statement below</label>
                                    <textarea class="form-control" id="motivation" name="motivation" rows="5" placeholder="Share your reasons for wanting to join Rotary Club of Iganga..."></textarea>
                                </div>
                            </div>
                            
                            <!-- Section 5: Declaration -->
                            <div class="mb-4">
                                <h4 class="section-title mb-4">
                                    <span class="badge bg-primary rounded-pill me-2">5</span>
                                    Declaration
                                </h4>
                                
                                <div class="row g-3">
                                    <div class="col-12">
                                        <div class="form-check p-3 bg-light rounded">
                                            <input class="form-check-input" type="checkbox" name="declaration_truth" value="yes" id="declaration1" required>
                                            <label class="form-check-label" for="declaration1">
                                                I confirm that the information provided above is true and complete to the best of my knowledge.
                                            </label>
                                            <div class="invalid-feedback">You must confirm the accuracy of your information.</div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-12">
                                        <div class="form-check p-3 bg-light rounded">
                                            <input class="form-check-input" type="checkbox" name="declaration_understanding" value="yes" id="declaration2" required>
                                            <label class="form-check-label" for="declaration2">
                                                I understand that submission of this form does not guarantee automatic membership.
                                            </label>
                                            <div class="invalid-feedback">You must acknowledge the membership process.</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="text-center pt-4 border-top">
                                <button type="submit" name="submit_rotary_membership" class="btn btn-primary btn-lg px-5 py-3">
                                    <i class="fas fa-paper-plane me-2"></i>Submit Application
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
    // Bootstrap form validation
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            var forms = document.getElementsByClassName('needs-validation');
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
    </script>
    
    <?php
    return ob_get_clean();
}
add_shortcode('rotary_membership_form', 'rotary_membership_form_shortcode');

// Process form submission with Reply-To functionality
function process_rotary_membership_form($admin_email) {
    // Sanitize and validate input
    $full_name = sanitize_text_field($_POST['full_name']);
    $email = sanitize_email($_POST['email']);
    $phone = sanitize_text_field($_POST['phone']);
    $date_of_birth = sanitize_text_field($_POST['date_of_birth']);
    $gender = sanitize_text_field($_POST['gender']);
    $occupation = sanitize_text_field($_POST['occupation']);
    $organization = sanitize_text_field($_POST['organization']);
    $location = sanitize_text_field($_POST['location']);
    $membership_category = sanitize_text_field($_POST['membership_category']);
    $interests = isset($_POST['interests']) ? array_map('sanitize_text_field', $_POST['interests']) : array();
    $motivation = sanitize_textarea_field($_POST['motivation']);
    
    // Email content
    $subject = 'New Rotary Club Membership Application - ' . $full_name;
    
    // Create styled HTML email
    $message = '
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; margin: 0; padding: 20px; background-color: #f8f9fa; }
            .container { max-width: 600px; margin: 0 auto; background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden; }
            .header { background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%); color: white; padding: 30px; text-align: center; }
            .header h1 { margin: 0; font-size: 24px; font-weight: bold; }
            .header p { margin: 10px 0 0 0; opacity: 0.9; }
            .content { padding: 30px; }
            .section { margin-bottom: 30px; }
            .section-title { color: #1e3c72; font-size: 18px; font-weight: bold; margin-bottom: 15px; padding-bottom: 8px; border-bottom: 2px solid #e9ecef; display: flex; align-items: center; }
            .section-title::before { content: ""; margin-right: 10px; font-size: 20px; }
            .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 20px; }
            .info-item { background: #f8f9fa; padding: 15px; border-radius: 8px; border-left: 4px solid #1e3c72; }
            .info-label { font-weight: bold; color: #1e3c72; font-size: 14px; margin-bottom: 5px; }
            .info-value { color: #333; font-size: 16px; }
            .interests-list { display: flex; flex-wrap: wrap; gap: 8px; margin-top: 10px; }
            .interest-tag { background: #e3f2fd; color: #1565c0; padding: 6px 12px; border-radius: 20px; font-size: 14px; border: 1px solid #bbdefb; }
            .motivation-box { background: #f8f9fa; padding: 20px; border-radius: 8px; border-left: 4px solid #28a745; margin-top: 15px; }
            .contact-section { background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 20px; border-radius: 8px; }
            .contact-section .section-title { color: white; border-bottom-color: rgba(255,255,255,0.3); }
            .contact-section .section-title::before { content: ""; }
            .footer { background: #f8f9fa; padding: 20px; text-align: center; color: #666; font-size: 14px; }
            .highlight { background: #fff3cd; padding: 15px; border-radius: 8px; border-left: 4px solid #ffc107; margin: 20px 0; }
            @media (max-width: 600px) {
                .info-grid { grid-template-columns: 1fr; }
                .content { padding: 20px; }
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1> New Membership Application</h1>
                <p>Rotary Club of Iganga</p>
            </div>
            
            <div class="content">
                <div class="highlight">
                    <strong>Application from:</strong> ' . esc_html($full_name) . '<br>
                    <strong> Submitted:</strong> ' . current_time('F j, Y \a\t g:i A') . '
                </div>
                
                <div class="section">
                    <div class="section-title">Personal Information</div>
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-user"></i> Full Name</div>
                            <div class="info-value">' . esc_html($full_name) . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-envelope"></i> Email Address</div>
                            <div class="info-value">' . esc_html($email) . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-phone"></i> Phone Number</div>
                            <div class="info-value">' . esc_html($phone) . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-birthday-cake"></i> Date of Birth</div>
                            <div class="info-value">' . ($date_of_birth ? esc_html($date_of_birth) : 'Not provided') . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-venus-mars"></i> Gender</div>
                            <div class="info-value">' . ($gender ? esc_html($gender) : 'Not specified') . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-briefcase"></i> Occupation</div>
                            <div class="info-value">' . esc_html($occupation) . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-building"></i> Organization</div>
                            <div class="info-value">' . ($organization ? esc_html($organization) : 'Not provided') . '</div>
                        </div>
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-map-marker-alt"></i> Location</div>
                            <div class="info-value">' . esc_html($location) . '</div>
                        </div>
                    </div>
                </div>
                
                <div class="section">
                    <div class="section-title" style="color: #6f42c1;">Membership Preference</div>
                    <div class="info-item" style="border-left-color: #6f42c1; background: #f8f6ff;">
                        <div class="info-label" style="color: #6f42c1;"><i class="fas fa-bullseye"></i> Preferred Category</div>
                        <div class="info-value">' . ($membership_category ? esc_html($membership_category) : 'Not selected') . '</div>
                    </div>
                </div>
                
                <div class="section">
                    <div class="section-title" style="color: #e83e8c;">Areas of Interest</div>';
    
    if (!empty($interests)) {
        $message .= '<div class="interests-list">';
        foreach ($interests as $interest) {
            $message .= '<span class="interest-tag">' . esc_html($interest) . '</span>';
        }
        $message .= '</div>';
    } else {
        $message .= '<div class="info-item" style="border-left-color: #dc3545; background: #fff5f5;">
                        <div class="info-value" style="color: #dc3545;">No specific interests selected</div>
                     </div>';
    }
    
    $message .= '</div>
                
                <div class="section">
                    <div class="section-title" style="color: #28a745;">Motivation Statement</div>';
    
                        if ($motivation) {
        $message .= '<div class="motivation-box">
                        <div class="info-label" style="color: #28a745;"><i class="fas fa-lightbulb"></i> Why they want to join Rotary:</div>
                        <div class="info-value" style="margin-top: 10px; font-style: italic;">"' . nl2br(esc_html($motivation)) . '"</div>
                     </div>';
    } else {
        $message .= '<div class="info-item" style="border-left-color: #ffc107; background: #fffdf0;">
                        <div class="info-value" style="color: #856404;">No motivation statement provided</div>
                     </div>';
    }
    
    $message .= '</div>
            </div>
            
            <div class="contact-section">
                <div class="section-title">Quick Contact Information</div>
                <div class="info-grid">
                    <div style="text-align: center;">
                        <div style="font-size: 24px; margin-bottom: 5px;"><i class="fas fa-envelope-open"></i></div>
                        <div style="font-weight: bold;">Email</div>
                        <div>' . esc_html($email) . '</div>
                    </div>
                    <div style="text-align: center;">
                        <div style="font-size: 24px; margin-bottom: 5px;"><i class="fas fa-mobile-alt"></i></div>
                        <div style="font-weight: bold;">Phone</div>
                        <div>' . esc_html($phone) . '</div>
                    </div>
                </div>
            </div>
            
            <div class="footer">
                <p><strong>Next Steps:</strong> Review application → Contact applicant within 48 hours → Schedule interview</p>
                <p> <em>Reply directly to this email to contact ' . esc_html($full_name) . '</em></p>
            </div>
        </div>
    </body>
    </html>';
    
    // Set up email headers with Reply-To and HTML content type
    $headers = array(
        'Content-Type: text/html; charset=UTF-8',
        'Reply-To: ' . $full_name . ' <' . $email . '>'
    );
    
    // Send email
    $mail_sent = wp_mail($admin_email, $subject, $message, $headers);
    
    if ($mail_sent) {
        return array('success' => true, 'message' => 'Application submitted successfully');
    } else {
        return array('success' => false, 'message' => 'Failed to send application. Please try again.');
    }
}
?>