<?php
function upcoming_events_front_shortcode($atts) {
    // Define shortcode attributes with defaults
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 4,
        ),
        $atts,
        'upcoming_events'
    );
    
    // Custom query to retrieve upcoming events
    $events_args = array(
        'post_type' => 'events',
        'posts_per_page' => $atts['posts_per_page'],
        'order' => 'ASC',
        'orderby' => 'meta_value',
        'meta_key' => '_start_date',
        'meta_query' => array(
            array(
                'key' => '_start_date',
                'value' => date('Y-m-d'),
                'compare' => '>=',
                'type' => 'DATE',
            ),
        ),
    );

    $events_query = new WP_Query($events_args);
    ob_start();
    
    // Check if there are upcoming events
    if ($events_query->have_posts()) :
        while ($events_query->have_posts()) : $events_query->the_post();
            $post_id = get_the_ID();
            $location = get_post_meta(get_the_ID(), '_location', true);
            $start_date = get_post_meta(get_the_ID(), '_start_date', true);
            $formatted_start_date = date('jS, F Y', strtotime($start_date));
            $excerpt = get_the_excerpt();
            $permalink = get_permalink();
            ?>
            
            <div class="row mb-4 event-item" data-aos="fade-up">
                <!-- Image Column -->
                <div class="col-md-3 col-3">
                    <div class="post-thumbnail">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('medium', array('class' => 'img-fluid')); ?>
                        <?php else : ?>
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/photo-placeholder.jpg" alt="Event Placeholder" class="img-fluid"/>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Content Column -->
                <div class="col-md-8 col-8">
                    <h2><?php the_title(); ?></h2>
                    <div class="d-flex bd-highlight">
                        <div class="bd-highlight flex-grow-1 time">
                            <span style="font-weight:600;"><small>Date:</small><br></span>
                            <?php echo esc_html($formatted_start_date); ?>
                        </div>
                        <div class="bd-highlight time">
                            <span style="font-weight:600;"><small>From:</small><br></span>
                            <?php echo esc_html($location); ?>
                        </div>
                    </div><!-- Date & Time -->
                    <span class="location" style="display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                        <?php echo wp_kses_post(get_the_excerpt()); ?>
                    </span>
                </div>
                
                <!-- Link Column -->
                <div class="col-1 align-self-center link">
                    <a href="<?php echo esc_url($permalink); ?>" data-bs-toggle="offcanvas" data-bs-target="#staticBackdrop-<?php echo $post_id; ?>" aria-controls="staticBackdrop-<?php echo $post_id; ?>">
                        <i class="bi bi-chevron-double-right fs-2"></i>
                    </a>
                </div>
            </div><!-- row -->
            
            <!-- Offcanvas Event Details -->
            <div class="offcanvas offcanvas-end kpy_event_details2" tabindex="-1" id="staticBackdrop-<?php echo $post_id; ?>" aria-labelledby="staticBackdropLabel-<?php echo $post_id; ?>">
                <?php if (has_post_thumbnail()) : ?>
                    <?php the_post_thumbnail('large', array('class' => 'img-fluid')); ?>
                <?php else : ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/photo-placeholder.jpg" alt="Event Placeholder" class="img-fluid"/>
                <?php endif; ?>
                
                <div class="offcanvas-header">
                    <h5 class="offcanvas-title" id="staticBackdropLabel"><?php the_title(); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    <div class="row mb-4">
                        <div class="col-6 time">
                            <i class="bi bi-calendar-check"></i> <?php echo esc_html($formatted_start_date); ?>
                        </div>
                        <div class="col-6 location">
                            <i class="bi bi-geo-alt"></i> <?php echo esc_html($location); ?>
                        </div>
                    </div>
                    <div>
                        <?php the_content(); ?>
                    </div>
                </div>
            </div><!-- offcanvas -->
            
            <?php
        endwhile;
        wp_reset_postdata();
    else :
        echo '<div class="col-12">Sorry! No upcoming events found.</div>';
    endif;
    
    return ob_get_clean();
}
add_shortcode('upcoming_events_front', 'upcoming_events_front_shortcode');

function upcoming_events_banner_shortcode($atts) {
    // Start output buffering
    ob_start();
    ?>
    <div class="event-banner">
        <div class="event-banner-content">
            <div class="event-banner-img">
                <img src="https://lwegatech.net/rotaryclubofiganga/wp-content/uploads/2025/05/image.jpg" alt="Event Placeholder" />
            </div>
            <div class="">
                <p class="event-date"><strong>Date:</strong> Every Tuesday at 6pm</p>
                <p class="event-location"><strong>Location:</strong> Ntinda Resort Hotel, Iganga</p>
                <a href="https://lwegatech.net/rotaryclubofiganga/upcoming-events/" class="event-link">More Details</a>
            </div>
        </div>
    </div>
    <?php
    // End output buffering and return the content
    return ob_get_clean();
}
add_shortcode('upcoming_events_banner', 'upcoming_events_banner_shortcode');

?>