<?php
function rotary_iganga_donation_form($atts) {
    $atts = shortcode_atts(array(
        'title' => 'Extend a helping hand',
        'description' => 'With your contribution, we will be able to reach more communities with our mission of empowering Ugandan communities through service and development projects.'
    ), $atts);

    ob_start(); ?>
    

    <div class="container">
        <div class="donation-form-area">
            <div class="text-center mb-5">
                <h2 class=" text-blue fw-bold"><?php echo esc_html($atts['title']); ?></h2>
                <p class="lead text-muted"><?php echo esc_html($atts['description']); ?></p>
                <p class="fw-semibold">To donate, kindly use the following details:</p>
            </div>
    
            <div class="card shadow  mb-4">
                <div class="card-header bg-primary text-white fw-bold text-center">
                    Bank Account Details
                </div>
                <div class="card-body">
                    <table class="table">
                        <tbody>
                            <tr><th scope="row">Name of Bank</th><td>Stanbic Bank Uganda</td></tr>
                            <tr><th>Address of Bank</th><td>Iganga Branch, Main Street</td></tr>
                            <tr><th>Country</th><td>Uganda</td></tr>
                            <tr><th>Account number</th><td><strong>xxxxxxxxxxx</strong></td></tr>
                            <tr><th>Account holder</th><td>Rotary Club of Iganga<br>Uganda</td></tr>
                            <tr><th>SWIFT Code</th><td>xxxxxxxx</td></tr>
                            <tr><th>Bank Code</th><td>xxx</td></tr>
                        </tbody>
                    </table>
                    <div class="bg-light p-3 rounded mt-3">
                        <strong class="text-blue">Correspondent Bank:</strong><br>
                        Standard Bank South Africa<br>
                        SWIFT ADDRESS: SBZAZAJJ<br>
                        Johannesburg, South Africa
                    </div>
                </div>
            </div>
    
            <div class="card shadow">
                <div class="card-body">
                    <h5 class="text-center text-blue fw-bold mb-4">
                        Please complete the form below after making your donation
                    </h5>
                    <form id="rotary-donation-form" method="post" enctype="multipart/form-data">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label" for="project">Project *</label>
                                <select class="form-select" name="project" id="project" required>
                                    <option value="">--Select--</option>
                                    <option value="community-water">Community Water Projects</option>
                                    <option value="education-support">Education Support</option>
                                    <option value="health-initiatives">Health Initiatives</option>
                                    <option value="youth-empowerment">Youth Empowerment</option>
                                    <option value="environmental-projects">Environmental Projects</option>
                                    <option value="disaster-relief">Disaster Relief</option>
                                    <option value="general-fund">General Fund</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label" for="donor-type">Donor Type *</label>
                                <select class="form-select" name="donor_type" id="donor-type" required>
                                    <option value="Individual">Individual</option>
                                    <option value="Organisation">Organisation</option>
                                    <option value="Company">Company</option>
                                    <option value="Foundation">Foundation</option>
                                </select>
                            </div>
                        </div>
    
                        <div class="mb-3">
                            <label class="form-label" for="donor-name">Name *</label>
                            <input type="text" class="form-control" name="donor_name" id="donor-name" required>
                        </div>
    
                        <div class="mb-3">
                            <label class="form-label" for="email">Email *</label>
                            <input type="email" class="form-control" name="email" id="email" required>
                        </div>
    
                        <div class="mb-3">
                            <label class="form-label" for="phone">Phone</label>
                            <div class="input-group">
                               <span class="input-group-text back-gold text-white fw-bold">🇺🇬 +256</span>
                                <input type="tel" class="form-control" name="phone" id="phone" placeholder="712 345678">
                            </div>
                        </div>
    
                        <div class="mb-3">
                            <label class="form-label" for="amount">Donation Amount (UGX)</label>
                            <input type="text" class="form-control" name="amount" id="amount" placeholder="e.g., 100,000">
                        </div>
    
                        <div class="mb-3">
                            <label class="form-label" for="payment-reference">Payment Reference</label>
                            <div class="custom-border p-4 text-center rounded" onclick="document.getElementById('payment-reference').click();">
                                <strong>Choose File</strong><br>
                                <small>Upload your bank receipt or payment confirmation</small>
                                <div id="file-name" class="text-muted mt-2"></div>
                                <input type="file" name="payment_reference" id="payment-reference" accept=".pdf,.jpg,.jpeg,.png" style="display: none;">
                            </div>
                        </div>
    
                        <div class="mb-3">
                            <label class="form-label" for="additional-info">Additional Information</label>
                            <textarea class="form-control" name="additional_info" id="additional-info" rows="4" placeholder="Any comments or instructions..."></textarea>
                        </div>
    
                        <button type="submit" class="btn btn-primary w-100 fw-bold">Submit Donation Information</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
    document.getElementById('payment-reference').addEventListener('change', function(e) {
        var fileName = e.target.files[0] ? e.target.files[0].name : 'No file chosen';
        document.getElementById('file-name').textContent = fileName;
    });

    document.getElementById('rotary-donation-form').addEventListener('submit', function(e) {
        e.preventDefault();
        alert('Thank you for your donation! We will contact you shortly to confirm receipt.');
        // You can integrate AJAX here or redirect
    });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('rotary_iganga_donation', 'rotary_iganga_donation_form');
?>
