<?php
function contact_page_shortcode() {
    ob_start(); ?>

    <div class="row contact-page">
        <!-- Contact Form -->
        <div class="col-md-6 contact-form">
            <h3>Send Us a Message</h3>
            <form method="post" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>">
                <div class="form-group">
                    <input type="text" name="cf_name" class="form-control" placeholder="Your Name" required>
                </div>
                <div class="form-group">
                    <input type="email" name="cf_email" class="form-control" placeholder="Your Email" required>
                </div>
                <div class="form-group">
                    <input type="text" name="cf_subject" class="form-control" placeholder="Subject" required>
                </div>
                <div class="form-group">
                    <textarea name="cf_message" class="form-control" placeholder="Your Message" rows="5" required></textarea>
                </div>
                <button type="submit" name="cf_submitted" class="btn btn-primary">Send Message</button>
            </form>

            <?php
            // Form submission handling
            if (isset($_POST['cf_submitted'])) {
                $name    = sanitize_text_field($_POST['cf_name']);
                $email   = sanitize_email($_POST['cf_email']);
                $subject = sanitize_text_field($_POST['cf_subject']);
                $message = esc_textarea($_POST['cf_message']);

                $to = get_option('admin_email');
                $headers = "From: $name <$email>" . "\r\n";

                wp_mail($to, $subject, $message, $headers);

                echo '<div class="alert alert-success mt-3">Thank you for contacting us. We will get back to you shortly.</div>';
            }
            ?>
        </div>

        <!-- Contact Info -->
        <div class="col-md-6 contact-info">
            <h3>Contact Details</h3>
            <ul class="list-unstyled">
                <li><strong>Address:</strong>  Rotary Club Iganga</li>
                <li><strong>Phone:</strong> +254 000 000 000</li>
                <li><strong>Email:</strong> <a href="mailto:info@rotaryexample.org">info@rotaryiganga.org</a></li>
            </ul>
            <div class="map-container mt-3">
                <iframe src="https://maps.google.com/maps?q=iganga&t=&z=13&ie=UTF8&iwloc=&output=embed" width="100%" height="250" frameborder="0" style="border:0;" allowfullscreen=""></iframe>
            </div>
        </div>
    </div>

    <?php return ob_get_clean();
}
add_shortcode('contact_page', 'contact_page_shortcode');
