<?php
function clubs_shortcode($atts) {
    // Define shortcode attributes
    $atts = shortcode_atts(
        array(
            'category' => 'club',
            'number' => 3,
            'order' => 'ASC',
        ),
        $atts,
        'directory'
    );

    // Custom query to retrieve Directory
    $directory_args = array(
        'post_type' => 'directory',
        'posts_per_page' => $atts['number'],
        'orderby' => 'name',
        'order' => $atts['order'],
    );

    // Check if category attribute is provided and not empty
    if (!empty($atts['category'])) {
        $directory_args['tax_query'] = array(
            array(
                'taxonomy' => 'directory_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $directory_query = new WP_Query($directory_args);

    // Start output buffer
    ob_start();

    if ($directory_query->have_posts()) :
    ?>
        <div class="row publications">
            <?php
            $count = 0;
            while ($directory_query->have_posts()) : $directory_query->the_post();
                $post_id = get_the_ID();

                // Gather post meta
                $address = get_post_meta($post_id, '_address', true);
                $district = get_post_meta($post_id, '_district', true);
                $website = get_post_meta($post_id, '_website', true);
                $cpname = get_post_meta($post_id, '_cpname', true);
                $position = get_post_meta($post_id, '_position', true);
                $cpphone = get_post_meta($post_id, '_cpphone', true);
                $cpemail = get_post_meta($post_id, '_cpemail', true);
                $permalink = get_permalink($post_id);

                if ($count == 0) {
                    // First club - full width with big image and text below
                    echo '<div class="col-md-6 first-club">';
                    ?>
                    <div class="club-item mb-4">
                        <div class="member-thumbnail text-center mb-3">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('large', ['class' => 'img-fluid']);
                            } else {
                                echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder.png" alt="NHP Platform" class="img-fluid"/>';
                            } ?>
                        </div>
                        <div class="club-content text-center">
                            <a href="<?= esc_url($permalink) ?>"><h3 class="member-title mb-2"><?= get_the_title(); ?></h3></a>
                            <h4 class="pub-summ">Area of Focus</h4>
                            <div class="pub-desc"><?= apply_filters('the_content', get_the_content()); ?></div>
                            <div class="member-summ py-2">
                                <div class="member-link">
                                    <a href="<?= esc_url($permalink) ?>" class="btn btn-primary">Read More</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    echo '</div>';
                    echo '<div class="col-md-6">';
                } else {
                    // Other clubs - regular layout
                    include_club_markup($permalink);
                }

                $count++;
            endwhile;

            // Close the second column if we opened it
            if ($count > 1) {
                echo '</div>';
            }
            ?>
        </div>
    <?php
    endif;

    // Clean output buffer and return content
    return ob_get_clean();
}

// Helper function to output club markup (for non-first clubs)
function include_club_markup($permalink) {
    ?>
    <div class="club-item mb-4">
        <div class="row">
            <div class="col-md-4">
                <div class="member-thumbnail">
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail('medium', ['class' => 'img-fluid']);
                    } else {
                        echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder.png" alt="NHP Platform" class="img-fluid"/>';
                    } ?>
                </div>
            </div>
            <div class="col-md-8">
                <a href="<?= esc_url($permalink) ?>"><h4 class="member-title mb-2"><?= get_the_title(); ?></h4></a>
                <div class="member-summ py-1">
                    <div class="member-link"><a href="<?= esc_url($permalink) ?>">read more</a></div>
                </div>
            </div>
        </div>
    </div>
    <?php
}

add_shortcode('clubs', 'clubs_shortcode');
