<?php
function allNews_shortcode() {
    ob_start(); // Start output buffering

	$news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 20,
		'category_name' => 'news, blog',
		);
	?>																
	<?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			<div class="col-xl-3 col-lg-4 col-sm-6 kpy-news">
				<article>
					<a href="<?= esc_url(get_permalink()); ?>">
						<div class="card shadow-sm mb-3 border-0 h-100" data-aos="fade-up">
							<div class="post-thumbnail">
								<?php // Display the post thumbnail
									if (has_post_thumbnail()) {
										the_post_thumbnail('medium'); 
									}else{
										echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="NGO" class="img-fluid"/>';
									}
								?>
								
							</div>
							<div class="card-body">
								<h3><?php the_title(); ?></h3>
								<div class="catz">
									<i class="bi bi-calendar-check"></i> <?php
									$post_date = get_the_date();
									echo $post_date;
									?>
								</div><!-- Date !-->
								<a href="<?= esc_url(get_permalink()); ?>" class="btn btn-outline-info read-more">Read More</a>
							</div><!-- card body !-->
						</div><!-- card !-->
						</a>
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('all_news', 'allNews_shortcode');

?>