<?php
function allPackages_shortcode($atts) {
	// Parse shortcode attributes
    $atts = shortcode_atts(array(
        'categories' => '', // Comma-separated category slugs
        'exclude' => '',    // Post ID to exclude
        'posts_per_page' => -1, // Number of posts to display
    ), $atts);

    // Get the current post ID to exclude by default if not specified
    $exclude_id = !empty($atts['exclude']) ? $atts['exclude'] : get_the_ID();

    // Query arguments
    $news_args = array(
        'post_type' => 'page', // Adjust post type if needed
        'posts_per_page' => intval($atts['posts_per_page']),
        'category_name' => sanitize_text_field($atts['categories']),
        'post__not_in' => array(intval($exclude_id)), // Exclude the specified post ID
    );

    // Fetch related news
    $news_query = new WP_Query($news_args);

    ob_start(); // Start output buffering
	?>																

		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			<div class="col-lg-12 related-pkge">
				<article>
					<a href="<?= esc_url(get_permalink()); ?>">
						<div class="card shadow-sm mb-3 border-0" data-aos="fade-up">
							<div class="d-flex bd-highlight">
                                <div class="bd-highlight p-1">
                                    <div class="post-thumbnail">
                                        <?php 
                                        // Display the post thumbnail
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('thumbnail', array('class' => 'img-fluid'));
                                        } else {
                                            echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder-image.jpg" alt="Placeholder" class="img-fluid"/>';
                                        }
                                        ?>
                                    </div>
                                </div>
                                <div class="bd-highlight p-1">
                                    <h5><?php the_title(); ?></h5>
                                </div>
                            </div><!-- flez !-->
						</div><!-- card !-->
						</a>
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No packages found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('all_packages', 'allPackages_shortcode');

?>