<!Doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>
		<?php
		$seo_title = get_post_meta(get_the_ID(), '_seo_title', true);
		if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
		?>
		</title>
		<meta name="description" content="
		<?php
		$seo_description = get_post_meta(get_the_ID(), '_seo_description', true);
		if (!empty($seo_description)) { echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
		?>
		">
		<meta name="keywords" content="
		<?php
		$seo_keywords = get_post_meta(get_the_ID(), '_seo_keywords', true);
		if (!empty($seo_keywords)) {echo esc_html($seo_keywords);} else {echo esc_html('Valley Hype Safaris, Uganda tours, wildlife safaris, primate safaris, gorilla trekking, cultural tours, Pearl of Africa');}
		?>
		">
		<!-- Open Graph and Twitter Card Meta Tags -->
		<meta property="og:title" content="
		<?php
			if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
		?>
		"/>
		<meta property="og:description" content="
		<?php
			if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
		?>
		"/>
		<meta property="og:image" content="
		<?php
		$featured_image = get_the_post_thumbnail_url();
		$default_image=  get_template_directory() . '/assets/images/jobconnect-uganda.jpg'; 
		if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
		?>
		" />
		<meta property="og:url" content="<?php the_permalink(); ?>" />
		<meta name="twitter:title" content="
		<?php
		if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
		?>
		"/>
		<meta name="twitter:description" content="
		<?php
		if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());} 
		?>
		"/>
		<meta name="twitter:image" content="
		<?php
		if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
		?>
		"/>
		<link href="//www.google-analytics.com" rel="dns-prefetch">
		<meta name="google-site-verification" content="h1MUlAKujnw7NvidAzWNLTkYhnMdvzHgjy2zvGuOHVQ" />
        <link href="<?php echo get_template_directory_uri(); ?>/favicon.png" rel="shortcut icon">
        <link rel="preconnect" href="https://fonts.googleapis.com">
		<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
		<link href="https://fonts.googleapis.com/css2?family=Jaro:opsz@6..72&family=Poiret+One&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Rubik+Distressed&family=Rubik+Moonrocks&display=swap" rel="stylesheet">
		<!-- Include Magnific Popup -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
        <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
	