<?php
/**
 * Kipya functions and definitions.
 *
 * @link https://urreno.org
 *
 * @package Kipya
 */
set_time_limit(300); // Set to a higher value if needed
if ( ! function_exists( 'kipya_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 */
	function kipya_setup() {
		// Make the theme available for translation.
		load_theme_textdomain( 'kipya', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

        //Upload Logo in website.
        add_theme_support('custom-logo');

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		// Register navigation menus.
		register_nav_menus( array(
			'primary'   => esc_html__( 'Primary Menu', 'kipya' ),
			'top-menu'  => esc_html__( 'Top Menu', 'kipya' ),
            'sidebar'   => esc_html__( 'Sidebar Menu', 'kipya' ),
            'footer'    => esc_html__( 'Footer Menu', 'kipya' ),
		) );

		// Switch default core markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'kipya', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'kipya_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

        /**
		 * Enable support for the following post formats:
		 * aside, gallery, quote, image, and video
		 */
        add_theme_support( 'post-formats', array( 'aside', 'gallery', 'quote', 'image', 'video' ) );
	}
endif;
add_action( 'after_setup_theme', 'kipya_setup' );

// Enqueue styles.
function kipya_styles() {
    wp_register_style('kipya-style', get_template_directory_uri() . '/style.css', array(), '1.0.0', 'all');
    wp_register_style('custom', get_template_directory_uri() . '/assets/css/custom.css', array(), '1.0.0', 'all');
    wp_register_style('animate', get_template_directory_uri() . '/assets/css/animate.css', array(), '4.1.1', 'all');
    wp_register_style('bootstrap.min', get_template_directory_uri() . '/assets/vendor/bootstrap/css/bootstrap.min.css', array(), '5.3.2', 'all');
    wp_register_style('bootstrap-icons', get_template_directory_uri() . '/assets/vendor/bootstrap-icons/font/bootstrap-icons.min.css', array(), '1.11.3', 'all');
    wp_register_style('aos', get_template_directory_uri() . '/assets/vendor/aos/aos.css', array(), '2.3.4', 'all');
    wp_register_style('swiper', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.css', array(), '5.4.5', 'all');
    wp_register_style('toastr.min', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.css', array(), '2.1.3', 'all');
    wp_register_style('datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.css', array(), '1.13.3', 'all');



    wp_enqueue_style( 'kipya-style');
    wp_enqueue_style( 'custom');
    wp_enqueue_style( 'bootstrap.min');
    wp_enqueue_style( 'bootstrap-icons');
    wp_enqueue_style( 'aos');
    wp_enqueue_style( 'swiper');
    wp_enqueue_style( 'toastr.min');
    wp_enqueue_style( 'datatables.min');
}
add_action( 'wp_enqueue_scripts', 'kipya_styles' );

// Enqueue scripts.
function kipya_scripts() {

    wp_enqueue_script( 'bootstrap-script', get_template_directory_uri() . '/assets/vendor/bootstrap/js/bootstrap.bundle.min.js', array(), '4.5.2', 'all');
    wp_enqueue_script( 'aos-script', get_template_directory_uri() . '/assets/vendor/aos/aos.js', array(), '2.3.4', 'all');
    wp_enqueue_script( 'swiper-script', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.js', array(), '5.4.5', 'all');
    wp_enqueue_script( 'toastr-script', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.js', array(), '2.1.3', 'all');
    wp_enqueue_script( 'jquery-script', get_template_directory_uri() . '/assets/vendor/jquery/jquery-3.7.1.min.js', array( ), '3.7.1', 'all');
    wp_enqueue_script( 'kipya-script', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'search-script', get_template_directory_uri() . '/assets/js/search.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.js', array(), '1.13.3', 'all');

    // Pass the ajaxurl to search.js
    wp_localize_script('search-script', 'kipya_ajax_object', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
    ));
}
//add_action( 'wp_enqueue_scripts', 'kipya_scripts' );
add_action('wp_footer','kipya_scripts');


// If Dynamic Sidebar Exists
if (function_exists('register_sidebar'))
{
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => __('Widget Area 1', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name' => __('Widget Area 2', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    
    register_sidebar( array(
        'name'          => esc_html__( 'Top Left', 'kipya' ),
        'id'            => 'topl',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Top Right', 'kipya' ),
        'id'            => 'topr',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Search Area', 'kipya' ),
        'id'            => 'searchi',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Quick Number', 'kipya' ),
        'id'            => 'inno',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Menu Right', 'kipya' ),
        'id'            => 'nav-right',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar(array(
        'name' => __('Services Sidebar', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'servsidebar',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Advert Top', 'kipya' ),
        'id'            => 'advtop',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Newsletter', 'kipya' ),
        'id'            => 'footernewz',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Starter', 'kipya' ),
        'id'            => 'footeri',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer A', 'kipya' ),
        'id'            => 'footera',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer B', 'kipya' ),
        'id'            => 'footerb',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer C', 'kipya' ),
        'id'            => 'footerc',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer D', 'kipya' ),
        'id'            => 'footerd',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Copyright Links', 'kipya' ),
        'id'            => 'footer-links',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
}

//Activate Excerpt in PAGES
function enable_page_excerpts() {
    add_post_type_support('page', 'excerpt');
}
add_action('init', 'enable_page_excerpts');




//Custom BOOTSTRAP Menu 
include get_template_directory() . '/inc/bootstrap-5-wordpress-navbar-walker.php';
include get_template_directory() . '/inc/custom-nav-walker.php';

//Custom Post Type :: SEO 
include get_template_directory() . '/inc/seo-post-types.php';

//Custom Post Type :: SEARCH
include get_template_directory() . '/inc/ajax-search.php';

//Custom Post Type :: SLIDING PHOTOS 
include get_template_directory() . '/inc/slides-post-types.php';

//Add Page Category
include get_template_directory() . '/inc/add_page_category.php';

//Custom Post Type :: DOWNLOADS
include get_template_directory() . '/inc/downloads-post-types.php';

//Custom Post Type :: TEAMS
include get_template_directory() . '/inc/team-post-types.php';

//Custom Post Type :: PARTNERS
include get_template_directory() . '/inc/partners-post-types.php';
//Custom Post Type :: directory
include get_template_directory() . '/inc/directory-post-types.php';

//Custom Post Type :: upcoming-events
include get_template_directory() . '/inc/upcoming-events-post-types.php';

//Custom Post Type :: clubs-show
include get_template_directory() . '/inc/clubs-show.php';



// Shortcode :: AOS
include get_template_directory() . '/inc/aos-animation.php'; 

// Shortcode :: project-show
include get_template_directory() . '/inc/project-show.php'; 
// Shortcode :: contact.php
include get_template_directory() . '/inc/contact.php'; 

//Breadcrumb
include get_template_directory() . '/inc/breadcrumbs.php'; 

//Accordion
include get_template_directory() . '/inc/accordion.php';

//ALL News Shortcode
include get_template_directory() . '/inc/all_news-shortcode.php'; 
include get_template_directory() . '/inc/related-packages.php';
include get_template_directory() . '/inc/all-packages.php';

//Duplicate Pages
include get_template_directory() . '/inc/duplicate-page.php'; 

//ALL News Shortcode
include get_template_directory() . '/inc/news_front.php';
include get_template_directory() . '/inc/safaris-front.php';
include get_template_directory() . '/inc/destination-front.php';

//ALL Associates Shortcode
include get_template_directory() . '/inc/all_partners-page.php'; 

//Custom Post Type :: past-presidents-shortcode
include get_template_directory() . '/inc/past-presidents-shortcode.php';

//Custom Post Type :: events_front-shortcode
include get_template_directory() . '/inc/events_front.php';


//Custom Post Type :: membership-form
include get_template_directory() . '/inc/membership-form.php';

//Custom Post Type :: donation
include get_template_directory() . '/inc/donation.php';

// //FORM PROCESSOR
// include get_template_directory() . '/inc/process-form.php'; 

function allow_video_featured_image($mime_types) {
    // Allow video formats for uploads
    $mime_types['mp4'] = 'video/mp4';
    $mime_types['webm'] = 'video/webm';
    $mime_types['ogg'] = 'video/ogg';
    return $mime_types;
}
add_filter('upload_mimes', 'allow_video_featured_image');


//BACK BUTTON (previous page)
add_action( 'back_button', 'kipya_back_button' );
function kipya_back_button() {
    if ( wp_get_referer() ) {
        $back_text = __( '&laquo; BACK' );
        $button    = "\n<button id='my-back-button' class='btn button my-back-button' onclick='javascript:history.back()'>$back_text</button>";
        echo ( $button );
    }
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 50;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 50;
}

//Allow upload of SVG Images
function enable_svg_support($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'enable_svg_support');

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('Read More', 'kipya') . '</a>';
}

// Remove Admin bar
function remove_admin_bar() {
    return false;
}
add_filter('show_admin_bar', 'remove_admin_bar');

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}



?>