<?php
$title = "Youth Games and Climate Change | Protect the Child Safely";
$tagline = "Empowering Youth Through Sports for Climate Action";
$description = "Protect the Child Safely engages youth in climate action through sports like football, integrating environmental education with fun and meaningful participation.";
$keywords = "youth sports, football, climate action, environmental education, community engagement, green initiatives";
$featured_image = 'https://images.unsplash.com/photo-1569163139394-de4e4f43e4e3?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

<section class="kpy-hero" id="home">
    <img src="assets/images/games.png" alt="Youth Games Climate Action" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Youth Games & Climate Change</h1>
        <p>At PCS, we engage youth through the games they love, like football, to promote climate action and environmental awareness.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Approach</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-futbol"></i></div>
                <h3>Climate Awareness Through Sports</h3>
                <p>Football tournaments bring youth together, creating opportunities to raise awareness on waste management, recycling, and climate-friendly practices.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-leaf"></i></div>
                <h3>Eco-Friendly Campaigns</h3>
                <p>Matches integrate activities like tree planting, clean-up drives, and waste segregation to turn sports gatherings into climate action platforms.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-users"></i></div>
                <h3>Youth Mobilization</h3>
                <p>Football is popular and unifying, making it an effective tool to mobilize young people around climate education and advocacy.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-chalkboard-teacher"></i></div>
                <h3>Leadership & Empowerment</h3>
                <p>Organizing and participating in football events builds youth leadership, teamwork, and ownership in driving environmental initiatives.</p>
            </div>
        </div>
    </div>
</section>

<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/games.png" 
                     alt="Youth Football Climate Action" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>

            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Football tournaments engage youth and community members to raise climate awareness</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Eco-friendly campaigns like tree planting, clean-ups, and recycling integrated into matches</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Popular sports mobilize youth around climate education and advocacy</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Participation builds youth leadership, teamwork, and ownership in environmental initiatives</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Linking football with climate messages encourages sustainable practices and greener communities</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Inspires youth to become champions of environmental sustainability and healthier futures</li>
                </ul>

                <p class="mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
                    Blessed Antagaize engaging the youth on climate change before a football practice at Kavule Village, Kampala. Photo by Ashaba R.A, 2023.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>
