<?php
$title = "Youth and Climate Change | Protect the Child Safely";
$tagline = "Empowering Youth to Lead Climate Action";
$description = "Protect the Child Safely mobilizes youth to address the climate crisis through sustainable waste management, tree planting, clean-up campaigns, and awareness drives.";
$keywords = "youth climate action, sustainable waste management, tree planting, environmental awareness, climate education";
$featured_image = 'https://images.unsplash.com/photo-1569163139394-de4e4f43e4e3?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>



<section class="kpy-hero" id="home">
    <img src="assets/images/child.jpeg" alt="Youth Climate Action" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Youth & Climate Change</h1>
        <p>At Protect the Child Safely, we empower young changemakers to tackle the climate crisis with bold, sustainable actions.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>


<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Mission</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-seedling"></i></div>
                <h3>Mobilizing Youth</h3>
                <p>Inspiring young people to lead sustainable initiatives like waste management and tree planting.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-theater-masks"></i></div>
                <h3>Creative Engagement</h3>
                <p>Making climate education fun through football, debates, and cultural events.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-globe"></i></div>
                <h3>Reducing Harm</h3>
                <p>Cutting pollution to protect health and combat climate change.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-users"></i></div>
                <h3>Community Resilience</h3>
                <p>Empowering youth to strengthen local communities through climate-smart solutions and green initiatives.</p>
            </div>
        </div>
    </div>
</section>


   <!-- Impact Section -->
<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <!-- Image reflecting youth & climate action -->
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/educ.jpeg" 
                     alt="Youth Climate Action" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>
            
            <!-- Details about the initiative -->
            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Mobilized youth to lead tree planting, clean-up campaigns, and sustainable waste management initiatives</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Conducted awareness drives in schools and communities linking climate education with fun, youth-friendly platforms</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Used football tournaments, debates, and cultural events to creatively engage young people in climate action</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Empowered youth to champion climate-smart solutions, renewable energy, and green enterprises</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Reduced pollution, harmful emissions, and climate-related health risks in communities</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Built leadership, skills, and opportunities that strengthen community resilience and break cycles of poverty</li>
                </ul>
            </div>
        </div>
    </div>
</section>



<?php include 'inc/footer.php'?>