<?php
$title = "Sustainable Waste Management & Climate Change | Protect the Child Safely";
$tagline = "Empowering Communities for a Cleaner, Greener Future";
$description = "Protect the Child Safely educates and engages youth in sustainable waste management practices, reducing pollution and promoting climate-friendly behaviors.";
$keywords = "sustainable waste management, recycling, climate action, environmental education, youth engagement, green initiatives";
$featured_image = 'https://images.unsplash.com/photo-1581091012184-3c31c9e2c4c8?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

<section class="kpy-hero" id="home">
    <img src="assets/images/football.png" alt="Sustainable Waste Management" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Sustainable Waste Management</h1>
        <p>At PCS, we empower youth and communities to reduce pollution & embrace recycling </p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Approach</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-recycle"></i></div>
                <h3>Recycling & Upcycling</h3>
                <p>Encouraging youth to segregate waste and repurpose materials to reduce environmental impact.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-leaf"></i></div>
                <h3>Clean-Up Campaigns</h3>
                <p>Organizing community clean-ups in schools, streets, and rivers to prevent pollution and raise awareness.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-chalkboard-teacher"></i></div>
                <h3>Climate Education</h3>
                <p>Teaching youth and communities about the link between waste management and climate change.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-users"></i></div>
                <h3>Community Empowerment</h3>
                <p>Engaging youth to lead initiatives that strengthen local resilience and promote sustainable lifestyles.</p>
            </div>
        </div>
    </div>
</section>

<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/football.png" 
                     alt="Youth Waste Management Climate Action" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>

            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Mobilized youth to lead recycling and upcycling initiatives in schools and communities</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Conducted clean-up campaigns in public spaces, rivers, and streets to reduce pollution</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Educated communities about the connection between waste and climate change</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Reduced harmful emissions from improper waste disposal and burning of plastics</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Built leadership, teamwork, and responsibility among youth for long-term environmental stewardship</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Inspired sustainable behaviors in communities to protect health and mitigate climate risks</li>
                </ul>

                <p class="mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
                    Youth participating in a community clean-up in Kampala, demonstrating practical ways to manage waste sustainably while combating climate change. Photo by PCS Team, 2023.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>
