<?php
$title = "Volunteer | Protect the Child Safely";
$tagline = "Empowering Youth for Climate Action & Child Protection";
$description = "Join Protect the Child Safely (PCS) as a volunteer. Support our youth-led mission to safeguard children, empower communities, and promote environmental conservation in Uganda.";
$keywords = "volunteer with PCS, youth volunteering Uganda, child protection volunteer, environmental conservation volunteer, community empowerment volunteer";
$featured_image = 'assets/images/logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

    <!-- Hero Section -->
    <section class="kpy-hero" id="home">
        <img src="assets/images/educ.jpeg" alt="Volunteer with Protect the Child Safely" class="kpy-hero-bg">
        <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
            <h1>Join Our Volunteer Team</h1>
            <p>Become part of our youth-led movement to protect children, empower communities, and champion environmental conservation in Uganda.</p>
        </div>
        <div class="kpy-hero-wave"></div>
    </section>

   <section class="kpy-section">
    <div class="kpy-container">
        <div class="section-header" data-aos="fade-up">
            <h2>Why Volunteer With Us?</h2>
            <p>As a youth-led organization, we offer unique opportunities for personal growth and community impact</p>
        </div>
        
        <div class="kpy-volunteer-benefits-grid">
            <div class="kpy-benefits-column">
                <div class="kpy-benefit-item" data-aos="fade-right" data-aos-delay="100">
                    <div class="kpy-benefit-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="kpy-benefit-content">
                        <h3>Youth-Led Environment</h3>
                        <p>Work in a dynamic environment led by young people, where innovative ideas are valued and encouraged.</p>
                    </div>
                </div>
                
                <div class="kpy-benefit-item" data-aos="fade-right" data-aos-delay="300">
                    <div class="kpy-benefit-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <div class="kpy-benefit-content">
                        <h3>Skill Development</h3>
                        <p>Gain valuable experience in project management, community engagement, and leadership.</p>
                    </div>
                </div>
            </div>
            
            <div class="kpy-benefits-column">
                <div class="kpy-benefit-item" data-aos="fade-left" data-aos-delay="200">
                    <div class="kpy-benefit-icon">
                        <i class="fas fa-hands-helping"></i>
                    </div>
                    <div class="kpy-benefit-content">
                        <h3>Meaningful Impact</h3>
                        <p>Contribute directly to programs that protect vulnerable children and empower local communities.</p>
                    </div>
                </div>
                
                <div class="kpy-benefit-item" data-aos="fade-left" data-aos-delay="400">
                    <div class="kpy-benefit-icon">
                        <i class="fas fa-seedling"></i>
                    </div>
                    <div class="kpy-benefit-content">
                        <h3>Environmental Action</h3>
                        <p>Participate in conservation projects that address climate change and promote sustainability.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


    <!-- Volunteer Opportunities Section -->
    <section class="kpy-section kpy-bg-light">
        <div class="container-xxl">
            <div class="section-header" data-aos="fade-up">
                <h2>Volunteer Opportunities</h2>
                <p>We have various roles suited for different skills and availability</p>
            </div>
            
            <div class="kpy-opportunities-grid">
                <div class="kpy-opportunity-card" data-aos="flip-up" data-aos-delay="100">
                    <div class="kpy-opportunity-icon">
                        <i class="fas fa-chalkboard-teacher"></i>
                    </div>
                    <h3>Community Educator</h3>
                    <p>Lead workshops on children's rights, health awareness, and environmental conservation in local communities.</p>
                    <ul class="kpy-opportunity-details">
                        <li><strong>Time Commitment:</strong> 5-10 hours/week</li>
                        <li><strong>Location:</strong> Field-based</li>
                        <li><strong>Skills Needed:</strong> Public speaking, teaching</li>
                    </ul>
                </div>
                
                <div class="kpy-opportunity-card" data-aos="flip-up" data-aos-delay="200">
                    <div class="kpy-opportunity-icon">
                        <i class="fas fa-tree"></i>
                    </div>
                    <h3>Environmental Champion</h3>
                    <p>Participate in tree planting initiatives, conservation projects, and climate awareness campaigns.</p>
                    <ul class="kpy-opportunity-details">
                        <li><strong>Time Commitment:</strong> Flexible</li>
                        <li><strong>Location:</strong> Field-based</li>
                        <li><strong>Skills Needed:</strong> Environmental passion</li>
                    </ul>
                </div>
                
                <div class="kpy-opportunity-card" data-aos="flip-up" data-aos-delay="300">
                    <div class="kpy-opportunity-icon">
                        <i class="fas fa-laptop-code"></i>
                    </div>
                    <h3>Digital Content Creator</h3>
                    <p>Help create engaging content for our website, social media, and awareness campaigns.</p>
                    <ul class="kpy-opportunity-details">
                        <li><strong>Time Commitment:</strong> 3-8 hours/week</li>
                        <li><strong>Location:</strong> Remote or office</li>
                        <li><strong>Skills Needed:</strong> Writing, design, social media</li>
                    </ul>
                </div>
                
                <div class="kpy-opportunity-card" data-aos="flip-up" data-aos-delay="400">
                    <div class="kpy-opportunity-icon">
                        <i class="fas fa-hands"></i>
                    </div>
                    <h3>Child Protection Advocate</h3>
                    <p>Support our child safeguarding programs and community awareness initiatives.</p>
                    <ul class="kpy-opportunity-details">
                        <li><strong>Time Commitment:</strong> 5-15 hours/week</li>
                        <li><strong>Location:</strong> Field-based</li>
                        <li><strong>Skills Needed:</strong> Counseling, community work</li>
                    </ul>
                </div>
                
                <div class="kpy-opportunity-card" data-aos="flip-up" data-aos-delay="500">
                    <div class="kpy-opportunity-icon">
                        <i class="fas fa-camera"></i>
                    </div>
                    <h3>Documentation Volunteer</h3>
                    <p>Capture photos and videos of our activities for reporting and awareness purposes.</p>
                    <ul class="kpy-opportunity-details">
                        <li><strong>Time Commitment:</strong> Flexible</li>
                        <li><strong>Location:</strong> Field-based</li>
                        <li><strong>Skills Needed:</strong> Photography, videography</li>
                    </ul>
                </div>
                
                <div class="kpy-opportunity-card" data-aos="flip-up" data-aos-delay="600">
                    <div class="kpy-opportunity-icon">
                        <i class="fas fa-hand-holding-heart"></i>
                    </div>
                    <h3>Event Organizer</h3>
                    <p>Help plan and execute community events, workshops, and fundraising activities.</p>
                    <ul class="kpy-opportunity-details">
                        <li><strong>Time Commitment:</strong> Project-based</li>
                        <li><strong>Location:</strong> Office and field</li>
                        <li><strong>Skills Needed:</strong> Organization, planning</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    

    <!-- Volunteer Process Section -->
    <section class="kpy-section kpy-bg-light">
        <div class="container-xxl">
            <div class="section-header" data-aos="fade-up">
                <h2>How to Become a Volunteer</h2>
                <p>Our simple application process</p>
            </div>
            
            <div class="kpy-process-steps">
                <div class="kpy-process-step" data-aos="zoom-in" data-aos-delay="100">
                    <div class="kpy-step-number">1</div>
                    <div class="kpy-step-content">
                        <h3>Express Interest</h3>
                        <p>Fill out our volunteer application form or contact us directly.</p>
                    </div>
                </div>
                
                <div class="kpy-process-step" data-aos="zoom-in" data-aos-delay="200">
                    <div class="kpy-step-number">2</div>
                    <div class="kpy-step-content">
                        <h3>Interview</h3>
                        <p>We'll schedule a conversation to discuss your interests and availability.</p>
                    </div>
                </div>
                
                <div class="kpy-process-step" data-aos="zoom-in" data-aos-delay="300">
                    <div class="kpy-step-number">3</div>
                    <div class="kpy-step-content">
                        <h3>Orientation</h3>
                        <p>Attend a volunteer orientation to learn about our organization and policies.</p>
                    </div>
                </div>
                
                <div class="kpy-process-step" data-aos="zoom-in" data-aos-delay="400">
                    <div class="kpy-step-number">4</div>
                    <div class="kpy-step-content">
                        <h3>Get Started</h3>
                        <p>Begin your volunteer journey with appropriate training and support.</p>
                    </div>
                </div>
            </div>
            
            
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="kpy-section">
        <div class="container-xxl">
            <div class="section-header" data-aos="fade-up">
                <h2>Volunteer FAQs</h2>
                <p>Common questions about volunteering with PCS</p>
            </div>
            
            <div class="kpy-faq">
                <div class="kpy-faq-item" data-aos="fade-up" data-aos-delay="100">
                    <div class="kpy-faq-question">
                        <h5>What is the minimum age to volunteer?</h5>
                        <span class="kpy-faq-toggle">+</span>
                    </div>
                    <div class="kpy-faq-answer">
                        <p>We welcome volunteers aged 16 and above. For certain roles involving direct work with children, we require volunteers to be 18+ and may conduct background checks.</p>
                    </div>
                </div>
                
                <div class="kpy-faq-item" data-aos="fade-up" data-aos-delay="200">
                    <div class="kpy-faq-question">
                        <h5>Do I need specific qualifications or experience?</h5>
                        <span class="kpy-faq-toggle">+</span>
                    </div>
                    <div class="kpy-faq-answer">
                        <p>While specific skills are beneficial for certain roles, many positions require only enthusiasm and commitment. We provide training for all volunteers.</p>
                    </div>
                </div>
                
                <div class="kpy-faq-item" data-aos="fade-up" data-aos-delay="300">
                    <div class="kpy-faq-question">
                        <h5>Can I volunteer remotely?</h5>
                        <span class="kpy-faq-toggle">+</span>
                    </div>
                    <div class="kpy-faq-answer">
                        <p>Yes, we have remote volunteering opportunities in areas like digital content creation, research, and online mentoring.</p>
                    </div>
                </div>
                
                <div class="kpy-faq-item" data-aos="fade-up" data-aos-delay="400">
                    <div class="kpy-faq-question">
                        <h5>What support do volunteers receive?</h5>
                        <span class="kpy-faq-toggle">+</span>
                    </div>
                    <div class="kpy-faq-answer">
                        <p>All volunteers receive orientation, ongoing supervision, and access to resources. We also provide certificates of service and references for committed volunteers.</p>
                    </div>
                </div>
                
                <div class="kpy-faq-item" data-aos="fade-up" data-aos-delay="500">
                    <div class="kpy-faq-question">
                        <h5>Are there opportunities for international volunteers?</h5>
                        <span class="kpy-faq-toggle">+</span>
                    </div>
                    <div class="kpy-faq-answer">
                        <p>Yes, we welcome international volunteers. However, please note that we do not provide accommodation or cover travel expenses. We can assist with information about local accommodation options.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <script>
        // FAQ toggle functionality
        document.querySelectorAll('.kpy-faq-question').forEach(question => {
            question.addEventListener('click', function() {
                const faqItem = this.parentElement;
                faqItem.classList.toggle('active');
            });
        });
    </script>

<?php include 'inc/footer.php' ?>