<?php
$title = "Team Members | Youth Leadership & Environmental Action";
$tagline = "Empowering Youth for Climate Action - Our Leadership Team";
$description = "Meet the Board Members of Protect the Child Safely, comprising passionate youth leaders and experts dedicated to climate action, environmental protection, and sustainable development in Uganda.";
$keywords = "Protect the Child Safely board, youth climate leaders, Uganda environmental action, climate change advocacy, youth empowerment Uganda, sustainable development, REDD+ governance, community mobilization";
$featured_image = 'https://juhdsjuba.com/assets/images/JUHDS-logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>


<section class="kpy-hero" id="home">
    <img src="assets/images/educ.jpeg" alt="Family and Cooking Energy" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Team Members</h1>
        <p>Promoting safe, efficient, and sustainable cooking practices that protect health, the environment, and children.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="team-section">
    <div class="team-grid">


        <!-- Card 1 -->
        <div class="team-card">
            <div class="card-image">
                <img src="assets/images/blessed.png" alt="Blessed Antangaize">
                <div class="card-gradient"></div>
            </div>
            <div class="card-content">
                <h3 class="card-name">BLESSED ANTANGAIZE</h3>
                <p class="card-title">Executive Director</p>
                <button class="card-button" data-modal="modal1">Full Profile</button>
            </div>
        </div>

    </div>
</section>

<!-- Modal 2 -->
<div id="modal1" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h2 class="modal-title">Profile Details</h2>
      <button class="close-modal">&times;</button>
    </div>
    <div class="modal-body">
      <div class="profile-main">
        <div class="profile-image">
          <img src="assets/images/blessed.png" alt="Blessed Antangaize">
        </div>
        <div class="profile-info">
          <h2 class="profile-name">BLESSED ANTANGAIZE</h2>
          <p class="profile-role">Executive Director</p>
          <p class="profile-bio">
            Blessed leads Protect the Child Safely as Executive Director, providing overall vision and strategic direction. With expertise in youth attractive events, policy advocacy, REDD+ governance, and gender-sensitive safeguards, he has championed youth inclusion in Uganda’s competitive events, forestry and climate policy processes. Blessed spearheads the youth sports events, Forestry &amp; REDD+ Leadership Forum, linking grassroots voices to national structures. Drawing on his lived experience in youth events, and forest-dependent communities, he mobilizes thousands of youth through forums and football tournaments to raise awareness. Blessed’s leadership ensures bridging community priorities with national and international climate action frameworks. Blessed Antangaize – Executive Director can be reach at email: bantagaize@protectthechildsafely.org
          </p>
        </div>
      </div>
    </div>
  </div>
</div>


    

<?php include 'inc/footer.php' ?>