<?php
$title = "Sponsor a Program | Protect the Child Safely";
$tagline = "Empowering Youth for Climate Action & Child Protection";
$description = "Sponsor a specific program at Protect the Child Safely (PCS). Directly support child protection, youth empowerment, or environmental conservation initiatives in Uganda.";
$keywords = "sponsor PCS program, child protection sponsorship, youth empowerment funding, environmental conservation sponsor, corporate sponsorship Uganda";
$featured_image = 'assets/images/logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

    <!-- Hero Section -->
    <section class="kpy-hero" id="home">
        <img src="assets/images/real.jpg" alt="Sponsor a Program with Protect the Child Safely" class="kpy-hero-bg">
        <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
            <h1>Sponsor a Program</h1>
            <p>Directly support our youth-led initiatives that protect children, empower communities, and promote environmental conservation in Uganda.</p>
        </div>
        <div class="kpy-hero-wave"></div>
    </section>

    <!-- How to Sponsor Section -->
    <section class="kpy-section">
        <div class="container kpy-grid">
            <!-- Left Column: Content -->
            <div class="kpy-col" data-aos="fade-right">
                <h2>How to Sponsor a Program</h2>
                <p>
                    Sponsoring a program with <strong>Protect the Child Safely (PCS)</strong> is straightforward. 
                    We welcome individuals, organizations, and companies who want to make a meaningful difference. 
                </p>
                <p>
                    To sponsor, please <a href="contact.php">contact us directly</a> so we can guide you through the process 
                    and connect you with a program that aligns best with your values and goals.
                </p>
                <a href="index.php#programs" class="kpy-btn kpy-btn-secondary">View Programs</a>
            </div>

            <!-- Right Column: Image -->
            <div class="kpy-col" data-aos="fade-left">
                <img src="assets/images/educ.jpeg" alt="How to Sponsor" class="kpy-img">
            </div>
        </div>
    </section>

    <!-- Sponsorship Benefits Section -->
    <section class="kpy-section kpy-bg-light">
        <div class="container-xxl">
            <div class="section-header" data-aos="fade-up">
                <h2>Benefits of Program Sponsorship</h2>
                <p>When you sponsor a program, you receive recognition and impact reporting</p>
            </div>
            
            <div class="kpy-benefits-grid">
                <div class="kpy-benefit-card" data-aos="zoom-in" data-aos-delay="100">
                    <div class="kpy-benefit-number">01</div>
                    <h3>Direct Impact Visibility</h3>
                    <p>Receive detailed reports showing exactly how your sponsorship is making a difference in the community.</p>
                </div>
                
                <div class="kpy-benefit-card" data-aos="zoom-in" data-aos-delay="200">
                    <div class="kpy-benefit-number">02</div>
                    <h3>Recognition</h3>
                    <p>Get featured on our website, annual report, and program materials as a dedicated sponsor.</p>
                </div>
                
                <div class="kpy-benefit-card" data-aos="zoom-in" data-aos-delay="300">
                    <div class="kpy-benefit-number">03</div>
                    <h3>Site Visits</h3>
                    <p>Opportunity to visit the program sites and see your sponsored program in action.</p>
                </div>
                
                
                <div class="kpy-benefit-card" data-aos="zoom-in" data-aos-delay="600">
                    <div class="kpy-benefit-number">04</div>
                    <h3>Networking Opportunities</h3>
                    <p>Connect with other sponsors and community leaders through our events.</p>
                </div>
            </div>
            
            
        </div>
    </section>



<?php include 'inc/footer.php' ?>