<?php
$title = "Areas of Operation | Protect the Child Safely";
$tagline = "Our Diverse Initiatives for Youth Empowerment and Climate Action";
$description = "Explore the various areas of operation for Protect the Child Safely (PCS) including youth empowerment, climate action, sustainable waste management, and community development initiatives in Uganda.";
$keywords = "PCS areas of operation, youth empowerment programs, climate action initiatives, sustainable waste management Uganda, community development projects";
$featured_image = 'assets/images/logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

    <!-- Hero Section -->
    <section class="kpy-hero" id="home">
        <img src="assets/images/real.jpg" alt="Areas of Operation - Protect the Child Safely" class="kpy-hero-bg">
        <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
            <h1>Areas of Operation</h1>
            <p>Discover the diverse initiatives through which Protect the Child Safely empowers youth, promotes climate action, and builds resilient communities across Uganda.</p>
        </div>
        <div class="kpy-hero-wave"></div>
    </section>

    <!-- Areas of Operation Cards Section -->
    <section class="kpy-areas-section kpy-section">
        <div class="container">
            
            <div class="kpy-areas-cards">
                <!-- Row 1 -->
                <div class="kpy-areas-row">
                    <div class="kpy-areas-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/football.png" alt="Youth Leadership Structure">
                            <div class="kpy-card-title">
                                <h3>Youth Leadership Structure</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>PROTECT THE CHILD SAFELY is a youth-led, youth-focused NGO with a leadership structure that places young people at the center. At the helm is a Youth Executive Leader (aged 22) who provides strategic direction.</p>
                            <p>More than 50% of program managers, officers, and coordinators are between 18 and 35 years old. Six out of nine Board of Directors are youth (21-34 age range), giving young people a decisive voice in shaping priorities and long-term vision.</p>
                            <p>This governance model ensures inclusivity, sustainability, and relevance in our mission to protect and empower children across diverse communities.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-areas-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/real.jpg" alt="Youth and Climate Change">
                            <div class="kpy-card-title">
                                <h3>Youth and Climate Change</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>We mobilize youth to lead activities promoting sustainable waste management, tree planting, clean-up campaigns, and awareness drives in schools and communities.</p>
                            <p>Through football tournaments, debates, and cultural events, we creatively link climate education with youth-friendly platforms. Our mission is to reduce pollution and harmful emissions that drive climate change and increase health risks.</p>
                            <p>By empowering youth to champion better waste management practices and advocate for climate-smart solutions, we protect the environment while strengthening community health and resilience.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Row 2 -->
                <div class="kpy-areas-row">
                    <div class="kpy-areas-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/games.png" alt="Youth Games and Climate Change">
                            <div class="kpy-card-title">
                                <h3>Youth Games and Climate Change</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>We promote climate action by engaging youth through sports like football, linking them with environmental education to create fun and meaningful learning spaces.</p>
                            <p>During tournaments, we provide climate-themed flyers, signposts, and banners with messages on climate change solutions. Football tournaments bring together large numbers of youth and community members, creating opportunities to raise awareness.</p>
                            <p>Matches integrate activities like tree planting, clean-up drives, and waste segregation, turning sports gatherings into climate action platforms that build youth leadership and teamwork.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-areas-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/waste-manage.png" alt="Sustainable Waste Management">
                            <div class="kpy-card-title">
                                <h3>Sustainable Waste Management</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Improper waste disposal contaminates soil, pollutes water sources, and deteriorates air quality, creating direct risks for both environment and human health.</p>
                            <p>Toxic liquids from decomposing waste seep into groundwater, threatening safe drinking water. Organic waste breakdown produces methane, a dangerous greenhouse gas.</p>
                            <p>We promote safe disposal practices, recycling, and youth-led climate actions to reduce pollution, protect natural resources, and safeguard the wellbeing of children, youth, and families.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Row 3 -->
                <div class="kpy-areas-row">
                    <div class="kpy-areas-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/educ.jpeg" alt="Education, Research and Capacity Building">
                            <div class="kpy-card-title">
                                <h3>Education, Research and Capacity Building</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>We equip young people with skills, confidence, and opportunities to address climate change, waste management, and public health challenges.</p>
                            <p>Youth training programs combine technical knowledge with practical experience. We conduct workshops on recycling, safe waste disposal, and climate adaptation during tournaments and community events.</p>
                            <p>Our efforts include research and innovation, supporting youth to explore solutions like waste-to-energy initiatives, tree planting models, and digital tools for climate monitoring.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-areas-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/innovation.jpg" alt="Innovation and Climate Change">
                            <div class="kpy-card-title">
                                <h3>Innovation and Climate Change</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>We empower young people to design creative solutions addressing community challenges. Blessed Antangaize is developing a wind and gravity-powered water supply system for drought-affected villages.</p>
                            <p>This system operates without electricity, making it valuable in rural areas with limited infrastructure. Once implemented, it will supply safe water to more than 300 families in regions without piped water.</p>
                            <p>These initiatives showcase youth creativity and leadership as agents of change, transforming climate challenges into sustainable development opportunities.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Row 4 -->
                <div class="kpy-areas-row">
                    <div class="kpy-areas-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/cooking.jpg" alt="Family and Cooking Energy">
                            <div class="kpy-card-title">
                                <h3>Family and Cooking Energy</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Traditional three-stone cooking methods are inefficient, consume large amounts of firewood, contribute to deforestation, and produce heavy smoke causing respiratory illnesses.</p>
                            <p>The burden of collecting firewood often falls on children and young women, keeping them from school and exposing them to safety risks.</p>
                            <p>We promote energy-saving stoves that use significantly less fuel and encourage transition to cleaner alternatives like cooking gas, reducing household pollution and improving quality of life.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-areas-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/forest.jpg" alt="Youth in Forest and Climate Action">
                            <div class="kpy-card-title">
                                <h3>Youth in Forest and Climate Action</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>We address deforestation challenges in Uganda by empowering young women and men excluded from forestry governance and carbon markets.</p>
                            <p>We build youth leadership in REDD+ decision-making, support enterprises in forest value chains, and promote gender-responsive benefit-sharing.</p>
                            <p>Our results include creating economic opportunities for 100+ youth-led businesses, generating 50,000 tCO₂e in carbon credits, and contributing to policy reforms embedding gender equity in REDD+ governance.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



<?php include 'inc/footer.php' ?>
