<?php
$title = "Innovation & Climate Change | Protect the Child Safely";
$tagline = "Youth-Driven Innovation for Climate Resilience";
$description = "Protect the Child Safely empowers youth innovators to design creative solutions that address climate challenges and improve access to essential resources like clean water.";
$keywords = "innovation, climate change, youth innovation, climate resilience, sustainable development, clean water projects, renewable energy, youth leadership";
$featured_image = 'https://images.unsplash.com/photo-1594938298603-c8147d44a092?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

<section class="kpy-hero" id="home">
    <img src="assets/images/innovation.jpg" alt="Innovation and Climate Change" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Innovation and Climate Change</h1>
        <p>We empower young innovators to design and lead creative solutions that turn climate challenges into opportunities for resilience and sustainable development.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Approach</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-lightbulb"></i></div>
                <h3>Youth Innovation</h3>
                <p>Encouraging youth to design practical, creative solutions that address climate and community challenges directly.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-water"></i></div>
                <h3>Clean Water Solutions</h3>
                <p>Promoting innovations like wind and gravity-powered water systems to bring safe water to underserved communities.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-solar-panel"></i></div>
                <h3>Sustainable Energy</h3>
                <p>Supporting renewable and low-cost systems that operate without electricity, especially for rural and off-grid areas.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-users-cog"></i></div>
                <h3>Community Impact</h3>
                <p>Fostering projects that improve quality of life while showcasing youth leadership and innovation in climate resilience.</p>
            </div>
        </div>
    </div>
</section>

<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/innovation.jpg" 
                     alt="Youth-Led Climate Innovation" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>

            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Supported youth-led projects like Blessed Antangaize’s wind and gravity-powered water system</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Brought safe, domestic water access to more than 300 families in underserved regions</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Promoted renewable, electricity-free solutions for rural communities</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Showcased youth as agents of change in climate resilience and sustainable development</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Complemented national water access efforts by innovating where infrastructure is limited</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Inspired other young innovators to address pressing climate and community needs</li>
                </ul>

                <p class="mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
                    Blessed Antangaize demonstrates how innovation can transform climate challenges into opportunities — with a wind and gravity-powered water supply system serving rural communities. Photo by PCS Team, 2023.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>
