<?php
$title = "Protect A Child Safely - Uganda's Youth-Led Environmental & Child Protection Organization";
$tagline = "Empowering Youth, Protecting Children, Building Climate-Resilient Communities";
$description = "Protect A Child Safely is a youth-led organization in Uganda dedicated to child protection, youth empowerment, and environmental conservation. We integrate climate action with child welfare through innovative programs and community engagement.";
$keywords = "child protection Uganda, youth empowerment, climate action Uganda, environmental conservation, sustainable development, youth-led organization, child rights, climate resilience";
$featured_image = 'https://images.unsplash.com/photo-1577896851231-70ef18881754?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>
<?php include 'inc/slides/carousel.php'?>

<!-- About Section -->
<section class="section-padding">
    <div class="container-xxl">
        <div class="about-grid">
            <div class="about-image" data-aos="fade-right" data-aos-delay="300">
                <img src="assets/images/child.jpeg" alt="Protect A Child Safely Team">
                <div class="about-badge">
                    <p>Founded</p>
                    <span>2019</span>
                </div>
            </div>

            <div class="about-content" data-aos="fade-left" data-aos-delay="200">
                <h2>About Protect A Child Safely</h2>
                <p>
                    Protect A Child Safely is a youth-led non-governmental organization in Uganda dedicated to child protection, youth empowerment, and environmental conservation. Since our founding in 2019, we have worked at the intersection of climate action and child welfare, creating innovative programs that address both environmental challenges and children's rights.
                </p>

                <div class="about-highlights">
                    <div class="highlight">
                        <div class="highlight-icon"><i class="fas fa-shield-alt"></i></div>
                        <div class="highlight-content">
                            <h4>Child Protection</h4>
                            <p>We safeguard children from abuse, neglect, and exploitation through advocacy and direct interventions.</p>
                        </div>
                    </div>
                    <div class="highlight">
                        <div class="highlight-icon"><i class="fas fa-seedling"></i></div>
                        <div class="highlight-content">
                            <h4>Environmental Conservation</h4>
                            <p>Promoting sustainable practices and climate resilience through youth-led initiatives.</p>
                        </div>
                    </div>
                </div>

                <div class="about-quote">
                    <p>"Every child deserves a safe, nurturing environment where they can dream, learn, and succeed. By integrating climate action with child protection, we're building resilient communities for future generations."</p>
                    <span>- Protect A Child Safely Team</span>
                </div>

                <a href="#" class="unique" data-aos="fade-right" data-aos-delay="400">Our Programs →</a>
            </div>
        </div>
    </div>
</section>

<!-- Leadership Stats Section -->
<section class="impact section-padding">
  <div class="container-xxl">
    <div class="section-title">
      <h2>Leadership by the Numbers</h2>
      <p style="color:var(--kpy-white);">Our youth-led governance structure keeps young voices at the center of decision-making</p>
    </div>

    <div class="impact-grid">
      <div class="impact-item" data-aos="fade-up" data-aos-delay="100">
        <div class="impact-icon"><i class="fas fa-calendar-alt"></i></div>
        <h3 class="counter" data-target="2019">0</h3>
        <p>Year Founded</p>
      </div>

      <div class="impact-item" data-aos="fade-up" data-aos-delay="200">
        <div class="impact-icon"><i class="fas fa-user-tie"></i></div>
        <h3 class="counter" data-target="22">0</h3>
        <p>Youth Executive Leader’s Age</p>
      </div>

      <div class="impact-item" data-aos="fade-up" data-aos-delay="300">
        <div class="impact-icon"><i class="fas fa-users"></i></div>
        <h3 class="counter" data-target="6">0</h3>
        <p>Youth on the Board (out of 9)</p>
      </div>

      <div class="impact-item" data-aos="fade-up" data-aos-delay="400">
        <div class="impact-icon"><i class="fas fa-user-friends"></i></div>
        <h3 class="counter" data-target="50">0</h3>
        <p>%+ of Staff are Youth (18–35)</p>
      </div>
    </div>
  </div>
</section>

  <section class="initiatives section-padding" data-aos="fade-up" data-aos-duration="1000">
  <div class="container-xxl">
    <div class="section-title" data-aos="fade-down" data-aos-duration="1000">
      <h2>Our Areas of Operation</h2>
      <p>Discover the diverse initiatives through which we empower youth and build resilient communities</p>
    </div>

    <!-- Slider Container -->
    <div class="initiatives-slider-container">
      <div class="initiatives-slider">
        <!-- Slide 1 - Youth Leadership Structure -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000">
          <div class="initiative-card">
            <div class="initiative-label">Youth Leadership</div>
            <div class="initiative-content">
              <h3>Youth Leadership Structure</h3>
              <p>PROTECT THE CHILD SAFELY is a youth-led, youth-focused NGO with a leadership structure that places young people at the center. More than 50% of our staff and board members are youth, ensuring inclusivity and relevance in our mission.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/real.jpg" alt="Youth Leadership Structure">
              <a href="#" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 2 - Youth and Climate Change -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100">
          <div class="initiative-card">
            <div class="initiative-label">Climate Action</div>
            <div class="initiative-content">
              <h3>Youth and Climate Change</h3>
              <p>We mobilize youth to lead activities promoting sustainable waste management, tree planting, and clean-up campaigns. Through football tournaments and cultural events, we creatively link climate education with youth-friendly platforms.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/football.png" alt="Youth and Climate Change">
              <a href="youth-climate.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 3 - Youth Games and Climate Change -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
          <div class="initiative-card">
            <div class="initiative-label">Sports & Environment</div>
            <div class="initiative-content">
              <h3>Youth Games and Climate Change</h3>
              <p>We promote climate action by engaging youth through sports like football, linking them with environmental education. Tournaments integrate activities like tree planting and clean-up drives, turning sports into climate action platforms.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/games.png" alt="Youth Games and Climate Change">
              <a href="youth-games.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 4 - Sustainable Waste Management -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300">
          <div class="initiative-card">
            <div class="initiative-label">Waste Management</div>
            <div class="initiative-content">
              <h3>Sustainable Waste Management</h3>
              <p>We address the profound effects of poor waste disposal that contaminates soil, pollutes water, and deteriorates air quality. Our programs promote safe disposal practices and recycling to protect both environment and human health.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/waste-manage.png" alt="Sustainable Waste Management">
              <a href="waste-management.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 5 - Education, Research and Capacity Building -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400">
          <div class="initiative-card">
            <div class="initiative-label">Education & Research</div>
            <div class="initiative-content">
              <h3>Education, Research and Capacity Building</h3>
              <p>We equip young people with skills to address climate change, waste management, and public health. Our training programs combine technical knowledge with practical experience, fostering innovation and sustainable solutions.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/educ.jpeg" alt="Education, Research and Capacity Building">
              <a href="capacity-building.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 6 - Innovation and Climate Change -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500">
          <div class="initiative-card">
            <div class="initiative-label">Innovation</div>
            <div class="initiative-content">
              <h3>Innovation and Climate Change</h3>
              <p>We empower youth to design creative solutions like the wind and gravity-powered water system for drought-affected villages. These initiatives transform climate challenges into sustainable development opportunities.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/innovation.jpg" alt="Innovation and Climate Change">
              <a href="innovation.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 7 - Family and Cooking Energy -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600">
          <div class="initiative-card">
            <div class="initiative-label">Clean Energy</div>
            <div class="initiative-content">
              <h3>Family and Cooking Energy</h3>
              <p>We address health and environmental impacts of traditional cooking methods. Our programs promote energy-saving stoves and cleaner alternatives to reduce deforestation, improve air quality, and protect families.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/cooking.jpg" alt="Family and Cooking Energy">
              <a href="cooking-energy.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>

        <!-- Slide 8 - Youth in Forest and Climate Action -->
        <div class="initiative-slide" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
          <div class="initiative-card">
            <div class="initiative-label">Forest Conservation</div>
            <div class="initiative-content">
              <h3>Youth in Forest and Climate Action</h3>
              <p>We address deforestation by empowering youth excluded from forestry governance. We build leadership in REDD+ decision-making and support enterprises in forest value chains with gender-responsive benefit-sharing.</p>
            </div>
            <div class="initiative-image">
              <img src="assets/images/forest.jpg" alt="Youth in Forest and Climate Action">
              <a href="human-health.php" class="read-more">Learn More →</a>
            </div>
          </div>
        </div>
      </div>

      <!-- Slider Navigation -->
      <div class="slider-nav">
        <button class="slider-prev" aria-label="Previous slide">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
          </svg>
        </button>
        <div class="slider-dots"></div>
        <button class="slider-next" aria-label="Next slide">
          <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
          </svg>
        </button>
      </div>
    </div>
  </div>
</section>

<!-- Key Impacts Section -->
<section class="pcs-impacts section-padding" data-aos="fade-up" data-aos-duration="1000">
  <div class="container-xxl">
    <div class="section-title text-center" data-aos="fade-down" data-aos-duration="1000">
      <h2>Our Key Impacts</h2>
      <p>Protect the Child Safely (PCS) contributions to youth, climate change, and community resilience</p>
    </div>

    <div class="row">
      <!-- First Column -->
      <div class="col-lg-6 mb-4" data-aos="fade-right" data-aos-duration="1000">
        <div class="accordion pcs-accordion" id="impactAccordion1">
                    <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
              <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                Youth Empowerment in Forestry and Climate Action
              </button>
            </h2>
            <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#impactAccordion1">
              <div class="accordion-body">
                Trained and mentored young women and men to participate actively in REDD+ and climate governance processes, ensuring youth voices influence national decisions.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                Enterprise Development for Youth
              </button>
            </h2>
            <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#impactAccordion1">
              <div class="accordion-body">
                Supported youth-led businesses in forest and non-forest value chains (e.g., honey, shea, timber), creating jobs and sustainable livelihoods.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingThree">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                Promotion of Rainwater Harvesting (RWH)
              </button>
            </h2>
            <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#impactAccordion1">
              <div class="accordion-body">
                Introduced low-cost technologies for households and farming, reducing climate vulnerability to droughts and water scarcity.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingFour">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour">
                Advancing Gender-Responsive Climate Solutions
              </button>
            </h2>
            <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#impactAccordion1">
              <div class="accordion-body">
                Integrated women’s roles in water and forest management, improving equity in access to resources and decision-making.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingFive">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive">
                Improved Health Outcomes
              </button>
            </h2>
            <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#impactAccordion1">
              <div class="accordion-body">
                Linked waste, water, and energy management with reduced exposure to smoke, contaminated water, and climate-related diseases, protecting children’s health.
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Second Column -->
      <div class="col-lg-6 mb-4" data-aos="fade-left" data-aos-duration="1000">
        <div class="accordion pcs-accordion" id="impactAccordion2">
                    <div class="accordion-item">
            <h2 class="accordion-header" id="headingSix">
              <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix">
                Capacity Building in Refugee and Host Communities
              </button>
            </h2>
            <div id="collapseSix" class="accordion-collapse collapse show" data-bs-parent="#impactAccordion2">
              <div class="accordion-body">
                Strengthened resilience by enhancing access to water, sanitation, and hygiene services, reducing risks of radicalization and improving social cohesion.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingSeven">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven">
                Climate Education and Research
              </button>
            </h2>
            <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent="#impactAccordion2">
              <div class="accordion-body">
                Produced evidence-based research on climate change, water safety, and child health, informing policies and building academic knowledge.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingEight">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight">
                Carbon Credit Generation
              </button>
            </h2>
            <div id="collapseEight" class="accordion-collapse collapse" data-bs-parent="#impactAccordion2">
              <div class="accordion-body">
                Supported youth participation in carbon markets, generating measurable carbon credits while creating economic benefits for communities.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingNine">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseNine">
                Community-Led Governance Structures
              </button>
            </h2>
            <div id="collapseNine" class="accordion-collapse collapse" data-bs-parent="#impactAccordion2">
              <div class="accordion-body">
                Established leadership forums (e.g., Youth in Forestry &amp; REDD+ Leadership Forum) that embed local priorities into national and global frameworks.
              </div>
            </div>
          </div>

          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTen">
              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTen">
                Resilience to Climate Shocks
              </button>
            </h2>
            <div id="collapseTen" class="accordion-collapse collapse" data-bs-parent="#impactAccordion2">
              <div class="accordion-body">
                Strengthened adaptation to droughts, floods, and land degradation by promoting sustainable land, water, and energy practices.
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>



<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="cta-content" data-aos="fade-up">
            <h2>Join Our Movement</h2>
            <p>Become part of a youth-led initiative that's creating sustainable change for children and communities. Together, we can build climate-resilient futures.</p>
            <div class="cta-buttons">
                <a href="#" class="unique-btn">Volunteer With Us </a>
                <a href="#" class="unique">Make a Donation </a>
            </div>
        </div>
    </div>
</section>


<?php include 'inc/footer.php'?>