<div class="slider">
        <div class="slides-track">
            <div class="slide slide-1 active">
                <div class="slide-image" style="background-image: url('assets/images/educ.jpeg');">
                    <div class="slide-content " data-aos="zoom-in" data-aos-delay="200">
                        <h2 data-aos="fade-right" data-aos-delay="200">Empowering Communities</h2>
                        <p data-aos="fade-up" data-aos-delay="400">We work hand in hand with local communities to create lasting change by providing access to education, healthcare, and livelihood opportunities.</p>
                        <button class="unique-btn" data-aos="zoom-in" data-aos-delay="600">Get Involved →</button>
                    </div>
                </div>
            </div>
            
            <div class="slide slide-2">
                <div class="slide-image" style="background-image: url('assets/images/child.jpeg');">
                    <div class="slide-content"  data-aos="zoom-in" data-aos-delay="200">
                        <h2 data-aos="fade-right" data-aos-delay="200">Hope for Children</h2>
                        <p data-aos="fade-up" data-aos-delay="400">Every child deserves the chance to dream, learn, and grow. Our programs focus on giving vulnerable children access to quality education and safe environments. </p>
                        <button class="unique-btn" data-aos="zoom-in" data-aos-delay="600">Donate Now →</button>
                    </div>
                </div>
            </div>
            
            <div class="slide slide-3">
                <div class="slide-image" style="background-image: url('assets/images/real.jpg');">
                    <div class="slide-content"  data-aos="zoom-in" data-aos-delay="200">
                        <h2 data-aos="fade-right" data-aos-delay="200">Building a Better Tomorrow</h2>
                        <p data-aos="fade-up" data-aos-delay="400">Together with our partners and supporters, we are working to tackle the root causes of poverty, inequality, and climate challenges. </p>
                        <button class="unique-btn" data-aos="zoom-in" data-aos-delay="600">Support Us →</button>
                    </div>
                </div>
            </div>

            </div>
        </div>

        <!-- Navigation Arrows -->
        <div class="slider-nav">
            <div class="nav-arrow prev">&#10094;</div>
            <div class="nav-arrow next">&#10095;</div>
        </div>

        <!-- Dots -->
        <div class="slider-dots"></div>
    </div>

    <script>
        const track = document.querySelector(".slides-track");
        const slides = document.querySelectorAll(".slide");
        const prevBtn = document.querySelector(".prev");
        const nextBtn = document.querySelector(".next");
        const dotsContainer = document.querySelector(".slider-dots");

        let currentIndex = 0;
        let autoSlideInterval;

        // Create dots dynamically
        slides.forEach((_, i) => {
            const dot = document.createElement("div");
            dot.classList.add("dot");
            if (i === 0) dot.classList.add("active");
            dot.addEventListener("click", () => goToSlide(i));
            dotsContainer.appendChild(dot);
        });
        const dots = document.querySelectorAll(".dot");

        function updateSlider() {
            track.style.transform = `translateX(-${currentIndex * 100}%)`;
            slides.forEach((slide, i) => slide.classList.toggle("active", i === currentIndex));
            dots.forEach((dot, i) => dot.classList.toggle("active", i === currentIndex));
        }

        function goToSlide(index) {
            currentIndex = index;
            updateSlider();
            resetAutoSlide();
        }

        function nextSlide() {
            currentIndex = (currentIndex + 1) % slides.length;
            updateSlider();
            resetAutoSlide();
        }

        function prevSlide() {
            currentIndex = (currentIndex - 1 + slides.length) % slides.length;
            updateSlider();
            resetAutoSlide();
        }

        function startAutoSlide() {
            autoSlideInterval = setInterval(nextSlide, 5000);
        }

        function resetAutoSlide() {
            clearInterval(autoSlideInterval);
            startAutoSlide();
        }

        // Event listeners
        nextBtn.addEventListener("click", nextSlide);
        prevBtn.addEventListener("click", prevSlide);

        // Initialize
        updateSlider();
        startAutoSlide();

        // Pause on hover
        const slider = document.querySelector(".slider");
        slider.addEventListener("mouseenter", () => clearInterval(autoSlideInterval));
        slider.addEventListener("mouseleave", startAutoSlide);
    </script>
