<?php
$title = "Environmental & Human Health Effects | Protect the Child Safely";
$tagline = "Protecting Communities by Promoting Safe Waste Management Practices";
$description = "Protect the Child Safely raises awareness on the health and environmental risks of poor waste disposal while promoting sustainable solutions led by youth.";
$keywords = "environmental health, human health, waste disposal, pollution, climate change, youth health, clean environment";
$featured_image = 'https://images.unsplash.com/photo-1508780709619-79562169bc64?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

<section class="kpy-hero" id="home">
    <img src="assets/images/waste-manage.png" alt="Environmental and Human Health Effects" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Environmental and Human Health Effects</h1>
        <p>Poor waste disposal contaminates soil, water, and air, creating direct risks for both the environment and human health.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Approach</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-tint"></i></div>
                <h3>Protecting Water & Soil</h3>
                <p>Preventing toxic waste from seeping into groundwater and soil, protecting safe drinking water and fertile land.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-smog"></i></div>
                <h3>Air Quality & Emissions</h3>
                <p>Reducing methane and other harmful gases released from decomposing waste and open burning.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-hospital-user"></i></div>
                <h3>Health Protection</h3>
                <p>Raising awareness about illnesses linked to unmanaged waste, from respiratory problems to gastrointestinal diseases.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-user-graduate"></i></div>
                <h3>Youth Training</h3>
                <p>Training youth on safe waste disposal and leadership in environmental health initiatives.</p>
            </div>
        </div>
    </div>
</section>

<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/waste-manage.png" 
                     alt="Human Health Effects of Waste Management" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>

            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Prevented contamination of soil and groundwater from toxic liquids in waste</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Reduced exposure of communities to pollutants and hazardous materials</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Raised awareness about the link between poor waste management and chronic illnesses</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Promoted safe disposal practices to reduce methane and greenhouse gas emissions</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Trained youth leaders to champion environmental health in their communities</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Reduced healthcare costs and long-term vulnerabilities for families living near dumpsites</li>
                </ul>

                <p class="mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
                    Youth undergoing training on safe waste disposal practices, learning how sustainable waste management safeguards both the environment and human health. Photo by PCS Team, 2023.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>
