<?php
$title = "Donate | Protect the Child Safely";
$tagline = "Empowering Youth for Climate Action & Child Protection";
$description = "Support Protect the Child Safely (PCS) in our mission to safeguard children, empower communities, and promote environmental conservation in Uganda. Your donation makes a difference.";
$keywords = "donate to PCS, support child protection Uganda, youth empowerment donation, climate action funding, Protect the Child Safely donation";
$featured_image = 'assets/images/logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

    <!-- Hero Section -->
    <section class="kpy-hero" id="home">
        <img src="assets/images/educ.jpeg" alt="Support Protect the Child Safely" class="kpy-hero-bg">
        <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
            <h1>Support Our Mission</h1>
            <p>Your donation empowers youth leaders to protect children, build resilient communities, and champion environmental conservation in Uganda.</p>
        </div>
        <div class="kpy-hero-wave"></div>
    </section>
    
   
    <!-- Impact Section -->
    <section class="section">
        <div class="container">
            <div class="section-header">
                <h2>Your Donation Makes a Difference</h2>
                <p>As a youth-led organization, we maximize every contribution to create sustainable impact in our communities.</p>
            </div>
            
            <div class="impact-grid">
                <div class="impact-item">
                    <div class="impact-icon">
                        <i class="fas fa-child"></i>
                    </div>
                    <h3>Child Protection</h3>
                    <p>Fund programs that safeguard vulnerable children from abuse, exploitation, and neglect through education and community support.</p>
                </div>
                
                <div class="impact-item">
                    <div class="impact-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3>Youth Empowerment</h3>
                    <p>Support leadership training, skill development, and mentorship programs for young change-makers in local communities.</p>
                </div>
                
                <div class="impact-item">
                    <div class="impact-icon">
                        <i class="fas fa-seedling"></i>
                    </div>
                    <h3>Environmental Action</h3>
                    <p>Fund tree planting initiatives, conservation education, and climate resilience projects led by youth environmental champions.</p>
                </div>
                
                <div class="impact-item">
                    <div class="impact-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <h3>Community Education</h3>
                    <p>Support workshops on children's rights, health awareness, and sustainable practices that benefit entire communities.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Payment Details Section -->
    <section class="section payment-section">
        <div class="container">
            <div class="section-header">
                <h2>Donation Methods</h2>
                <p>Choose the most convenient way to support our youth-led initiatives</p>
            </div>
            
            <div class="payment-methods">
                <div class="payment-method">
                    <h3><i class="fas fa-university"></i> Bank Transfer</h3>
                    <p>Make a direct bank transfer to our organization's account. Please include your name as a reference.</p>
                    
                    <div class="payment-details">
                        <p><strong>Account Name:</strong> Protect the Child Safely</p>
                        <p><strong>Bank:</strong> Centenary Bank</p>
                        <p><strong>Account Number:</strong> 3101345897</p>
                        <p><strong>Swift Code:</strong> CBTIUGKA</p>
                        <p><strong>Branch:</strong> Kampala Road</p>
                        <p><strong>Currency:</strong> USD / UGX</p>
                    </div>
                </div>
                
                <div class="payment-method">
                    <h3><i class="fas fa-mobile-alt"></i> Mobile Money</h3>
                    <p>Send your donation via Mobile Money for instant and secure transfer to our organization.</p>
                    
                    <div class="payment-details">
                        <p><strong>Service Provider:</strong> MTN Mobile Money</p>
                        <p><strong>Account Name:</strong> Protect the Child Safely</p>
                        <p><strong>Phone Number:</strong> +256 772 123 456</p>
                        <p><strong>Reference:</strong> Donation PCS</p>
                    </div>
                    
                    <div class="payment-details" style="margin-top: 30px;">
                        <p><strong>Service Provider:</strong> Airtel Money</p>
                        <p><strong>Account Name:</strong> Protect the Child Safely</p>
                        <p><strong>Phone Number:</strong> +256 752 987 654</p>
                        <p><strong>Reference:</strong> Donation PCS</p>
                    </div>
                </div>
            </div>
            
            <div style="text-align: center; margin-top: 40px; background: white; padding: 20px; border-radius: 8px;">
                <p><strong>After making your donation, please email us at donations@protectthechildsafely.org with your details so we can acknowledge your support and provide a receipt.</strong></p>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="section">
        <div class="container">
            <div class="section-header">
                <h2>Frequently Asked Questions</h2>
                <p>Find answers to common questions about donating to Protect the Child Safely</p>
            </div>
            
            <div class="faq">
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>How will my donation be used?</h3>
                        <span class="faq-toggle">+</span>
                    </div>
                    <div class="faq-answer">
                        <p>Your donation directly supports our three core mission areas: child protection programs, youth empowerment initiatives, and environmental conservation projects. We maintain transparency in our financial reporting and can provide impact reports to donors upon request.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Is my donation tax-deductible?</h3>
                        <span class="faq-toggle">+</span>
                    </div>
                    <div class="faq-answer">
                        <p>Protect the Child Safely is a registered NGO in Uganda (Permit No. 3119). Donation tax deductibility depends on the tax laws in your country. We can provide official receipts for your donations that may be used for tax purposes where applicable.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Can I specify how my donation is used?</h3>
                        <span class="faq-toggle">+</span>
                    </div>
                    <div class="faq-answer">
                        <p>Yes! You can specify if you'd like your donation to support a particular program area (child protection, youth empowerment, or environmental action). If you have a specific project in mind, you can contact us directly to discuss targeted giving options.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>How can I get updates on how my donation is making an impact?</h3>
                        <span class="faq-toggle">+</span>
                    </div>
                    <div class="faq-answer">
                        <p>We provide regular impact updates via email to all donors who share their contact information. You can also opt-in to our newsletter for program updates, success stories, and financial reports. We're committed to transparency and regularly share our progress with our supporters.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>What other ways can I support besides monetary donations?</h3>
                        <span class="faq-toggle">+</span>
                    </div>
                    <div class="faq-answer">
                        <p>There are many ways to support our mission! You can volunteer your time and skills, help spread awareness on social media, organize fundraising events in your community, or donate needed supplies. Contact us to learn more about non-monetary support opportunities.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <script>
        // FAQ toggle functionality
        document.querySelectorAll('.faq-question').forEach(question => {
            question.addEventListener('click', function() {
                const faqItem = this.parentElement;
                faqItem.classList.toggle('active');
            });
        });
    </script>


<?php include 'inc/footer.php' ?>