<?php
$title = "Family & Cooking Energy | Protect the Child Safely";
$tagline = "Promoting Safe, Efficient, and Sustainable Cooking Solutions";
$description = "Protect the Child Safely empowers families to adopt energy-saving stoves and cleaner cooking fuels to improve health, reduce environmental impact, and protect children.";
$keywords = "cooking energy, clean cooking, energy-saving stoves, household health, deforestation, child safety, sustainable energy";
$featured_image = 'https://images.unsplash.com/photo-1608889170825-5d3e9d59482a?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

<section class="kpy-hero" id="home">
    <img src="assets/images/cooking.jpg" alt="Family and Cooking Energy" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Family and Cooking Energy</h1>
        <p>Promoting safe, efficient, and sustainable cooking practices that protect health, the environment, and children.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Approach</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-fire"></i></div>
                <h3>Energy-Saving Stoves</h3>
                <p>Introducing stoves that consume less firewood, reducing household smoke and environmental impact.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-gas-pump"></i></div>
                <h3>Cleaner Cooking Fuels</h3>
                <p>Encouraging families with improved incomes to adopt cooking gas and other clean alternatives for healthier homes.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-leaf"></i></div>
                <h3>Environmental Protection</h3>
                <p>Reducing deforestation and household pollution by promoting sustainable cooking practices.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-child"></i></div>
                <h3>Child Safety & Health</h3>
                <p>Minimizing exposure to smoke and reducing risks for children who often collect firewood in unsafe areas.</p>
            </div>
        </div>
    </div>
</section>

<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/cooking.jpg" 
                     alt="Family Cooking Energy Impact" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>

            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Promoted adoption of energy-saving stoves to reduce fuel consumption and indoor smoke</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Encouraged use of cleaner fuels such as cooking gas for improved household air quality</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Reduced deforestation and environmental degradation by limiting firewood use</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Improved health outcomes by decreasing respiratory illnesses linked to smoke exposure</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Decreased risks for children and young women tasked with collecting firewood</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Supported families in transitioning to safer, more sustainable cooking practices</li>
                </ul>

                <p class="mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
                    Families using energy-saving stoves and cleaner fuels in rural Uganda, reducing indoor pollution and improving safety for children. Photo by PCS Team, 2023.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>
