<?php
$title = "Contact Us | Protect the Child Safely";
$tagline = "Empowering Youth for Climate Action & Child Protection";
$description = "Get in touch with Protect the Child Safely (PCS), a youth-led NGO committed to safeguarding children, empowering communities, and promoting environmental conservation in Uganda.";
$keywords = "Protect the Child Safely, PCS Uganda, child protection, youth empowerment Uganda, climate change action, sustainable development";
$featured_image = 'assets/images/logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>


    <!-- Hero Section -->
    <section class="kpy-hero" id="home">
        <img src="assets/images/child.jpeg" alt="Protect the Child Safely" class="kpy-hero-bg">
        <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
            <h1>Contact Us</h1>
            <p>Youth-led, youth-focused NGO safeguarding children, empowering communities, and promoting environmental conservation since 2019.</p>
        </div>
        <div class="kpy-hero-wave"></div>
    </section>


    <!-- Contact Section -->
    <section class="contact-section">
        <div class="contact-container">
            <div class="contact-header" data-aos="fade-up" data-aos-duration="1200">
                <h2>Get In Touch</h2>
            </div>

            <div class="contact-content">
                <!-- Contact Info Cards -->
                <div class="contact-info">
                    <div class="contact-card" data-aos="fade-right" data-aos-duration="1200">
                        <div class="contact-icon"><i class="fas fa-map-marker-alt"></i></div>
                        <div class="contact-details">
                            <h3>Our Office</h3>
                            <p>Protect the Child Safely (PCS)<br>Kampala, Uganda</p>
                        </div>
                    </div>
                    <div class="contact-card" data-aos="fade-right" data-aos-duration="1400">
                        <div class="contact-icon"><i class="fas fa-phone-alt"></i></div>
                        <div class="contact-details">
                            <h3>Call Us</h3>
                            <p>+256 700 123 456<br>+256 776 987 654</p>
                        </div>
                    </div>
                    <div class="contact-card" data-aos="fade-right" data-aos-duration="1600">
                        <div class="contact-icon"><i class="fas fa-envelope"></i></div>
                        <div class="contact-details">
                            <h3>Email Us</h3>
                            <p>info@pcsuganda.org<br>support@pcsuganda.org</p>
                        </div>
                    </div>
                </div>

                <!-- Map -->
                <div class="contact-map" data-aos="fade-left" data-aos-duration="1200">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.7460931895126!2d32.58252031475337!3d0.3475969640565439!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177dbb3b3c77a8ed%3A0x5a7e23f72c63941!2sKampala%2C%20Uganda!5e0!3m2!1sen!2sug!4v1695669479246!5m2!1sen!2sug" 
                        width="100%" 
                        height="400" 
                        style="border:0;" 
                        allowfullscreen="" 
                        loading="lazy">
                    </iframe>
                </div>
            </div>
        </div>
    </section>



<?php include 'inc/footer.php' ?>
