<?php
$title = "Community | Protect the Child Safely";
$tagline = "Empowering Communities for Climate Action & Forest Protection";
$description = "Learn how Protect the Child Safely (PCS) works with communities in Uganda to promote youth empowerment, gender equality, and sustainable forestry practices.";
$keywords = "community partnerships Uganda, youth forestry governance, gender equality REDD+, forest conservation communities, climate resilience Uganda";
$featured_image = 'assets/images/logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

    <!-- Hero Section -->
    <section class="kpy-hero" id="home">
        <img src="assets/images/real.jpg" alt="Community Partnerships with Protect the Child Safely" class="kpy-hero-bg">
        <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
            <h1>Community Partnerships</h1>
            <p>Working hand-in-hand with forest-dependent communities in Uganda to build climate resilience, empower youth, and promote gender equality in forestry governance.</p>
        </div>
        <div class="kpy-hero-wave"></div>
    </section>

    <!-- Community Cards Section -->
    <section class="kpy-community-section kpy-section">
        <div class="container">
            
            <div class="kpy-community-cards">
                <!-- Row 1 -->
                <div class="kpy-community-row">
                    <div class="kpy-community-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/innovation.jpg" alt="Community Engagement">
                            <div class="kpy-card-title">
                                <h3>Community-Centered Climate Action</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Protect the Child Safely works with communities in Uganda's Kagadi District and beyond, where forests are central to livelihoods, climate resilience, and cultural identity. We have built strong partnerships with young women and men, who are too often excluded from forestry governance and commercial value chains.</p>
                            <p>Our engagement is both formal—through leadership forums linked to national REDD+ committees, partnerships with local government, and structured training—and informal, by working directly with community groups, cooperatives, and households.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-community-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/waste-manage.png" alt="Youth Empowerment">
                            <div class="kpy-card-title">
                                <h3>Shaping the Future of Youth and Forest Governance</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Protect the Child Safely is positioning itself as a leader in advancing youth empowerment and gender equality in Uganda's forestry and REDD+ processes. Looking ahead, our vision is to inspire young women and men's representation in national forestry committees, expand their enterprises in forest-based value chains, and secure their active participation in carbon markets.</p>
                            <p>Our staff and partners bring expertise in policy advocacy, enterprise incubation, gender-sensitive safeguards, and the use of digital tools for monitoring forest resources.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Row 2 -->
                <div class="kpy-community-row">
                    <div class="kpy-community-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/cooking.jpg" alt="Forest Partnerships">
                            <div class="kpy-card-title">
                                <h3>Community Partnerships for Forests and Climate Resilience</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Protect the Child Safely works with communities nationwide and across the country, where forests are vital to livelihoods, climate resilience, and cultural identity. We have built strong and lasting relationships with young women and men, who are too often excluded from forestry governance and commercial value chains.</p>
                            <p>Our engagement takes multiple forms. Formally, we connect youth to national REDD+ committees, partner with local governments, and deliver structured training in forestry and climate finance. Informally, we work hand-in-hand with cooperatives, community groups, and households to strengthen grassroots capacity and local ownership.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-community-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/educ.jpeg" alt="Gender and Forests">
                            <div class="kpy-card-title">
                                <h3>Youth and Gender at the Forefront of Forest Protection</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Protect the Child Safely addresses Uganda's urgent challenge of deforestation, which threatens livelihoods, biodiversity, and increases carbon emissions. We empower young women and men—groups often excluded from forestry governance and carbon markets—by fostering their leadership in REDD+ decision-making, supporting their enterprises in forest value chains, and ensuring gender-responsive benefit-sharing systems.</p>
                            <p>Our approach combines training, policy advocacy, and enterprise incubation to create meaningful opportunities for youth in sustainable forestry and climate finance.</p>
                        </div>
                    </div>
                </div>
                
                <!-- Row 3 -->
                <div class="kpy-community-row">
                    <div class="kpy-community-card" data-aos="fade-right" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/real.jpg" alt="Leadership Scaling">
                            <div class="kpy-card-title">
                                <h3>Scaling Youth and Gender Leadership in Forests and Climate Action</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Protect the Child Safely is at the forefront of advancing youth empowerment and gender equality in Uganda's forestry and REDD+ efforts. Our vision is to increase the representation of young women and men in national forestry committees, expand youth enterprises in forest value chains, and ensure their active participation in the carbon market.</p>
                            <p>Our staff and partners bring deep expertise in policy advocacy, enterprise incubation, gender-sensitive safeguards, and the use of digital tools for forest monitoring. This ensures that our programs are technically sound, inclusive, and forward-looking.</p>
                        </div>
                    </div>
                    
                    <div class="kpy-community-card" data-aos="fade-left" data-aos-duration="1000">
                        <div class="kpy-card-image">
                            <img src="assets/images/child.jpeg" alt="Community Center">
                            <div class="kpy-card-title">
                                <h3>Putting Communities at the Center of Climate Action</h3>
                            </div>
                        </div>
                        <div class="kpy-card-content">
                            <p>Protect the Child Safely works primarily with young women and men in Uganda's forest-dependent communities—groups that often rely on forests for their livelihoods yet remain excluded from governance structures and carbon market opportunities. We engage these groups not as passive beneficiaries, but as active partners in shaping priorities and strategies for sustainable forestry and climate solutions.</p>
                            <p>One of our flagship initiatives is the Young Women and Men in Forestry & REDD+ Leadership Forum, which connects youth voices directly to Uganda's national REDD+ Steering Committee.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

   
  

<?php include 'inc/footer.php' ?>