<?php
$title = "Education, Research & Capacity Building | Protect the Child Safely";
$tagline = "Empowering Youth with Knowledge, Skills, and Innovation";
$description = "Protect the Child Safely equips young people with education, research opportunities, and capacity-building programs to drive climate resilience, sustainable waste management, and public health.";
$keywords = "education, research, capacity building, youth training, climate adaptation, waste management, innovation, environmental education";
$featured_image = 'https://images.unsplash.com/photo-1584697964193-d6f5f6c5e8d0?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>

<section class="kpy-hero" id="home">
    <img src="assets/images/football.png" alt="Education, Research, and Capacity Building" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Education, Research & Capacity Building</h1>
        <p>Equipping young people with the skills, confidence, and opportunities to tackle climate change, waste management, and public health challenges.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="kpy-mission" id="mission">
    <div class="container">
        <div class="kpy-mission-title" data-aos="fade-up" data-aos-duration="1000">
            <h2>Our Approach</h2>
        </div>
        <div class="kpy-mission-grid">
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-graduation-cap"></i></div>
                <h3>Youth Training</h3>
                <p>Combining technical knowledge with hands-on experience to empower youth in waste management, climate action, and public health.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-futbol"></i></div>
                <h3>Sports & Learning</h3>
                <p>Using football and community events as platforms to teach recycling, safe disposal, and climate adaptation in engaging and relatable ways.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="300" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-flask"></i></div>
                <h3>Research & Innovation</h3>
                <p>Supporting youth to explore solutions like waste-to-energy projects, tree planting models, and digital climate monitoring tools.</p>
            </div>
            <div class="kpy-mission-card" data-aos="fade-up" data-aos-delay="400" data-aos-duration="1000">
                <div class="kpy-mission-icon"><i class="fas fa-handshake"></i></div>
                <h3>Capacity Building</h3>
                <p>Strengthening local capacity by working with schools, leaders, and policymakers to foster shared knowledge and sustainable practices.</p>
            </div>
        </div>
    </div>
</section>

<section class="features-section" id="impact">
    <div class="container">
        <div class="features-content" data-aos="fade-up" data-aos-duration="1200">
            <div class="features-image" data-aos="fade-right" data-aos-duration="1200">
                <img src="assets/images/football.png" 
                     alt="Youth Education and Capacity Building" 
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>

            <div class="features-details" data-aos="fade-left" data-aos-duration="1200" data-aos-delay="200">
                <h2 class="section-title" data-aos="fade-down" data-aos-duration="1000">Our <span>Impact</span></h2>
                
                <ul class="features-list">
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="100"><i class="fas fa-check-circle"></i> Trained youth leaders with knowledge and confidence to address climate, waste, and health challenges</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200"><i class="fas fa-check-circle"></i> Linked sports and environmental education to engage thousands of young people in meaningful learning</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="300"><i class="fas fa-check-circle"></i> Supported innovative solutions such as waste-to-energy projects and tree planting initiatives</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="400"><i class="fas fa-check-circle"></i> Strengthened partnerships with schools, leaders, and policymakers to expand impact</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="500"><i class="fas fa-check-circle"></i> Built capacity for climate resilience through shared community knowledge and action</li>
                    <li data-aos="fade-up" data-aos-duration="1000" data-aos-delay="600"><i class="fas fa-check-circle"></i> Empowered youth to shape sustainable futures for themselves, their families, and their communities</li>
                </ul>

                <p class="mt-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="700">
                    Youth participating in football tournaments and workshops on recycling, safe disposal, and climate adaptation — combining fun with learning. Photo by PCS Team, 2023.
                </p>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>
