<?php
$title = "Board Members | Youth Leadership & Environmental Action";
$tagline = "Empowering Youth for Climate Action - Our Leadership Team";
$description = "Meet the Board Members of Protect the Child Safely, comprising passionate youth leaders and experts dedicated to climate action, environmental protection, and sustainable development in Uganda.";
$keywords = "Protect the Child Safely board, youth climate leaders, Uganda environmental action, climate change advocacy, youth empowerment Uganda, sustainable development, REDD+ governance, community mobilization";
$featured_image = 'https://juhdsjuba.com/assets/images/JUHDS-logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>


<section class="kpy-hero" id="home">
    <img src="assets/images/educ.jpeg" alt="Family and Cooking Energy" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Board Members</h1>
        <p>Promoting safe, efficient, and sustainable cooking practices that protect health, the environment, and children.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>

<section class="team-section">
    <div class="team-grid">
        <!-- Card 1 -->
        <div class="team-card">
            <div class="card-image">
                <img src="assets/images/baguma.png" alt="Prof. David Baguma">
                <div class="card-gradient"></div>
            </div>
            <div class="card-content">
                <h3 class="card-name">PROF. DAVID BAGUMA</h3>
                <p class="card-title">Board Chair</p>
                <button class="card-button" data-modal="modal1">Full Profile</button>
            </div>
        </div>

        <!-- Card 2 -->
        <div class="team-card">
            <div class="card-image">
                <img src="assets/images/blessed.png" alt="Blessed Antangaize">
                <div class="card-gradient"></div>
            </div>
            <div class="card-content">
                <h3 class="card-name">BLESSED ANTANGAIZE</h3>
                <p class="card-title">Executive Director</p>
                <button class="card-button" data-modal="modal2">Full Profile</button>
            </div>
        </div>

        <!-- Card 3 -->
        <div class="team-card">
            <div class="card-image">
                <img src="assets/images/victor.png" alt="Victor Ahurira">
                <div class="card-gradient"></div>
            </div>
            <div class="card-content">
                <h3 class="card-name">VICTOR AHURIRA</h3>
                <p class="card-title">Member & Program Manager</p>
                <button class="card-button" data-modal="modal3">Full Profile</button>
            </div>
        </div>

        <!-- Card 4 -->
        <div class="team-card">
            <div class="card-image">
                <img src="assets/images/gracious.png" alt="Gracious Ampurire">
                <div class="card-gradient"></div>
            </div>
            <div class="card-content">
                <h3 class="card-name">GRACIOUS AMPURIRE</h3>
                <p class="card-title">Community Mobilization & Partnerships</p>
                <button class="card-button" data-modal="modal4">Full Profile</button>
            </div>
        </div>
        <div class="team-card">
            <div class="card-image">
                <img src="assets/images/shallon.png" alt="Shallon Mbabazi">
                <div class="card-gradient"></div>
            </div>
            <div class="card-content">
                <h3 class="card-name">SHALLON MBABAZI</h3>
                <p class="card-title">Board Member Secretary/Treasurer</p>
                <button class="card-button" data-modal="modal5">Full Profile</button>
            </div>
        </div>
    </div>
</section>

<!-- Modal 1 -->
<div id="modal1" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h2 class="modal-title">Profile Details</h2>
      <button class="close-modal">&times;</button>
    </div>
    <div class="modal-body">
      <div class="profile-main">
        <div class="profile-image">
          <img src="assets/images/baguma.png" alt="Prof. David Baguma">
        </div>
        <div class="profile-info">
          <h2 class="profile-name">PROF. DAVID BAGUMA</h2>
          <p class="profile-role">Board Chair</p>
          <p class="profile-bio">
            Prof. David Baguma is an accomplished scholar and development practitioner with over 27 years of experience in environmental engineering, public health, climate change, and policy analysis. He has worked extensively across Africa and Asia with governments, UN agencies, and NGOs, focusing on climate resilience, water and sanitation, renewable energy, and sustainable development. As a professor, researcher, and consultant, he has published widely and guided numerous policy reforms and community initiatives. At Protect the Child Safely, Prof. Baguma provides strategic leadership, governance oversight, and technical expertise, ensuring the organization remains youth-focused, accountable, and impactful in addressing climate and social challenges. Prof. David Baguma – Board Chairperson can be reached at dbaguma@protectthechildsafely.org
          </p>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal 2 -->
<div id="modal2" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h2 class="modal-title">Profile Details</h2>
      <button class="close-modal">&times;</button>
    </div>
    <div class="modal-body">
      <div class="profile-main">
        <div class="profile-image">
          <img src="assets/images/blessed.png" alt="Blessed Antangaize">
        </div>
        <div class="profile-info">
          <h2 class="profile-name">BLESSED ANTANGAIZE</h2>
          <p class="profile-role">Executive Director</p>
          <p class="profile-bio">
            Blessed leads Protect the Child Safely as Executive Director, providing overall vision and strategic direction. With expertise in youth attractive events, policy advocacy, REDD+ governance, and gender-sensitive safeguards, he has championed youth inclusion in Uganda’s competitive events, forestry and climate policy processes. Blessed spearheads the youth sports events, Forestry &amp; REDD+ Leadership Forum, linking grassroots voices to national structures. Drawing on his lived experience in youth events, and forest-dependent communities, he mobilizes thousands of youth through forums and football tournaments to raise awareness. Blessed’s leadership ensures bridging community priorities with national and international climate action frameworks. Blessed Antangaize – Executive Director can be reach at email: bantagaize@protectthechildsafely.org
          </p>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal 3 -->
<div id="modal3" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h2 class="modal-title">Profile Details</h2>
      <button class="close-modal">&times;</button>
    </div>
    <div class="modal-body">
      <div class="profile-main">
        <div class="profile-image">
          <img src="assets/images/victor.png" alt="Victor Ahurira">
        </div>
        <div class="profile-info">
          <h2 class="profile-name">VICTOR AHURIRA</h2>
          <p class="profile-role">Member & Program Manager, ICT, Enterprises and Finance</p>
          <p class="profile-bio">
            Victor oversees Protect the Child Safely’s information systems, enterprise development and financial inclusion programs. He a youth, with a background in cyber security, finance and entrepreneurship, he manages digital infographics, and the incubation of 100 youth-led SMEs. Victor is exploring partnerships with banks to design products and develop digital MRV tools to increase youth participation in social events and carbon markets. His ability to combine technical ICT systems and financial skills with community engagement has expanded opportunities for the young. Victor ensures youth enterprises are profitable, sustainable, and contribute to Uganda’s climate and development goals. He is pursuing a Cyber Security study at ISBAT University in Kampala, Uganda. Victor Ahurira – Member and Program Manager, ICT, Enterprises and Finance. Can be reached at email: vahurira@protecthechildsafely.org
          </p>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Modal 4 -->
<div id="modal4" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h2 class="modal-title">Profile Details</h2>
      <button class="close-modal">&times;</button>
    </div>
    <div class="modal-body">
      <div class="profile-main">
        <div class="profile-image">
          <img src="assets/images/gracious.png" alt="Gracious Ampurire">
        </div>
        <div class="profile-info">
          <h2 class="profile-name">GRACIOUS AMPURIRE</h2>
          <p class="profile-role">Community Mobilization & Partnerships Coordinator</p>
          <p class="profile-bio">
            Gracious leads community mobilization and partnership building,a youth, ensuring Protect the Child Safely’s programs are grounded in local realities. He has extensive experience organizing youth groups and community events, including football tournaments that attract over 1,000 participants while raising awareness on forestry and gender equality. Gracious fosters trust between youth, district officials, and REDD+ stakeholders, making him central to program implementation. His lived experience in rural Uganda enhances credibility and ability to mobilize underrepresented groups. Gracious’s work ensures partnerships, cultural relevance, and community ownership, positioning Protect the Child as a trusted grassroots climate actor. He is pursuing a bachelor’s degree in international business studies at Near East University in Cyprus. Gracious Ampurire, – Member Community Mobilization &amp; Partnerships Coordinator. Can be reached at email: gampurire@protectthechildsafely.org
          </p>
        </div>
      </div>
    </div>
  </div>
</div>
<div id="modal5" class="modal">
  <div class="modal-content">
    <div class="modal-header">
      <h2 class="modal-title">Profile Details</h2>
      <button class="close-modal">&times;</button>
    </div>
    <div class="modal-body">
      <div class="profile-main">
        <div class="profile-image">
          <img src="assets/images/shallon.png" alt="Shallon Mbabazi">
        </div>
        <div class="profile-info">
          <h2 class="profile-name">SHALLON MBABAZI</h2>
          <p class="profile-role">Board Member Secretary/Treasurer</p>
          <p class="profile-bio">
            Shallon Mbabazi is a passionate advocate for child protection, community empowerment, and Christian family values. With over 25 years of experience supporting social welfare initiatives, she serves as a founding board member of Protect the Child Safely (PCS). Hailing from western Uganda, Shallon brings strong local insight, deep cultural understanding, and commitment to gender and youth inclusion in forest-dependent communities. She plays a pivotal role in shaping the organization’s community engagement strategies and promoting faith-based leadership among women and families. <br><br>
            <strong>Contact:</strong> smbabazi@protectthechildsafely.org
          </p>
        </div>
      </div>
    </div>
  </div>
</div>
    

<?php include 'inc/footer.php' ?>