/** ==========================================================
Navbar
===========================================================**/
 
 document.addEventListener('DOMContentLoaded', function() { const animatedElements = document.querySelectorAll('.side-image-layout, .qualifications-section'); function checkScroll() { animatedElements.forEach(element => { const elementPosition = element.getBoundingClientRect().top; const screenPosition = window.innerHeight / 1.3; if(elementPosition < screenPosition) { element.classList.add('show'); } }); } window.addEventListener('scroll', checkScroll); checkScroll();  });
 

  // Navbar scroll effect
  window.addEventListener('scroll', function() {
    const navbar = document.querySelector('.navbar');
    if (window.scrollY > 50) {
      navbar.classList.add('scrolled');
    } else {
      navbar.classList.remove('scrolled');
    }
  });

  // Add animation to dropdowns on hover
  document.addEventListener('DOMContentLoaded', function() {
    const dropdowns = document.querySelectorAll('.dropdown');
    
    dropdowns.forEach(dropdown => {
      dropdown.addEventListener('mouseenter', function() {
        const menu = this.querySelector('.dropdown-menu');
        menu.style.opacity = '1';
        menu.style.transform = 'translateY(0)';
        menu.style.pointerEvents = 'auto';
      });
      
      dropdown.addEventListener('mouseleave', function() {
        const menu = this.querySelector('.dropdown-menu');
        menu.style.opacity = '0';
        menu.style.transform = 'translateY(10px)';
        menu.style.pointerEvents = 'none';
      });
    });
    
    // Initialize Bootstrap offcanvas
    const offcanvasElement = document.getElementById('offcanvasNavbar');
    const offcanvas = new bootstrap.Offcanvas(offcanvasElement);
  });


  // Navbar scroll effect
  window.addEventListener('scroll', function() {
    const navbar = document.querySelector('.navbar');
    if (window.scrollY > 50) {
      navbar.classList.add('scrolled');
    } else {
      navbar.classList.remove('scrolled');
    }
/** ==========================================================
Back to top
===========================================================**/
    const backToTop = document.querySelector('.back-to-top');
    if (window.scrollY > 300) {
      backToTop.classList.add('active');
    } else {
      backToTop.classList.remove('active');
    }
  });


  
  document.addEventListener('DOMContentLoaded', function() {
    const dropdowns = document.querySelectorAll('.dropdown');
    
    dropdowns.forEach(dropdown => {
      dropdown.addEventListener('mouseenter', function() {
        const menu = this.querySelector('.dropdown-menu');
        menu.style.opacity = '1';
        menu.style.transform = 'translateY(0)';
        menu.style.pointerEvents = 'auto';
      });
      
      dropdown.addEventListener('mouseleave', function() {
        const menu = this.querySelector('.dropdown-menu');
        menu.style.opacity = '0';
        menu.style.transform = 'translateY(10px)';
        menu.style.pointerEvents = 'none';
      });
    });
    
    // Initialize Bootstrap offcanvas
    const offcanvasElement = document.getElementById('offcanvasNavbar');
    const offcanvas = new bootstrap.Offcanvas(offcanvasElement);
    
    // Back to top functionality
    document.querySelector('.back-to-top').addEventListener('click', function() {
      window.scrollTo({ top: 0, behavior: 'smooth' });
    });
  });
  
  
  
  document.querySelectorAll('a[href^="#"]').forEach(anchor => {
  anchor.addEventListener("click", function(e) {
    e.preventDefault();
    document.querySelector(this.getAttribute("href")).scrollIntoView({
      behavior: "smooth",
      block: "start"
    });
  });
});

/** ==========================================================
Data AOS
===========================================================**/
// Data AOS
document.addEventListener('DOMContentLoaded', function() {
        AOS.init({
            duration: 1000,
            once: true,
            offset: 100
        });
    });
    
    
 /** ==========================================================
Progress Bar
===========================================================**/   
 document.addEventListener("DOMContentLoaded", function() {
  const bars = document.querySelectorAll(".progress-bar");

  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        const target = entry.target;
        const percent = target.getAttribute("data-width");
        if (percent) {
          target.style.width = percent + "%";
        }
        observer.unobserve(target);
      }
    });
  }, { threshold: 0.5 });

  bars.forEach(bar => {
    let width = bar.getAttribute("data-width"); // get value from attribute
    bar.style.width = "0"; // start at 0
    observer.observe(bar);
  });
});


/** ==========================================================
Home stats
===========================================================**/
document.addEventListener("DOMContentLoaded", () => {
  const counters = document.querySelectorAll(".counter");

  const speed = 100; // smaller = faster

  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        const counter = entry.target;
        const updateCount = () => {
          const target = +counter.getAttribute("data-target");
          const count = +counter.innerText.replace(/\D/g,'');
          const increment = Math.ceil(target / speed);

          if (count < target) {
            counter.innerText = count + increment;
            setTimeout(updateCount, 30);
          } else {
            counter.innerText = target.toLocaleString() + "+"; // final with +
          }
        };
        updateCount();
        observer.unobserve(counter);
      }
    });
  }, { threshold: 0.5 });

  counters.forEach(counter => {
    counter.innerText = "0";
    observer.observe(counter);
  });
});   




/** ==========================================================
Team Modal
===========================================================**/

        document.addEventListener('DOMContentLoaded', function() {
            // Get all modal buttons
            const modalButtons = document.querySelectorAll('.card-button');
            const modals = document.querySelectorAll('.modal');
            const closeButtons = document.querySelectorAll('.close-modal');
            
            // Open modal when button is clicked
            modalButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const modalId = button.getAttribute('data-modal');
                    const modal = document.getElementById(modalId);
                    modal.classList.add('show');
                    document.body.style.overflow = 'hidden'; // Prevent scrolling
                });
            });
            
            // Close modal when close button is clicked
            closeButtons.forEach(button => {
                button.addEventListener('click', () => {
                    const modal = button.closest('.modal');
                    modal.classList.remove('show');
                    document.body.style.overflow = ''; // Enable scrolling
                });
            });
            
            // Close modal when clicking outside the modal content
            modals.forEach(modal => {
                modal.addEventListener('click', (e) => {
                    if (e.target === modal) {
                        modal.classList.remove('show');
                        document.body.style.overflow = ''; // Enable scrolling
                    }
                });
            });
            
            // Close modal with Escape key
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    modals.forEach(modal => {
                        if (modal.classList.contains('show')) {
                            modal.classList.remove('show');
                            document.body.style.overflow = ''; // Enable scrolling
                        }
                    });
                }
            });
        });


/** ==========================================================
Stats
===========================================================**/
document.addEventListener('DOMContentLoaded', () => {
  const counters = Array.from(document.querySelectorAll('.stat-number'));
  if (!counters.length) return;

  // Helper: parse data-count robustly (allow commas)
  const getTarget = el => {
    const raw = (el.getAttribute('data-count') || '').toString().trim();
    return Math.max(0, parseInt(raw.replace(/,/g, ''), 10) || 0);
  };

  // Easing: easeOutCubic
  const easeOutCubic = t => 1 - Math.pow(1 - t, 3);

  // Animate a single counter over duration (ms)
  const animate = (el, duration = 1500) => {
    const start = 0;
    const end = getTarget(el);
    const startTime = performance.now();
    const step = now => {
      const elapsed = now - startTime;
      const progress = Math.min(elapsed / duration, 1);
      const eased = easeOutCubic(progress);
      const value = Math.floor(start + (end - start) * eased);
      el.innerText = value.toLocaleString();
      if (progress < 1) {
        requestAnimationFrame(step);
      } else {
        el.innerText = end.toLocaleString(); // ensure exact final value
      }
    };
    requestAnimationFrame(step);
  };

  let triggered = false;
  const section = document.querySelector('.mission-section');

  const observerOptions = { root: null, threshold: 0.25 }; // 25% visible
  const io = new IntersectionObserver((entries, obs) => {
    entries.forEach(entry => {
      if (entry.isIntersecting && !triggered) {
        // Stagger the counters slightly for nicer effect
        counters.forEach((el, i) => setTimeout(() => animate(el, 1400 + i * 300), i * 150));
        triggered = true;
        obs.disconnect();
      }
    });
  }, observerOptions);

  if (section) {
    io.observe(section);
  } else {
    // Fallback: animate after short delay if .mission-section not found
    console.warn('mission-section not found — running fallback counter animation.');
    counters.forEach((el, i) => setTimeout(() => animate(el, 1400 + i * 300), 500 + i * 150));
  }
});



document.addEventListener('DOMContentLoaded', function() {
  const slider = document.querySelector('.initiatives-slider');
  const slides = document.querySelectorAll('.initiative-slide');
  const prevButton = document.querySelector('.slider-prev');
  const nextButton = document.querySelector('.slider-next');
  const dotsContainer = document.querySelector('.slider-dots');
  
  let currentSlide = 0;
  const slidesPerView = window.innerWidth < 768 ? 1 : window.innerWidth < 992 ? 2 : 3;
  const totalSlides = slides.length;
  
  // Create dots
  for (let i = 0; i < Math.ceil(totalSlides / slidesPerView); i++) {
    const dot = document.createElement('div');
    dot.classList.add('slider-dot');
    if (i === 0) dot.classList.add('active');
    dot.addEventListener('click', () => goToSlide(i * slidesPerView));
    dotsContainer.appendChild(dot);
  }
  
  function updateSlider() {
    const slideWidth = slides[0].offsetWidth + 30; // 30px gap
    slider.style.transform = `translateX(-${currentSlide * slideWidth}px)`;
    
    // Update dots
    document.querySelectorAll('.slider-dot').forEach((dot, index) => {
      const groupStart = index * slidesPerView;
      dot.classList.toggle('active', currentSlide >= groupStart && currentSlide < groupStart + slidesPerView);
    });
  }
  
  function goToSlide(slideIndex) {
    currentSlide = slideIndex;
    updateSlider();
  }
  
  function nextSlide() {
    const maxSlide = totalSlides - slidesPerView;
    currentSlide = currentSlide < maxSlide ? currentSlide + 1 : 0;
    updateSlider();
  }
  
  function prevSlide() {
    const maxSlide = totalSlides - slidesPerView;
    currentSlide = currentSlide > 0 ? currentSlide - 1 : maxSlide;
    updateSlider();
  }
  
  prevButton.addEventListener('click', prevSlide);
  nextButton.addEventListener('click', nextSlide);
  
  // Auto slide every 5s
  setInterval(nextSlide, 5000);
  
  // Handle resize
  window.addEventListener('resize', function() {
    currentSlide = 0;
    updateSlider();
  });
  
  // Init
  updateSlider();
});