<?php
$title = "Who we are | Youth Leadership & Environmental Action";
$tagline = "Empowering Youth for Climate Action - Our Leadership Team";
$description = "Meet the Board Members of Protect the Child Safely, comprising passionate youth leaders and experts dedicated to climate action, environmental protection, and sustainable development in Uganda.";
$keywords = "Protect the Child Safely board, youth climate leaders, Uganda environmental action, climate change advocacy, youth empowerment Uganda, sustainable development, REDD+ governance, community mobilization";
$featured_image = 'https://juhdsjuba.com/assets/images/JUHDS-logo.png';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>


    
  
</head>
<body>
    <section class="kpy-hero" id="home">
    <img src="assets/images/educ.jpeg" alt="Youth Leadership" class="kpy-hero-bg">
    <div class="kpy-hero-content kpy-container" data-aos="zoom-in" data-aos-duration="1200">
        <h1>Who we are</h1>
        <p>Youth-led, youth-focused NGO safeguarding children, empowering communities, and promoting environmental conservation since 2019.</p>
    </div>
    <div class="kpy-hero-wave"></div>
</section>


<!-- Mission Section -->
<section class="mission-section">
  <div class="container">
    <div class="mission-grid">
      
      <!-- Left Column: Content -->
      <div class="mission-details" data-aos="fade-right">
        <div class="section-title">
          <h2>Our Mission</h2>
        </div>
        <div class="mission-content">
          <p>Protect the Child Safely exists to safeguard the rights and wellbeing of children and youth while empowering families and communities to thrive in a changing climate. We are committed to promoting child health, youth empowerment, and gender equality through education, research, and capacity building.</p>
          <p>By integrating environmental conservation, climate change adaptation, and sustainable resource management into our programs, we strengthen families and equip young people with the skills, technologies, and opportunities needed to build resilient livelihoods.</p>
        </div>
        <div class="mission-stats">
          <div class="stat-item">
            <div class="stat-number" data-count="2019">0</div>
            <div class="stat-label">Year Established and</div>
          </div>
          <div class="stat-item">
            <div class="stat-number" data-count="100">0</div>
            <div class="stat-label">Youth-Led Businesses Supported</div>
          </div>
          <div class="stat-item">
            <div class="stat-number" data-count="50000">0</div>
            <div class="stat-label">tCO₂e Carbon Credits Generated</div>
          </div>
        </div>
      </div>

      <!-- Right Column: Image -->
      <div class="mission-image" data-aos="zoom-in">
        <img src="assets/images/real.jpg" alt="Our Mission">
      </div>
    </div>
  </div>
</section>
<!-- Leadership Structure Section -->
<section class="leadership-section">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Youth Leadership Structure</h2>
            </div>
            <div class="leadership-structure">
                <div class="leadership-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="leadership-icon">👤</div>
                    <h3>Youth Executive Leader</h3>
                    <p>At the helm of the organization is a Youth Executive Leader, currently aged 22, who provides strategic direction and embodies the innovative spirit of the organization.</p>
                    <span class="age-bracket">15-35 Age Bracket</span>
                </div>
                <div class="leadership-card" data-aos="fade-up" data-aos-delay="400">
                    <div class="leadership-icon">👥</div>
                    <h3>Leadership Staff</h3>
                    <p>More than 50% of program managers, officers, and coordinators are between 18 and 35 years old, bringing fresh perspectives and deep understanding of community challenges.</p>
                    <span class="age-bracket">18-35 Age Bracket</span>
                </div>
                <div class="leadership-card" data-aos="fade-up" data-aos-delay="600">
                    <div class="leadership-icon">🏛️</div>
                    <h3>Board of Directors</h3>
                    <p>Six out of nine board members fall within the 21 to 34 age range, giving young people a decisive voice in shaping priorities and long-term vision.</p>
                    <span class="age-bracket">21-34 Age Bracket</span>
                </div>
            </div>
        </div>
    </section>
 <!-- Climate Action Section -->
    <section class="climate-section">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Youth at the Heart of Forest and Climate Action</h2>
            </div>
            <div class="climate-content" data-aos="fade-up" data-aos-delay="200">
                <p>We address the urgent challenge of deforestation and its impact on livelihoods, biodiversity, and carbon emissions in Uganda. We focus on empowering young women and men—groups often excluded from forestry governance and carbon markets.</p>
                <p>Through training, policy advocacy, and enterprise incubation, we've strengthened youth participation in sustainable forestry and carbon finance.</p>
            </div>
            <div class="impact-grid">
                <div class="impact-item" data-aos="zoom-in" data-aos-delay="300">
                    <div class="impact-number">100+</div>
                    <div class="impact-label">Youth-Led Businesses Supported</div>
                </div>
                <div class="impact-item" data-aos="zoom-in" data-aos-delay="400">
                    <div class="impact-number">50,000</div>
                    <div class="impact-label">tCO₂e Carbon Credits Generated</div>
                </div>
                <div class="impact-item" data-aos="zoom-in" data-aos-delay="500">
                    <div class="impact-number">Policy</div>
                    <div class="impact-label">Reforms for Gender Equity in REDD+</div>
                </div>
            </div>
        </div>
    </section>
    <!-- Board Composition Section -->
    <section class="board-section">
        <div class="container">
            <div class="section-title" data-aos="fade-up">
                <h2>Board Composition</h2>
            </div>
            <div class="board-content">
                <div class="board-text" data-aos="fade-right">
                    <h3>Youth-Driven Governance</h3>
                    <p>Our governance model reflects our commitment to youth leadership. A majority of our Board of Directors are youth, ensuring that young people have a decisive voice in shaping the NGO's priorities, accountability framework, and long-term vision.</p>
                    <p>Out of the nine board members, six fall within the 21 to 34 age range. Senior advisors and older members serve mainly as mentors and supporters, creating a balanced approach that combines youthful innovation with experienced guidance.</p>
                </div>
                <div class="board-chart" data-aos="fade-left" data-aos-delay="300">
                    <div class="chart-container">
                        <div class="chart-segment segment-youth"></div>
                        <div class="chart-segment segment-other"></div>
                        <div class="chart-center">
                            <div class="total">9</div>
                            <div class="label">Total Members</div>
                        </div>
                    </div>
                    <div class="chart-legend">
                        <div class="legend-item">
                            <div class="legend-color legend-youth"></div>
                            <span>Youth Members (6)</span>
                        </div>
                        <div class="legend-item">
                            <div class="legend-color legend-other"></div>
                            <span>Other Members (3)</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

   


<?php include 'inc/footer.php' ?>