<?php
$title = "Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Ngazi Arts creates beautiful animations, films, and live performances based on Ugandan folktales. Our content helps children discover their cultural heritage while promoting literacy, critical thinking, and pride.";
$keywords = "Ngazi Arts, African stories for kids, Ugandan animations, children's culture, learning through play, African identity, folktales for children, educational content Africa, Uganda creative company";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>
<?php include 'inc/breadcrumb.php'?>



    <header class="team-header">
        <h2 class="home-section-title" data-aos="fade-left">Our Textile Experts</h2>
        <p>Meet the skilled artisans and visionaries who bring creativity and precision to every fabric we produce.</p>
    </header>

    <div class="team-filter" data-aos="fade-up">
        <button class="filter-btn active" data-filter="all">All Team</button>
        <button class="filter-btn" data-filter="design">Design</button>
        <button class="filter-btn" data-filter="production">Production</button>
        <button class="filter-btn" data-filter="quality">Quality Control</button>
    </div>

    <div class="team-container">
        <div class="team-grid">
            <!-- Team Member 1 -->
            <div class="team-member" data-aos="fade-right" data-category="design">
                <div class="member-img">
                    <img src="https://i.pinimg.com/736x/5d/c7/43/5dc743fbd756deb89aa63b9889601dee.jpg" alt="Oliver Nakatende">
                </div>
                <div class="member-info" data-aos="fade-up">
                    <h3>Oliver Nakatende</h3>
                    <span class="role">Head Textile Designer</span>
                    <p>Elena brings over 15 years of international experience in textile design and trend forecasting.</p>
                    <div class="social-links" data-aos="fade-left">
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-behance"></i></a>
                    </div>
                </div>
            </div>

            <!-- Team Member 2 -->
            <div class="team-member" data-aos="fade-up" data-category="production">
                <div class="member-img">
                    <img src="https://i.pinimg.com/1200x/10/8d/3b/108d3b91d89ff52b4826e41bb3724f28.jpg" alt="Alfred Kyenyune">
                </div>
                <div class="member-info" data-aos="fade-up">
                    <h3>Alfred Kyenyune</h3>
                    <span class="role" data-aos="fade-up">Production Manager</span>
                    <p>James specializes in optimizing textile manufacturing processes while maintaining sustainable practices.</p>
                    <div class="social-links" data-aos="fade-up">
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-medium-m"></i></a>
                    </div>
                </div>
            </div>

            <!-- Team Member 3 -->
            <div class="team-member"  data-aos="fade-right" data-category="design">
                <div class="member-img">
                    <img src="https://i.pinimg.com/1200x/1b/e5/7e/1be57e732a85c0d9ea96c92f3a4b64e1.jpg" alt="Mary Nansubuga">
                </div>
                <div class="member-info" data-aos="fade-up">
                    <h3>Mary Nansubuga</h3>
                    <span class="role" data-aos="fade-up">Pattern Design Specialist</span>
                    <p>Sophie's innovative pattern designs have won several industry awards for their creativity.</p>
                    <div class="social-links" data-aos="fade-right">
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-pinterest-p"></i></a>
                        <a href="#"><i class="fab fa-dribbble"></i></a>
                    </div>
                </div>
            </div>

            <!-- Team Member 4 -->
            <div class="team-member" data-aos="fade-left" data-category="quality">
                <div class="member-img">
                    <img src="https://i.pinimg.com/736x/a1/3f/e5/a13fe593cd044397afc8ce5d47598333.jpg" alt="Joshua Mugerwa">
                </div>
                <div class="member-info" data-aos="fade-up" >
                    <h3>Joshua Mugerwa</h3>
                    <span class="role" data-aos="fade-up">Quality Assurance Director</span>
                    <p>Michael ensures every textile meets our rigorous quality standards before reaching customers.</p>
                    <div class="social-links" data-aos="fade-left">
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>
            </div>

            <!-- Team Member 5 -->
            <div class="team-member" data-aos="fade-up" data-category="production">
                <div class="member-img">
                    <img src="https://i.pinimg.com/1200x/ff/24/0c/ff240c125fef72bb8539eb9c7b85cab6.jpg" alt="Judith Akello">
                </div>
                <div class="member-info" data-aos="fade-up">
                    <h3>Judith Akello</h3>
                    <span class="role" data-aos="fade-up">Textile Engineer</span>
                    <p>Priya specializes in developing innovative fabric technologies with enhanced functionality.</p>
                    <div class="social-links" data-aos="fade-up">
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-researchgate"></i></a>
                        <a href="#"><i class="fab fa-google-scholar"></i></a>
                    </div>
                </div>
            </div>

            <!-- Team Member 6 -->
            <div class="team-member" data-aos="fade-right" data-category="design">
                <div class="member-img">
                    <img src="https://i.pinimg.com/1200x/81/6e/e3/816ee34cb39233b7c5c73fbc40db627c.jpg" alt="Francis Okurut">
                </div>
                <div class="member-info" data-aos="fade-up">
                    <h3>Francis Okurut</h3>
                    <span class="role" data-aos="fade-up">Color Specialist</span>
                    <p>David has an exceptional eye for color theory and develops our seasonal color palettes.</p>
                    <div class="social-links" data-aos="fade-right">
                        <a href="#"><i class="fab fa-linkedin-in"></i></a>
                        <a href="#"><i class="fab fa-instagram"></i></a>
                        <a href="#"><i class="fab fa-artstation"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="team-gallery">
        <h2 class="home-section-title" data-aos="fade-up">Behind The Scenes</h2>
        <div class="gallery-grid">
            <div class="gallery-item" data-aos="fade-up"><img src="https://i.pinimg.com/736x/6c/82/bd/6c82bd60fb2a9520bb3e99c777aaf75a.jpg" alt="Textile Production"></div>
            <div class="gallery-item" data-aos="fade-up"><img src="https://i.pinimg.com/1200x/83/4b/8f/834b8f45658d48f5ced2d8e6203e1cde.jpg" alt="Textile Design"></div>
            <div class="gallery-item" data-aos="fade-up"><img src="https://i.pinimg.com/1200x/51/57/49/51574976c05418a2bd9284305b7c0c57.jpg" alt="Textile Fabric"></div>
            <div class="gallery-item" data-aos="fade-up"><img src="https://i.pinimg.com/736x/54/c5/71/54c57158c2f904bc2e04c0876ca63e8d.jpg" alt="Textile Pattern"></div>
        </div>
    </div>

    <script>
        // Filter functionality
        document.addEventListener('DOMContentLoaded', function() {
            const filterButtons = document.querySelectorAll('.filter-btn');
            const teamMembers = document.querySelectorAll('.team-member');
            
            filterButtons.forEach(button => {
                button.addEventListener('click', () => {
                    // Remove active class from all buttons
                    filterButtons.forEach(btn => btn.classList.remove('active'));
                    
                    // Add active class to clicked button
                    button.classList.add('active');
                    
                    const filterValue = button.getAttribute('data-filter');
                    
                    teamMembers.forEach(member => {
                        if (filterValue === 'all' || member.getAttribute('data-category') === filterValue) {
                            member.style.display = 'block';
                        } else {
                            member.style.display = 'none';
                        }
                    });
                });
            });
        });

        // Add Font Awesome icons
        document.head.innerHTML += '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">';
    </script>

<?php include 'inc/footer.php'?>