<?php
$title = "Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Ngazi Arts creates beautiful animations, films, and live performances based on Ugandan folktales. Our content helps children discover their cultural heritage while promoting literacy, critical thinking, and pride.";
$keywords = "Ngazi Arts, African stories for kids, Ugandan animations, children's culture, learning through play, African identity, folktales for children, educational content Africa, Uganda creative company";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>
<?php include 'inc/breadcrumb.php'?>


    <!-- Services Section -->
    <section class="work-services">
        <div class="work-container">
            <div class="work-section-title" data-aos="fade-up">
                <h2 class="home-section-title" data-aos="fade-up">What We Do</h2>
                <p>We create captivating content across multiple platforms to engage children and young people with culturally rich stories and experiences.</p>
            </div>
            <div class="work-services-grid">
                <div class="work-service-card">
                    <div class="work-service-icon"data-aos="fade-up">
                        <i class="fas fa-video" data-aos="fade-up"></i>
                    </div>
                    <div class="work-service-content" data-aos="fade-up">
                        <h3>Animation & Video</h3>
                        <p>We produce vibrant animations and YouTube videos that bring African folktales and cultural stories to life for young audiences.</p>
                        <a href="#" class="work-read-more">Learn More</a>
                    </div>
                </div>
                <div class="work-service-card">
                    <div class="work-service-icon" data-aos="fade-up">
                        <i class="fas fa-theater-masks" data-aos="fade-up"></i>
                    </div>
                    <div class="work-service-content" data-aos="fade-up">
                        <h3>Live Performances</h3>
                        <p>Our theatrical productions and community events create immersive experiences that celebrate Ugandan cultural heritage.</p>
                        <a href="#" class="work-read-more">Learn More</a>
                    </div>
                </div>
                <div class="work-service-card">
                    <div class="work-service-icon" data-aos="fade-up">
                        <i class="fas fa-book-open" data-aos="fade-up"></i>
                    </div>
                    <div class="work-service-content" data-aos="fade-up">
                        <h3>Educational Content</h3>
                        <p>We develop culturally-rooted educational materials for schools and families that promote literacy and critical thinking.</p>
                        <a href="#" class="work-read-more" data-aos="fade-left">Learn More</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Projects Section -->
    <section class="work-projects">
        <div class="work-container">
            <div class="work-section-title" data-aos="fade-up">
                <h2>Featured Projects</h2>
                <p>Discover our captivating storytelling projects that bring African folklore and cultural heritage to life for young audiences.</p>
            </div>
            <div class="work-projects-grid">
                <div class="work-project-card" data-aos="fade-up">
                    <img src="https://mythlok.com/wp-content/uploads/2024/10/Kintu-and-Nambi_.jpg" alt="Kintu and Nambi" class="work-project-img">
                    <div class="work-project-overlay">
                        <h3>Kintu and Nambi</h3>
                        <p>A retelling of the legendary love story that marks the beginning of humanity in Buganda folklore.</p>
                        <a href="kintu-nambi.php" class="work-read-more">View Project</a>
                    </div>
                </div>
                <div class="work-project-card" data-aos="fade-up">
                    <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRQvZOERMBbNiw8Ej9NQyrSqsC4ipXEdtlHFpjsomfzwjiD8gkyktddCCAMbNMasZgGljE&usqp=CAU" alt="Gipiir and Labong" class="work-project-img">
                    <div class="work-project-overlay">
                        <h3>Gipiir and Labongo</h3>
                        <p>A powerful tale of brotherhood, conflict, and reconciliation from the Luo people.</p>
                        <a href="gipiir-labongo.php" class="work-read-more">View Project</a>
                    </div>
                </div>
                <div class="work-project-card" data-aos="fade-up">
                    <img src="https://i.pinimg.com/1200x/73/25/62/7325626f9b3e277a2ef0ad3ae57d3f68.jpg" alt="Cultural Shorts" class="work-project-img">
                    <div class="work-project-overlay">
                        <h3>Cultural Shorts & Folktales</h3>
                        <p>A collection of bite-sized animations and stories from different Ugandan communities.</p>
                        <a href="cultural-folktales.php" class="work-read-more">View Project</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Us Section -->
    <section class="work-why-us">
        <div class="work-container">
            <div class="work-section-title" data-aos="fade-up">
                <h2>Why Choose Ngazi Arts</h2>
                <p>Discover what makes our approach to cultural storytelling unique and impactful for young audiences.</p>
            </div>
            <div class="work-features-grid">
                <div class="work-feature-card" data-aos="fade-up">
                    <div class="work-feature-icon" data-aos="fade-up">
                        <i class="fas fa-seedling" data-aos="fade-up"></i>
                    </div>
                    <h3>Culturally Rooted</h3>
                    <p>Our content is deeply rooted in authentic African traditions, folklore, and values, providing children with a strong cultural foundation.</p>
                </div>
                <div class="work-feature-card" data-aos="fade-up">
                    <div class="work-feature-icon" v>
                        <i class="fas fa-child" data-aos="fade-up"></i>
                    </div>
                    <h3>Age-Appropriate</h3>
                    <p>We carefully tailor our stories and presentations to be engaging, educational, and suitable for different age groups.</p>
                </div>
                <div class="work-feature-card" data-aos="fade-up">
                    <div class="work-feature-icon" data-aos="fade-up">
                        <i class="fas fa-graduation-cap" data-aos="fade-up"></i>
                    </div>
                    <h3>Educational Value</h3>
                    <p>Each project incorporates moral lessons, critical thinking elements, and educational content that complements formal learning.</p>
                </div>
                <div class="work-feature-card" data-aos="fade-up">
                    <div class="work-feature-icon" data-aos="fade-up">
                        <i class="fas fa-paint-brush" data-aos="fade-up"></i>
                    </div>
                    <h3>Creative Excellence</h3>
                    <p>We combine traditional storytelling with modern creative techniques to produce visually stunning and engaging content.</p>
                </div>
                <div class="work-feature-card" data-aos="fade-up">
                    <div class="work-feature-icon" data-aos="fade-up">
                        <i class="fas fa-users" data-aos="fade-up"></i>
                    </div>
                    <h3>Community Focus</h3>
                    <p>Our work extends beyond media to community engagements, festivals, and partnerships with local educators.</p>
                </div>
                <div class="work-feature-card" data-aos="fade-up">
                    <div class="work-feature-icon" data-aos="fade-up">
                        <i class="fas fa-heart" data-aos="fade-up"></i>
                    </div>
                    <h3>Passion-Driven</h3>
                    <p>We are genuinely passionate about preserving cultural heritage and nurturing the next generation through storytelling.</p>
                </div>
            </div>
        </div>
    </section>

<?php include 'inc/footer.php'?>