<?php
$title = "Our Story - Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Learn about Ngazi Arts' journey, mission, and vision to create culturally-rooted educational content for African children.";
$keywords = "Ngazi Arts story, about Ngazi Arts, African children content, Ugandan animations, cultural education";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>

<?php include 'inc/menu.php'?>
<?php include 'inc/breadcrumb.php'?>

<!-- Our Story Hero Section -->
<section class="story-hero-section" data-aos="fade-up">
    <div class="story-hero-container">
        <div class="story-hero-content" data-aos="fade-up">
            <h2 class="home-section-title" data-aos="fade-up">Our Story</h2>
            <p class="story-hero-description" data-aos="fade-up">
                Ngazi Arts is a Uganda-based creative company dedicated to creating high-quality
children's and Young people's content that educates, entertains, and preserves culture.
Our name, "Ngazi" Swahili for "ladder" symbolizes our mission to elevate young minds
and connect them to the richness of African heritage and the world at large.
            </p>
            <p class="story-hero-subdescription" data-aos="fade-right">
                At Ngazi Arts, we believe that childhood is the foundation of lifelong learning and
identity. Through theatre,engaging animations, stories, games, and digital experiences,
we spark curiosity and instill values rooted in diverse cultural history. From ancient
folklore, legends to modern themes, we reimagine storytelling for today's generation.
            </p>
        </div>
    </div>
</section>

<!-- Three Column Sections -->
<section class="story-columns-section">
    <!-- Smarter Section -->
    <div class="story-column-block story-column-orange">
        <div class="story-column-container">
            <div class="story-column-image" data-aos="fade-right">
                <img src="https://i.pinimg.com/736x/17/c7/2b/17c72b1545d092aa4e32b56f0c5ce803.jpg" alt="Cultural Learning">
            </div>
            <div class="story-column-content">
                <h2 class="story-column-title" data-aos="fade-up">Smarter</h2>
                <p class="story-column-text" data-aos="fade-up">
                    We help children develop the full spectrum of life skills they need to thrive, like emotional well-being and healthy habits.
                </p>
                <p class="story-column-subtext" data-aos="fade-up">
                    Through culturally rich stories and engaging animations, we nurture young minds with educational content that connects children to their African heritage while building essential life skills and critical thinking abilities.
                </p>
            </div>
        </div>
    </div>

    <!-- Stronger Section -->
    <div class="story-column-block story-column-green">
        <div class="story-column-container story-column-reverse">
            <div class="story-column-image" data-aos="fade-left">
                <img src="https://i.pinimg.com/736x/f7/0a/8e/f70a8eaf1aeeb50bf8077d94cc438355.jpg" alt="Community Building">
            </div>
            <div class="story-column-content">
                <h2 class="story-column-title" data-aos="fade-up">Stronger</h2>
                <p class="story-column-text" data-aos="fade-up">
                    We help children develop the full spectrum of life skills they need to thrive, like emotional well-being and healthy habits.
                </p>
                <p class="story-column-subtext" data-aos="fade-up">
                    Our theatrical performances and community events strengthen bonds between generations, preserving cultural wisdom while building resilience and confidence in children across Uganda.
                </p>
            </div>
        </div>
    </div>

    <!-- Kinder Section -->
    <div class="story-column-block story-column-yellow">
        <div class="story-column-container">
            <div class="story-column-image" data-aos="fade-right">
                <img src="https://turkanawildlifesafaris.com/wp-content/uploads/2024/10/karamojongo-people.jpg">
            </div>
            <div class="story-column-content">
                <h2 class="story-column-title" data-aos="fade-up">Kinder</h2>
                <p class="story-column-text" data-aos="fade-up">
                    In our diverse and complex world, teaching children how to celebrate similarities and differences. That's how we empower the next generation to build a kinder world.
                </p>
                <p class="story-column-subtext" data-aos="fade-up">
                    By sharing folktales and legends from different Ugandan communities, we teach empathy, respect, and unity while celebrating the beautiful diversity of African cultures.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Our Initiatives Section -->
<section class="story-initiatives-section">
    <div class="story-initiatives-container">
        <h2 class="home-section-title" data-aos="fade-up">Our Initiatives</h2>
        <p class="story-initiatives-description" data-aos="fade-right">
            Here are just some initiatives that support our mission to help children grow smarter, stronger, and kinder.
        </p>
        
        <div class="story-initiatives-grid">
            <div class="story-initiative-card" data-aos="fade-up">
                <div class="story-initiative-image">
                    <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQnA3wZwNpZGLzQ8o1qJ7rlYWuRv1N9tq8LFA&s" alt="Kintu and Nambi Animation">
                </div>
                <div class="story-initiative-content">
                    <h3 class="story-initiative-title" data-aos="fade-up">Kintu & Nambi Series</h3>
                    <p class="story-initiative-text" data-aos="fade-up">Bringing the legendary Buganda love story to life through vibrant animations that teach children about origins, choices, and responsibility in age-appropriate ways.</p>
                </div>
            </div>

            <div class="story-initiative-card" data-aos="fade-up">
                <div class="story-initiative-image">
                    <img src="https://kitararcc.com/wp-content/uploads/2020/05/cultural-dance.jpg?w=1024" alt="Cultural Festivals">
                </div>
                <div class="story-initiative-content">
                    <h3 class="story-initiative-title" data-aos="fade-up">Cultural Festivals</h3>
                    <p class="story-initiative-text" data-aos="fade-up">Interactive live performances and community events that celebrate Uganda's diverse cultural heritage while promoting unity and understanding among different communities.</p>
                </div>
            </div>

            <div class="story-initiative-card" data-aos="fade-up">
                <div class="story-initiative-image">
                    <img src="https://unesco-uganda.ug/wp-content/uploads/2019/01/Uganda-International-Cultural-Tourism-Fair51-1.jpg" alt="Educational Resources">
                </div>
                <div class="story-initiative-content">
                    <h3 class="story-initiative-title" data-aos="fade-up">Educational Resources</h3>
                    <p class="story-initiative-text" data-aos="fade-up">Developing curriculum materials and digital tools for schools and families to integrate African cultural knowledge with modern educational standards.</p>
                </div>
            </div>

            <div class="story-initiative-card" data-aos="fade-up">
                <div class="story-initiative-image">
                    <img src="https://i.pinimg.com/736x/11/30/3f/11303f71a6dbc7d49882c7413302cb73.jpg" alt="Language Preservation">
                </div>
                <div class="story-initiative-content">
                    <h3 class="story-initiative-title" data-aos="fade-up">Language Preservation</h3>
                    <p class="story-initiative-text" data-aos="fade-up">Creating content in local Ugandan languages to preserve endangered dialects and help children maintain their linguistic heritage alongside global languages.</p>
                </div>
            </div>

            <div class="story-initiative-card" data-aos="fade-up">
                <div class="story-initiative-image">
                    <img src="https://i.pinimg.com/1200x/3e/84/e6/3e84e6536f2dddb49b4dc7b02bf7140f.jpg" alt="Community Theater">
                </div>
                <div class="story-initiative-content">
                    <h3 class="story-initiative-title" data-aos="fade-up">Community Theater</h3>
                    <p class="story-initiative-text" data-aos="fade-up">Mobile theater programs that bring folktales and moral lessons directly to schools and communities across Uganda, making cultural education accessible to all.</p>
                </div>
            </div>

            <div class="story-initiative-card" data-aos="fade-up">
                <div class="story-initiative-image">
                    <img src="https://i.pinimg.com/1200x/9c/02/1c/9c021c33e7c00ec4f2cb35b000ca7e2f.jpg" alt="Digital Storytelling">
                </div>
                <div class="story-initiative-content">
                    <h3 class="story-initiative-title" data-aos="fade-up">Digital Storytelling</h3>
                    <p class="story-initiative-text" data-aos="fade-up">YouTube series and short films featuring bite-sized cultural lessons, folktales, and educational content designed for the digital generation of African children.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include 'inc/footer.php'?>