<?php
$title = "Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Ngazi Arts creates beautiful animations, films, and live performances based on Ugandan folktales. Our content helps children discover their cultural heritage while promoting literacy, critical thinking, and pride.";
$keywords = "Ngazi Arts, African stories for kids, Ugandan animations, children's culture, learning through play, African identity, folktales for children, educational content Africa, Uganda creative company";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>
<?php include 'inc/breadcrumb.php'?>



    <!-- Story Section -->
    <section class="knn-section">
        <div class="knn-container">
            <h2 class="home-section-title" data-aos="fade-up">The Legend of Kintu and Nambi</h2>
            <div class="knn-story-container">
                <div class="knn-story-image" data-aos="fade-right">
                    <img src="https://mythlok.com/wp-content/uploads/2024/10/Kintu-and-Nambi_.jpg" alt="Kintu and Nambi story illustration">
                </div>
                <div class="knn-story-content" data-aos="fade-up">
                    <h3>A Timeless Ugandan Tale</h3>
                    <p>Kintu and Nambi is a beloved Ugandan folktale that tells the story of how the first man on Earth, Kintu, met and married Nambi, the daughter of the sky god Gulu. Their epic journey from different worlds to build a life together on earth presents powerful themes about love, promise-keeping, and the consequences of our choices.</p>
                    <p>This animated retelling brings the story to life with vibrant visuals, authentic cultural details, and engaging storytelling that captivates children while preserving Uganda's rich heritage.</p>
                    <button class="knn-btn" id="knnReadStoryBtn">Read the Full Story</button>
                </div>
            </div>
        </div>
    </section>

    <!-- Characters Section -->
    <section class="knn-section knn-characters">
        <div class="knn-container">
            <h4 class="home-section-title" data-aos="fade-up">Meet the Characters</h4>
            <div class="knn-character-grid">
                <div class="knn-character-card" data-aos="fade-right">
                    <div class="knn-character-img">
                        <img src="https://mythlok.com/wp-content/uploads/2024/01/Kintu_.jpg" alt="Kintu character">
                    </div>
                    <div class="knn-character-info" data-aos="fade-right">
                        <h3>Kintu</h3>
                        <p>The first man on Earth who lived a simple life with only his cow for company until he met Nambi.</p>
                    </div>
                </div>
                <div class="knn-character-card" data-aos="fade-right">
                    <div class="knn-character-img">
                        <img src="https://mythlok.com/wp-content/uploads/2025/05/Mythlok-Nambi.jpg" alt="Nambi character">
                    </div>
                    <div class="knn-character-info" data-aos="fade-right">
                        <h3>Nambi</h3>
                        <p>The daughter of the sky god Gulu who fell in love with Kintu and chose to live with him on Earth.</p>
                    </div>
                </div>
                <div class="knn-character-card" data-aos="fade-right">
                    <div class="knn-character-img">
                        <img src="https://mythlok.com/wp-content/uploads/2023/12/Kibuka_.jpg" alt="Gulu character">
                    </div>
                    <div class="knn-character-info" data-aos="fade-right">
                        <h3>Gulu</h3>
                        <p>The powerful sky god and father of Nambi who initially opposed her relationship with Kintu.</p>
                    </div>
                </div>
                <div class="knn-character-card" data-aos="fade-right">
                    <div class="knn-character-img">
                        <img src="https://gpjs3bucket.s3.amazonaws.com/wp-content/uploads/2017/07/26162538/GPJ-News-Uganda-NS-pits-of-Death-Photo-014_web_L-650x434c.jpg" alt="Walumbe character">
                    </div>
                    <div class="knn-character-info" data-aos="fade-right">
                        <h3>Walumbe</h3>
                        <p>Nambi's brother who represents death and followed her to Earth against their father's warning.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Cultural Significance -->
    <section class="knn-section">
        <div class="knn-container">
            <h2 class="home-section-title" data-aos="fade-up">Cultural Significance</h2>
            <div class="knn-cultural-content" data-aos="fade-up">
                <p>The story of Kintu and Nambi is more than just a folktale - it's a foundational narrative that explains the origins of humanity according to Buganda tradition. It offers valuable lessons about obedience, consequences, and the importance of keeping promises.</p>
                <p>Our animated adaptation preserves these cultural teachings while making them accessible and engaging for today's children through vibrant visuals and relatable storytelling.</p>
                
                <div class="knn-cultural-icons" data-aos="fade-right">
                    <div class="knn-cultural-icon" data-aos="fade-right">
                        <i>📚</i>
                        <h4>Cultural Preservation</h4>
                    </div>
                    <div class="knn-cultural-icon" data-aos="fade-right">
                        <i>💡</i>
                        <h4>Moral Education</h4>
                    </div>
                    <div class="knn-cultural-icon" data-aos="fade-right">
                        <i>🌍</i>
                        <h4>Identity Building</h4>
                    </div>
                    <div class="knn-cultural-icon" data-aos="fade-right">
                        <i>❤️</i>
                        <h4>Family Values</h4>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Gallery Section -->
    <section class="knn-section" style="background-color: var(--kpy-gray-light);">
        <div class="knn-container">
            <h2 class="home-section-title" data-aos="fade-up">Visual Development</h2>
            <div class="knn-gallery-grid">
                <div class="knn-gallery-item" data-aos="fade-right">
                    <img src="https://i.pinimg.com/736x/31/31/be/3131be367ccb6cdde9567e7ec512a345.jpg" alt="Artwork 1">
                    <div class="knn-gallery-overlay">
                        <h3>Character Design</h3>
                    </div>
                </div>
                <div class="knn-gallery-item" data-aos="fade-right">
                    <img src="https://i.pinimg.com/1200x/41/c2/03/41c2033f60e8b8a75b12d857aecdf804.jpg" alt="Artwork 2">
                    <div class="knn-gallery-overlay">
                        <h3>Environment Art</h3>
                    </div>
                </div>
                <div class="knn-gallery-item" data-aos="fade-right">
                    <img src="https://i.pinimg.com/1200x/24/a1/73/24a173c8d1df7b57015ca3516973f7c5.jpg" alt="Artwork 3">
                    <div class="knn-gallery-overlay">
                        <h3>Storyboard</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Story Modal -->
    <div id="knnStoryModal" class="knn-modal">
        <div class="knn-modal-content">
            <span class="knn-close">&times;</span>
            <div class="knn-modal-sidebar">
                <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcTfNNnKYtcl5UorkC1uU3JH1onicNwL8Kv1QQ&s" alt="Story scene 1">
                <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRCGoX6bDBf9tOKssMNxBhrhHX-s_vXVFUmGWiSxu_E3crnxl5vGHmIJ1UE8z6TkmTp7UY&usqp=CAU" alt="Story scene 2">
                <img src="https://i.ytimg.com/vi/O-jRtu5Fp7U/maxresdefault.jpg" alt="Story scene 3">
                <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRpSWF9JaUa0OR1aL1rYMWkUKZbWiy-Dj27Z_WgJXbm2up2Ft6fqjn7ouoSDj2GsP-6AsI&usqp=CAU" alt="Story scene 4">
            </div>
            <div class="knn-modal-main">
                <h2>The Complete Story of Kintu and Nambi</h2>
                <p>According to Buganda legend, Kintu was the first man on earth, living alone with his cow. He was a peaceful and simple man who took good care of his only companion.</p>
                
                <p>One day, Nambi, the daughter of Gulu (the king of the sky), came down to earth with her brothers. They were amazed to find Kintu and his cow. Nambi and Kintu immediately fell in love.</p>
                
                <p>Nambi took Kintu to meet her father in the sky. Gulu was not pleased that his daughter wanted to marry a mere mortal. He set impossible tasks for Kintu to prove his worthiness.</p>
                
                <p>First, Gulu asked Kintu to cut down a huge forest in one day. With help from the ants and other creatures, Kintu completed the task. Next, Gulu asked him to fetch water from a rock. Again, with help from the animals, Kintu succeeded.</p>
                
                <p>Finally, Gulu asked for a special gift that only he possessed. Through wisdom and cleverness, Kintu managed to retrieve this gift as well. Impressed by Kintu's perseverance and resourcefulness, Gulu reluctantly gave his blessing for the marriage.</p>
                
                <p>As they prepared to leave for earth, Gulu warned them not to return for anything, especially not to ask for anything from Walumbe (Death), Nambi's brother. But as they journeyed, Nambi realized she had forgotten the millet for her chicken. Despite Kintu's protests, she returned to fetch it.</p>
                
                <p>Unfortunately, Walumbe followed Nambi back to earth. This is how death came to the human world, according to Baganda mythology. Despite this tragedy, Kintu and Nambi had many children and became the ancestors of all people.</p>
                
                <p>The story teaches about the importance of obedience, the consequences of our choices, and the origin of death in human society. It remains one of the most important cultural stories in Ugandan folklore.</p>
            </div>
        </div>
    </div>

    <script>
        // Modal functionality
        const knnModal = document.getElementById("knnStoryModal");
        const knnBtn = document.getElementById("knnReadStoryBtn");
        const knnSpan = document.getElementsByClassName("knn-close")[0];
        
        knnBtn.onclick = function() {
            knnModal.style.display = "block";
            document.body.style.overflow = "hidden";
        }
        
        knnSpan.onclick = function() {
            knnModal.style.display = "none";
            document.body.style.overflow = "auto";
        }
        
        window.onclick = function(event) {
            if (event.target == knnModal) {
                knnModal.style.display = "none";
                document.body.style.overflow = "auto";
            }
        }
        
        // Gallery image click to show in main view
        const knnSidebarImages = document.querySelectorAll('.knn-modal-sidebar img');
        knnSidebarImages.forEach(img => {
            img.addEventListener('click', function() {
                const mainContent = document.querySelector('.knn-modal-main');
                mainContent.scrollTo(0, 0);
            });
        });
    </script>
<?php include 'inc/footer.php'?>