<?php
$title = "Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Ngazi Arts creates beautiful animations, films, and live performances based on Ugandan folktales. Our content helps children discover their cultural heritage while promoting literacy, critical thinking, and pride.";
$keywords = "Ngazi Arts, African stories for kids, Ugandan animations, children's culture, learning through play, African identity, folktales for children, educational content Africa, Uganda creative company";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>

<?php include 'inc/slider.php'?>
<?php include 'inc/menu.php'?>


<!-- About Section -->
<section id="home-about" class="home-section">
    <div class="home-container">
        <div class="home-about-container">
            <div class="home-about-text-content">
                <h2 class="home-about-main-title" data-aos="fade-up">We Make Your <span class="home-about-highlight">Stories</span> Better</h2>
                
                <div class="home-about-description" data-aos="fade-up">
                    
                    <p>At Ngazi Arts, we believe that <strong>childhood is the foundation</strong> of lifelong learning and identity. Through theatre, engaging animations, stories, games, and digital experiences, we spark curiosity and instill values rooted in diverse cultural history.</p>
                    
                    <p>From ancient folklore and legends to modern themes, we <strong>reimagine storytelling</strong> for today's generation.</p>
                </div>
            </div>
            
            <div class="home-about-image-section" data-aos="fade-left">
                <div class="home-about-image-slider">
                    <div class="home-about-slide active">
                        <img src="https://i.pinimg.com/736x/d9/50/40/d95040222acb7022585fea918b4a0b57.jpg" alt="Children engaging with cultural storytelling activities" class="home-about-slide-image">
                    </div>
                    <div class="home-about-slide">
                        <img src="https://i.pinimg.com/736x/e0/eb/9e/e0eb9e605ba5c19d0ead7cd0ee6e0175.jpg" alt="Traditional African storytelling session" class="home-about-slide-image">
                    </div>
                    <div class="home-about-slide">
                        <img src="https://i.pinimg.com/1200x/17/3c/2c/173c2c8a5c2473d851f85e8f99934780.jpg" alt="Children learning through cultural activities" class="home-about-slide-image">
                    </div>
                </div>
                
                <div class="home-about-sidebar">
                    <div class="home-about-nav-dots">
                        <div class="home-about-dot active" data-slide="0"></div>
                        <div class="home-about-dot" data-slide="1"></div>
                        <div class="home-about-dot" data-slide="2"></div>
                    </div>
                </div>
            </div>
        </div>
        
         <div class="home-about-features" data-aos="fade-up">
            <div class="home-about-feature-item">
                <div class="home-about-feature-icon"><i class="fas fa-theater-masks"></i></div>
                <h3 class="home-about-feature-title">Crafted Content</h3>
            </div>
            
            <div class="home-about-feature-item">
                <div class="home-about-feature-icon"><i class="fas fa-seedling"></i></div>
                <h3 class="home-about-feature-title">Cultural Heritage</h3>
            </div>
            
            <div class="home-about-feature-item">
                <div class="home-about-feature-icon"><i class="fas fa-lightbulb"></i></div>
                <h3 class="home-about-feature-title">Creative Storytelling</h3>
            </div>
            
            <div class="home-about-feature-item">
                <div class="home-about-feature-icon"><i class="fas fa-users"></i></div>
                <h3 class="home-about-feature-title">Community Focused</h3>
            </div>
        </div>
    </div>
</section>


<script>
document.addEventListener('DOMContentLoaded', function() {
    const slides = document.querySelectorAll('.home-about-slide');
    const dots = document.querySelectorAll('.home-about-dot');
    let currentSlide = 0;

    function showSlide(index) {
        slides.forEach(slide => slide.classList.remove('active'));
        dots.forEach(dot => dot.classList.remove('active'));
        
        slides[index].classList.add('active');
        dots[index].classList.add('active');
    }

    dots.forEach((dot, index) => {
        dot.addEventListener('click', () => {
            currentSlide = index;
            showSlide(currentSlide);
        });
    });

    // Auto-advance slides
    setInterval(() => {
        currentSlide = (currentSlide + 1) % slides.length;
        showSlide(currentSlide);
    }, 5000);
});
</script>

<!-- Folktales Section -->
<section id="home-folktales" class="home-folktales home-section" >
    <div class="home-container" data-aos="fade-up">
        <h2 class="home-section-title" data-aos="fade-up">Folktales</h2>
        <p class="home-section-subtitle">Reaching children and families around the world through the power of media</p>
        <div class="home-folktales-grid">
            <div class="home-folktale-card" data-aos="fade-in">
                <div class="home-folktale-image">
                    <img src="https://i.pinimg.com/736x/ab/7f/13/ab7f1314796437f59402d51d145d39c4.jpg" alt="The Hare and the Elephant">
                    <div class="home-folktale-overlay">
                        <div class="home-folktale-content">
                            <h3 class="home-folktale-title">The Hare and the Elephant</h3>
                            <p class="home-folktale-description">A clever Buganda tale about wit over strength.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="home-folktale-card">
                <div class="home-folktale-image">
                    <img src="https://mythlok.com/wp-content/uploads/2024/10/Kintu-and-Nambi_.jpg" alt="Kintu and Nambi">
                    <div class="home-folktale-overlay">
                        <div class="home-folktale-content">
                            <h3 class="home-folktale-title">Kintu and Nambi</h3>
                            <p class="home-folktale-description">The legendary origin story of the Baganda people.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="home-folktale-card">
                <div class="home-folktale-image">
                    <img src="https://i.pinimg.com/736x/6b/5d/b6/6b5db6dc384aa60a9fbc113bcf7564bc.jpg" alt="The Tortoise and the Birds">
                    <div class="home-folktale-overlay">
                        <div class="home-folktale-content">
                            <h3 class="home-folktale-title">The Tortoise and the Birds</h3>
                            <p class="home-folktale-description">An Acholi wisdom tale about patience and humility.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="home-folktales-cta">
            <a href="cultural-folktales.php" class="home-folktales-btn" data-aos="fade-left">See More Folktales </a>
        </div>
    </div>
</section>


<!-- Why Choose Us Section -->
<section id="home-why" class="home-why home-section">
    <div class="home-container">
        <div class="home-why-grid">
            <div class="home-why-content">
                <h2 class="home-section-title" data-aos="fade-up">Why Choose Ngazi Arts</h2>
                <p class="home-why-lead" data-aos="fade-up">In a world filled with global content, African children rarely see themselves reflected in the stories they consume. We exist to change that narrative.</p>
                
                <div class="home-why-features" data-aos="fade-up">
                    <div class="home-why-feature" data-aos="fade-up">
                        <div class="home-why-icon" data-aos="fade-left">👁️</div>
                        <div class="home-why-text" data-aos="fade-up">
                            <h3>Cultural Representation</h3>
                            <p>We ensure African children see their stories, heritage, and identities reflected in the media they consume.</p>
                        </div>
                    </div>
                    
                    <div class="home-why-feature" data-aos="fade-up">
                        <div class="home-why-icon" data-aos="fade-left">❤️</div>
                        <div class="home-why-text" data-aos="fade-up">
                            <h3>Identity Building</h3>
                            <p>We help children build pride, empathy, and confidence through culturally relevant storytelling.</p>
                        </div>
                    </div>
                    
                    <div class="home-why-feature" data-aos="fade-up">
                        <div class="home-why-icon" data-aos="fade-left">🌱</div>
                        <div class="home-why-text" data-aos="fade-up">
                            <h3>Educational Value</h3>
                            <p>Our content promotes literacy, critical thinking, and preserves endangered stories and languages.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="home-why-image" data-aos="fade-left">
                <img src="https://i.pinimg.com/736x/60/2a/13/602a132fca459fcbee7eb4918b4216c8.jpg">
                <div class="home-why-stats">
                    <div class="home-stat-box">
                        <div class="home-stat-number" data-aos="fade-up">10,000+</div>
                        <div class="home-stat-text" data-aos="fade-up">Children Reached</div>
                    </div>
                    <div class="home-stat-box">
                        <div class="home-stat-number" data-aos="fade-up">50+</div>
                        <div class="home-stat-text" data-aos="fade-up">Stories Preserved</div>
                    </div>
                    <div class="home-stat-box">
                        <div class="home-stat-number" data-aos="fade-up">25+</div>
                        <div class="home-stat-text" data-aos="fade-up">Communities Engaged</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="home-testimonials home-section">
    <div class="home-container">
        <h2 class="home-section-title" data-aos="fade-up">What People Say</h2>
        <div class="home-testimonial-grid">
            <div class="home-testimonial-card" data-aos="fade-up">
                <div class="home-testimonial-text" data-aos="fade-up">"My children now ask about their heritage after watching Ngazi stories. They're learning while having fun!"</div>
                <div class="home-testimonial-author" data-aos="fade-up">- Nakato, Parent</div>
            </div>
            <div class="home-testimonial-card" data-aos="fade-up">
                <div class="home-testimonial-text" data-aos="fade-up">"These animations have become an essential part of our cultural education curriculum. The children love them!"</div>
                <div class="home-testimonial-author" data-aos="fade-up">- Mr. Ochieng, Teacher</div>
            </div>
            <div class="home-testimonial-card" data-aos="fade-up">
                <div class="home-testimonial-text" data-aos="fade-up">"Finally, content that reflects our stories and values. Ngazi Arts is filling a crucial gap in African children's media."</div>
                <div class="home-testimonial-author" data-aos="fade-up">- Dr. Amina, Cultural Expert</div>
            </div>
        </div>
    </div>
</section>

<!-- Hero Section -->
<section class="home-hero-section" data-aos="fade-up">
    <div class="home-hero-content" data-aos="fade-up">
        <div class="home-hero-badge" data-aos="fade-up">
            <div class="home-hero-badge-icon" data-aos="fade-left">📚</div>
            Cultural Storytelling
        </div>
        
        <h3 class="home-hero-title" data-aos="fade-up">African Folktales</h3>
        
        <p class="home-hero-subtitle" data-aos="fade-up">
            We have decades of experience preserving and sharing traditional stories that teach wisdom, values, and cultural heritage to children and families across Uganda and beyond.
        </p>
        
        <a href="#folktales" class="home-hero-cta">Learn More</a>
    </div>
    
    <div class="home-hero-visual" data-aos="fade-left">
    </div>
</section>

<?php include 'inc/footer.php'?>)    