<!-- BREADCRUMB SLIDER SECTION -->
<div class="vertical-slider">
  <!-- Menu positioned at the top of the slider -->
  <div class="menu-container">
    <nav>
      <div class="menu-left">
        <a href="index.php" class="menu-item">Home</a>
        <div class="dropdown">
          <a href="about-us.php" class="menu-item">About</a>
          <div class="dropdown-content">
            <a href="our-story.php">Our Story</a>
            <a href="our-work.php">Our Work</a>
            <a href="team.php">Team</a>
          </div>
        </div>
        <div class="dropdown">
          <a href="#" class="menu-item">Projects</a>
          <div class="dropdown-content">
            <a href="kintu-nambi.php">Kintu & Nambi</a>
            <a href="gipiir-labongo.php">Gipiir & Labongo</a>
            <a href="cultural-folktales.php">Cultural Shorts & Folktales Series</a>
          </div>
        </div>
      </div>
      
      <div class="logo-container">
        <div class="logo">
          <img src="../assets/images/ngazi-logo.jpg" alt="Ngazi Arts Logo">
        </div>
        <div class="logo-circle"></div>
        <div class="logo-circle"></div>
        <div class="logo-circle"></div>
      </div>
      
      <div class="menu-right">
        <a href="impact.php" class="menu-item">Impact</a>
        <a href="collaborate.php" class="menu-item">Collaborate</a>
        <a href="contact.php" class="menu-item">Contact</a>
        <div class="search-icon">
          <i class="fas fa-search"></i>
        </div>
      </div>
      
      <button class="mobile-toggle">
        <i class="fas fa-bars"></i>
      </button>
    </nav>
  </div>
  
  <!-- Slide 1 with content -->
  <div class="slide">
    <img src="https://i.pinimg.com/1200x/90/ed/bb/90edbb70119a260aab9bac3c6e884d35.jpg" alt="Our Work">
    <div class="breadcrumb-content">
      <h3 class="breadcrumb-title">Raising the Next Generation Through Creativity</h3>
      
    </div>
  </div>
  
  <!-- Slide 2 with content -->
  <div class="slide">
    <img src="https://i.pinimg.com/1200x/99/72/a1/9972a1a2885edb3354d41b277f1282d6.jpg" alt="Thriving Nature">
    <div class="breadcrumb-content">
      <h3 class="breadcrumb-title">Raising the Next Generation Through Creativity</h3>
      
    </div>
  </div>
  
  <!-- Slide 3 with content -->
  <div class="slide">
    <img src="https://i.pinimg.com/736x/e9/9a/0c/e99a0c2f34acaf30066106dcb32b95de.jpg" alt="Sustainable Communities">
    <div class="breadcrumb-content">
      <h3 class="breadcrumb-title">Raising the Next Generation Through Creativity</h3>
      
    </div>
  </div>
</div>

<style>
.vertical-slider { position: relative; width: 100%; height: 400px; overflow: hidden; z-index: 0; }
.vertical-slider .slide { position: absolute; width: 100%; height: 600px; opacity: 0; animation: diagonalSlide 15s infinite; clip-path: polygon(0 0, 0 0, 0 100%, 0 100%); }
.vertical-slider .slide:nth-child(1) { animation-delay: 0s; }
.vertical-slider .slide:nth-child(2) { animation-delay: 5s; }
.vertical-slider .slide:nth-child(3) { animation-delay: 10s; }
.vertical-slider img { width: 100%; height: 600px; object-fit: cover; }
@keyframes diagonalSlide { 0% { opacity: 1; clip-path: polygon(0 0, 0 0, 0 100%, 0 100%); transform: scale(1.1) rotate(-2deg); } 15% { opacity: 1; clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%); transform: scale(1) rotate(0deg); } 70% { opacity: 1; clip-path: polygon(0 0, 100% 0, 100% 100%, 0 100%); transform: scale(1) rotate(0deg); } 85% { opacity: 1; clip-path: polygon(100% 0, 100% 0, 100% 100%, 100% 100%); transform: scale(1.1) rotate(2deg); } 100% { opacity: 0; clip-path: polygon(100% 0, 100% 0, 100% 100%, 100% 100%); } }

.menu-container { width: 100%; max-width: 1200px; margin: 0 auto; position: absolute; top: 20px; left: 50%; transform: translateX(-50%); z-index: 10; }
nav { background: rgba(255, 248, 220, 0.95); backdrop-filter: blur(10px); border-radius: 12px; box-shadow: 0 10px 30px rgba(85, 107, 47, 0.15); padding: 1rem 2rem; display: flex; justify-content: space-between; align-items: center; position: relative; border: 2px solid rgba(210, 105, 30, 0.1); }

.breadcrumb-content { position: absolute; bottom: 60px; left: 50%; transform: translateX(-50%); width: 100%; max-width: 800px; text-align: center; z-index: 5; padding: 0 20px; animation: breadcrumbFade 15s infinite; opacity: 0; }
.slide:nth-child(1) .breadcrumb-content { animation-delay: 0s; }
.slide:nth-child(2) .breadcrumb-content { animation-delay: 5s; }
.slide:nth-child(3) .breadcrumb-content { animation-delay: 10s; }
.breadcrumb-title { font-family: var(--kpy-font); font-size: clamp(1.5rem, 6vw, 3rem); font-weight: 700; margin-bottom: 12rem; letter-spacing: -0.02em; color: var(--kpy-white); text-shadow: 3px 3px 10px rgba(0,0,0,0.9); }

@keyframes breadcrumbFade { 0% { opacity: 0; transform: translateX(-50%) translateY(10px); } 15% { opacity: 1; transform: translateX(-50%) translateY(0); } 70% { opacity: 1; transform: translateX(-50%) translateY(0); } 85% { opacity: 0; transform: translateX(-50%) translateY(-10px); } 100% { opacity: 0; transform: translateX(-50%) translateY(-10px); } }

@media (max-width: 768px) { .breadcrumb-content { bottom: 40px; padding-top: 80px; } .breadcrumb-title { font-size: 1.5rem; } }
</style>