<?php
$title = "Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Ngazi Arts creates beautiful animations, films, and live performances based on Ugandan folktales. Our content helps children discover their cultural heritage while promoting literacy, critical thinking, and pride.";
$keywords = "Ngazi Arts, African stories for kids, Ugandan animations, children's culture, learning through play, African identity, folktales for children, educational content Africa, Uganda creative company";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>
<?php include 'inc/breadcrumb.php'?>


    <!-- Story Section -->
    <section class="gnl-section">
        <div class="gnl-container">
            <h2 class="home-section-title" data-aos="fade-up">The Legend of Gipiir and Labongo</h2>
            <div class="gnl-story-container">
                <div class="gnl-story-image" data-aos="fade-right">
                    <img src="https://cdnb.artstation.com/p/assets/images/images/047/315/165/large/de-art-of-spartan-labelled-gipir-00000.jpg?1647301204" alt="Gipiir and Labongo story illustration">
                </div>
                <div class="gnl-story-content">
                    <h3>The Story of the Spear and the Bead</h3>
                    <p>Gipiir and Labongo is a powerful tale of brotherhood, conflict, and reconciliation from the Luo people of Northern Uganda. This legendary story explains the origins of the separation between the Acholi and Alur peoples and teaches important lessons about forgiveness, consequences, and the importance of family bonds.</p>
                    <p>Through vibrant animation and engaging storytelling, we bring this ancient tale to life for a new generation of children, helping them understand Ugandan cultural heritage while learning valuable moral lessons.</p>
                    <button class="gnl-btn" id="gnlReadStoryBtn">Read the Full Story</button>
                </div>
            </div>
        </div>
    </section>

    <!-- Characters Section -->
    <section class="gnl-section gnl-characters">
        <div class="gnl-container">
            <h2 class="home-section-title">Meet the Characters</h2>
            <div class="gnl-character-grid">
                <div class="gnl-character-card" data-aos="fade-right">
                    <div class="gnl-character-img">
                        <img src="https://i.ytimg.com/vi/ZGGzVEHwCak/maxresdefault.jpg?sqp=-oaymwEmCIAKENAF8quKqQMa8AEB-AH-CYAC0AWKAgwIABABGGUgYyhLMA8=&rs=AOn4CLArdyzckBSoZcP2Pz_6VKhfUV1xcQ" alt="Labongo character">
                    </div>
                    <div class="gnl-character-info" data-aos="fade-right">
                        <h3>Labongo</h3>
                        <p>The elder brother who inherited the royal spear and became leader of the clan. He was authoritative but sometimes let emotions cloud his judgment.</p>
                    </div>
                </div>
                <div class="gnl-character-card" data-aos="fade-right">
                    <div class="gnl-character-img">
                        <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSYYaLVbkenfgH-eEMvAKob--pF0_4eh0BOQby0JhscDDwnryoW_LfC_CdREGxHj8SNr5E&usqp=CAU" alt="Gipiir character">
                    </div>
                    <div class="gnl-character-info" data-aos="fade-right">
                        <h3>Gipiir</h3>
                        <p>The younger brother who was given royal beads. His journey to recover the lost spear became legendary, teaching lessons about perseverance and forgiveness.</p>
                    </div>
                </div>
                <div class="gnl-character-card" data-aos="fade-right">
                    <div class="gnl-character-img">
                        <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSycQIgjEhjSHA0W6CRgEywQ4pjCC-oTk1wqA&s" alt="The Father character">
                    </div>
                    <div class="gnl-character-info" data-aos="fade-right">
                        <h3>The Father</h3>
                        <p>The clan leader who on his deathbed passed the royal spear to Labongo and beads to Gipiir, setting the stage for the brothers' story.</p>
                    </div>
                </div>
                <div class="gnl-character-card" data-aos="fade-right">
                    <div class="gnl-character-img">
                        <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcQVUvqoyj1trrjYmQi90k1U2Fu67BXHAUEVwQ&s" alt="Medicine Woman character">
                    </div>
                    <div class="gnl-character-info" data-aos="fade-right">
                        <h3>The Medicine Woman</h3>
                        <p>A kind old woman who saved Gipiir in the forest and helped him recover the spear, gifting him special beads that would later become significant.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Cultural Significance -->
    <section class="gnl-section">
        <div class="gnl-container">
            <h2 class="home-section-title" data-aos="fade-up">Cultural Significance</h2>
            <div class="gnl-cultural-content" data-aos="fade-up">
                <p>The story of Gipiir and Labongo is more than just a folktale - it's a foundational narrative that explains the origins of the separation between the Acholi and Alur peoples in Northern Uganda. It offers valuable lessons about brotherhood, conflict resolution, and the consequences of our actions.</p>
                <p>This story remains culturally significant today, with the historical site at Wang-Lei in Pakwach serving as a pilgrimage location where rituals are still performed to honor the memory of the brothers and promote unity among their descendants.</p>
                
                <div class="gnl-cultural-icons" data-aos="fade-right">
                    <div class="gnl-cultural-icon" data-aos="fade-right">
                        <i>👑</i>
                        <h4>Leadership</h4>
                    </div>
                    <div class="gnl-cultural-icon" data-aos="fade-right">
                        <i>⚖️</i>
                        <h4>Justice</h4>
                    </div>
                    <div class="gnl-cultural-icon" data-aos="fade-right">
                        <i>🤝</i>
                        <h4>Reconciliation</h4>
                    </div>
                    <div class="gnl-cultural-icon" data-aos="fade-right">
                        <i>🌍</i>
                        <h4>Origin Story</h4>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Gallery Section -->
    <section class="gnl-section" style="background-color: var(--kpy-gray-light);">
        <div class="gnl-container">
            <h2 class="home-section-title" data-aos="fade-up">Visual Development</h2>
            <div class="gnl-gallery-grid">
                <div class="gnl-gallery-item" data-aos="fade-right">
                    <img src="https://i.pinimg.com/736x/31/31/be/3131be367ccb6cdde9567e7ec512a345.jpg" alt="Artwork 1">
                    <div class="gnl-gallery-overlay">
                        <h3>Character Design</h3>
                    </div>
                </div>
                <div class="gnl-gallery-item" data-aos="fade-right">
                    <img src="https://i.pinimg.com/1200x/41/c2/03/41c2033f60e8b8a75b12d857aecdf804.jpg" alt="Artwork 2">
                    <div class="gnl-gallery-overlay">
                        <h3>Environment Art</h3>
                    </div>
                </div>
                <div class="gnl-gallery-item" data-aos="fade-right">
                    <img src="https://i.pinimg.com/1200x/24/a1/73/24a173c8d1df7b57015ca3516973f7c5.jpg" alt="Artwork 3">
                    <div class="gnl-gallery-overlay">
                        <h3>Storyboard</h3>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Story Modal -->
    <div id="gnlStoryModal" class="gnl-modal">
        <div class="gnl-modal-content">
            <span class="gnl-close">&times;</span>
            <div class="gnl-modal-sidebar">
                <img src="https://i.ytimg.com/vi/Wbfrg7yjSTo/maxresdefault.jpg?sqp=-oaymwEmCIAKENAF8quKqQMa8AEB-AH-CYAC0AWKAgwIABABGGUgZShRMA8=&rs=AOn4CLATTkDcNsSdIQ1aMySavGWU9_PKAA" alt="Story scene 1" data-story-part="1">
                <img src="https://i.ytimg.com/vi/ZGGzVEHwCak/mqdefault.jpg" alt="Story scene 2" data-story-part="2">
                <img src="https://i.ytimg.com/vi/LAhC63CieBU/hq720.jpg?sqp=-oaymwEhCK4FEIIDSFryq4qpAxMIARUAAAAAGAElAADIQj0AgKJD&rs=AOn4CLDY-iQPXamK8HePU_sNH2VBoi9r9w" alt="Story scene 3" data-story-part="3">
                <img src="https://i.ytimg.com/vi/AJZhVU_I99E/sddefault.jpg?sqp=-oaymwEmCIAFEOAD8quKqQMa8AEB-AHeA4AC4AOKAgwIABABGGUgSyg_MA8=&rs=AOn4CLDmm0Y1lp8FC4D5qvjoSydyCdU4DA" alt="Story scene 4" data-story-part="4">
            </div>
            <div class="gnl-modal-main">
                <h2>The Complete Story of Gipiir and Labongo</h2>
                <div id="gnl-story-part-1">
                    <h3>The Brothers' Bond</h3>
                    <p>Gipiir and Labongo were the sons of a great chief named Okonde who lived in a village near the Nile River. They were inseparable, hunting and working together, and their bond was admired by everyone. Gipiir, the older brother, was known for his wisdom and calmness, while Labongo was celebrated for his strength and bravery.</p>
                    <p>To Labongo, his firstborn, he gave the royal spear - a symbol of leadership and authority that had been passed down through generations. To Gipiir, his younger son, he gave royal beads, representing grace and secondary leadership.</p>
                    <p>Soon after, the old man passed away, and Labongo took over as leader of the clan. The brothers grew into men, took wives, and had children, living in peace for many years in their fertile land.</p>
                </div>
                
                <div id="gnl-story-part-2" style="display: none;">
                    <h3>The Lost Spear</h3>
                    <p>One afternoon while Labongo was hunting, a wild elephant strayed into their maize garden. The women and children ran in terror as the massive animal destroyed their precious crops. Gipiir, hearing the commotion, rushed to help.</p>
                    <p>Without thinking, he grabbed the nearest spear - which happened to be Labongo's royal spear - and threw it at the elephant. The injured animal fled into the forest with the spear still embedded in its side.</p>
                    <p>When Labongo returned and discovered his precious spear was missing, he was furious. Despite Gipiir's explanations and apologies, Labongo demanded that his brother retrieve the spear, no matter the cost or danger involved.</p>
                </div>
                
                <div id="gnl-story-part-3" style="display: none;">
                    <h3>The Journey and Return</h3>
                    <p>Gipiir had no choice but to venture into the dangerous forest alone. For weeks he searched, facing hunger, disease, and wild animals. Just when he was near death, an old medicine woman found and nursed him back to health.</p>
                    <p>With her help, Gipiir eventually found the elephant's skeleton with the royal spear still intact. The medicine woman gifted him special beads before he returned home after years of absence.</p>
                    <p>When Gipiir finally returned with the spear, Labongo was overjoyed to see his brother alive and embraced him. The clan celebrated for days, but tension remained between the brothers.</p>
                </div>
                
                <div id="gnl-story-part-4" style="display: none;">
                    <h3>The Bead and Separation</h3>
                    <p>Years later, tragedy struck again when Labongo's young daughter accidentally swallowed one of Gipiir's special beads. Remembering his own suffering, Gipiir demanded the bead back immediately.</p>
                    <p>Despite Labongo's pleas, Gipiir insisted on retrieving his bead, forcing Labongo to make an unimaginable choice. This tragic event created an irreparable rift between the brothers.</p>
                    <p>They decided to part ways, burying an axe at a place called Wang-Lei near Pakwach. Labongo and his followers moved east, becoming the Acholi people, while Gipiir and his followers moved west, becoming the Alur people.</p>
                    <p>To this day, the site at Wang-Lei remains significant, with rituals performed annually to honor the memory of the brothers and promote unity among their descendants.</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Modal functionality
        const gnlModal = document.getElementById("gnlStoryModal");
        const gnlBtn = document.getElementById("gnlReadStoryBtn");
        const gnlSpan = document.getElementsByClassName("gnl-close")[0];
        
        gnlBtn.onclick = function() {
            gnlModal.style.display = "block";
            document.body.style.overflow = "hidden";
        }
        
        gnlSpan.onclick = function() {
            gnlModal.style.display = "none";
            document.body.style.overflow = "auto";
        }
        
        window.onclick = function(event) {
            if (event.target == gnlModal) {
                gnlModal.style.display = "none";
                document.body.style.overflow = "auto";
            }
        }
        
        // Story navigation through sidebar images
        const gnlSidebarImages = document.querySelectorAll('.gnl-modal-sidebar img');
        const gnlStoryParts = document.querySelectorAll('.gnl-modal-main > div');
        
        gnlSidebarImages.forEach((img, index) => {
            img.addEventListener('click', function() {
                // Hide all story parts
                gnlStoryParts.forEach(part => {
                    part.style.display = 'none';
                });
                
                // Show the selected story part
                if (gnlStoryParts[index]) {
                    gnlStoryParts[index].style.display = 'block';
                }
                
                // Scroll to top of story
                document.querySelector('.gnl-modal-main').scrollTo(0, 0);
            });
        });
    </script>
<?php include 'inc/footer.php'?>