<?php
$title = "Ngazi Arts: African Stories & Educational Content for Children";
$tagline = "The Ladder to Imagination, Identity, and Learning";
$description = "Ngazi Arts creates beautiful animations, films, and live performances based on Ugandan folktales. Our content helps children discover their cultural heritage while promoting literacy, critical thinking, and pride.";
$keywords = "Ngazi Arts, African stories for kids, Ugandan animations, children's culture, learning through play, African identity, folktales for children, educational content Africa, Uganda creative company";
$featured_image = 'https://www.ngaziarts.com/path/to/your/featured-image.jpg';
include "inc/header.php";
?>
<?php include 'inc/menu.php'?>
<?php include 'inc/breadcrumb.php'?>


<div class="collab-container">
    
    <!-- Introduction Section -->
    <section class="collab-intro">
        <h2 class="home-section-title" data-aos="fade-right">Ways to Collaborate</h2>
        <p class="collab-intro-text" data-aos="fade-up">We collaborate with educators, parents, organizations, and creatives who share our passion for storytelling and culture. Whether you're looking for custom content or want to support our mission, let's connect.</p>
    </section>
    
    <!-- Collaboration Options Grid -->
    <div class="collab-grid">
        <div class="collab-card" data-aos="fade-up">
            <div class="collab-card-header" data-aos="fade-up">
                <div class="collab-card-icon" data-aos="fade-up">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/></svg>
                    </div>
                <h3 class="collab-card-title" data-aos="fade-right">Educators</h3>
            </div>
            <div class="collab-card-body">
                <p class="collab-card-text" data-aos="fade-up">Bring African storytelling into your classroom with our educational resources:</p>
                <ul class="collab-card-list">
                    <li class="collab-card-list-item" data-aos="fade-up">Curriculum-aligned content</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Interactive learning materials</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Teacher training workshops</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Cultural immersion programs</li>
                </ul>
            </div>
        </div>
        
        <div class="collab-card">
            <div class="collab-card-header" data-aos="fade-up">
                <div class="collab-card-icon" data-aos="fade-up">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M16.5 12c1.38 0 2.49-1.12 2.49-2.5S17.88 7 16.5 7 14 8.12 14 9.5s1.12 2.5 2.5 2.5zM9 11c1.66 0 2.99-1.34 2.99-3S10.66 5 9 5 6 6.34 6 8s1.34 3 3 3zm7.5 3c-1.83 0-5.5.92-5.5 2.75V19h11v-2.25c0-1.83-3.67-2.75-5.5-2.75zM9 13c-2.33 0-7 1.17-7 3.5V19h7v-2.25c0-.85.33-2.34 2.37-3.47C10.5 13.1 9.66 13 9 13z"/></svg>
                </div>
                <h3 class="collab-card-title" data-aos="fade-right">Parents</h3>
            </div>
            <div class="collab-card-body">
                <p class="collab-card-text" data-aos="fade-up">Connect your children with their heritage through our resources:</p>
                <ul class="collab-card-list">
                    <li class="collab-card-list-item" data-aos="fade-up">Family storytelling kits</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Cultural activity guides</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Parent-child workshops</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Home learning materials</li>
                </ul>
            </div>
        </div>
        
        <div class="collab-card">
            <div class="collab-card-header" data-aos="fade-up">
                <div class="collab-card-icon" data-aos="fade-up">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 17h-2v-2h2v2zm2.07-7.75l-.9.92C13.45 12.9 13 13.5 13 15h-2v-.5c0-1.1.45-2.1 1.17-2.83l1.24-1.26c.37-.36.59-.86.59-1.41 0-1.1-.9-2-2-2s-2 .9-2 2H8c0-2.21 1.79-4 4-4s4 1.79 4 4c0 .88-.36 1.68-.93 2.25z"/></svg>
                </div>
                <h3 class="collab-card-title" data-aos="fade-right">Organizations</h3>
            </div>
            <div class="collab-card-body">
                <p class="collab-card-text" data-aos="fade-up">Partner with us to amplify African storytelling:</p>
                <ul class="collab-card-list">
                    <li class="collab-card-list-item" data-aos="fade-up">Corporate sponsorship opportunities</li>
                    <li class="collab-card-list-item" data-aos="fade-up">CSR initiatives</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Custom content development</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Event partnerships</li>
                </ul>
            </div>
        </div>
        
        <div class="collab-card">
            <div class="collab-card-header" data-aos="fade-up">
                <div class="collab-card-icon" data-aos="fade-up">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-5.5-2.5l7.51-3.49L17.5 6.5 9.99 9.99 6.5 17.5zm5.5-6.6c.61 0 1.1.49 1.1 1.1s-.49 1.1-1.1 1.1-1.1-.49-1.1-1.1.49-1.1 1.1-1.1z"/></svg>
                </div>
                <h3 class="collab-card-title" data-aos="fade-right">Creatives</h3>
            </div>
            <div class="collab-card-body" data-aos="fade-up">
                <p class="collab-card-text" data-aos="fade-up">Join our creative community and contribute your talents:</p>
                <ul class="collab-card-list">
                    <li class="collab-card-list-item" data-aos="fade-up">Animation and illustration projects</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Story development collaborations</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Voice acting opportunities</li>
                    <li class="collab-card-list-item" data-aos="fade-up">Cultural consultancy roles</li>
                </ul>
            </div>
        </div>
    </div>
    
 
    
    <section class="collab-section">
        <h2 class="home-section-title" data-aos="fade-right">Partnership Opportunities</h2>
        <div class="collab-card-container">
            <div class="collab-card" data-aos="fade-up">
                <div class="collab-card-header" data-aos="fade-up">
                    <h3 class="collab-card-title" data-aos="fade-up">Artists & Creatives</h3>
                </div>
                <div class="collab-card-body" data-aos="fade-up">
                    <p class="collab-card-text" data-aos="fade-up">We're always looking to collaborate with talented artists across various mediums:</p>
                    <ul class="collab-card-list">
                        <li class="collab-card-list-item" data-aos="fade-up">Exhibition opportunities</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Joint projects and installations</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Skill-sharing workshops</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Residency programs</li>
                    </ul>
                    <p class="collab-card-text" data-aos="fade-up">Let's create something extraordinary together.</p>
                </div>
            </div>
            
            <div class="collab-card">
                <div class="collab-card-header" data-aos="fade-up">
                    <h3 class="collab-card-title">Galleries & Institutions</h3>
                </div>
                <div class="collab-card-body" data-aos="fade-up">
                    <p class="collab-card-text" data-aos="fade-up">Partner with us for exhibitions and cultural programs:</p>
                    <ul class="collab-card-list">
                        <li class="collab-card-list-item" data-aos="fade-up">Curatorial collaborations</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Traveling exhibitions</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Educational programs</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Cultural exchanges</li>
                    </ul>
                    <p class="collab-card-text" data-aos="fade-up">Expand your reach with our diverse artist network.</p>
                </div>
            </div>
            
            <div class="collab-card">
                <div class="collab-card-header" data-aos="fade-up">
                    <h3 class="collab-card-title" data-aos="fade-up">Businesses & Organizations</h3>
                </div>
                <div class="collab-card-body" data-aos="fade-up">
                    <p class="collab-card-text" data-aos="fade-up">Enhance your space and support local art:</p>
                    <ul class="collab-card-list">
                        <li class="collab-card-list-item" data-aos="fade-up">Art acquisition programs</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Custom commissions</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Corporate collections</li>
                        <li class="collab-card-list-item" data-aos="fade-up">Event partnerships</li>
                    </ul>
                    <p class="collab-card-text" data-aos="fade-up">Bring art into your workplace and community.</p>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Why Collaborate With Us Section -->
    <section class="collab-why">
        <div class="collab-why-grid">
            <div class="collab-why-content" data-aos="fade-up">
                <h2 class="home-section-title" data-aos="fade-up">Why Collaborate With Us</h2>
                <p class="collab-why-lead">In a world filled with global content, African children rarely see themselves reflected in the stories they consume. We exist to change that narrative.</p>
                
                <div class="collab-why-features" data-aos="fade-up">
                    <div class="collab-why-feature">
                        <div class="collab-why-icon" data-aos="fade-up">👁️</div>
                        <div class="collab-why-text" data-aos="fade-up">
                            <h3>Cultural Representation</h3>
                            <p>We ensure African children see their stories, heritage, and identities reflected in the media they consume.</p>
                        </div>
                    </div>
                    
                    <div class="collab-why-feature" data-aos="fade-up">
                        <div class="collab-why-icon" data-aos="fade-up">❤️</div>
                        <div class="collab-why-text" data-aos="fade-up">
                            <h3>Identity Building</h3>
                            <p>We help children build pride, empathy, and confidence through culturally relevant storytelling.</p>
                        </div>
                    </div>
                    
                    <div class="collab-why-feature" data-aos="fade-up">
                        <div class="collab-why-icon" data-aos="fade-up">🌱</div>
                        <div class="collab-why-text" data-aos="fade-up">
                            <h3>Educational Value</h3>
                            <p>Our content promotes literacy, critical thinking, and preserves endangered stories and languages.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="collab-why-image" data-aos="fade-left">
                <img src="https://i.pinimg.com/736x/15/e6/c5/15e6c53d58d82566cc16a0f55c22590d.jpg" alt="Children engaging with African cultural content">
                <div class="collab-why-stats">
                    <div class="collab-stat-box">
                        <div class="collab-stat-number data-aos="fade-up"">10,000+</div>
                        <div class="collab-stat-text" data-aos="fade-up">Children Reached</div>
                    </div>
                    <div class="collab-stat-box">
                        <div class="collab-stat-number" data-aos="fade-up">50+</div>
                        <div class="collab-stat-text" data-aos="fade-up">Stories Preserved</div>
                    </div>
                    <div class="collab-stat-box">
                        <div class="collab-stat-number" data-aos="fade-up">25+</div>
                        <div class="collab-stat-text" data-aos="fade-up">Communities Engaged</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
</div>

<?php include 'inc/footer.php'?>