<?php /* Template Name: About Page Template */ get_header(); ?>
<?php include get_template_directory() . '/inc/menus/menu.php'; ?>  

<main role="main">
     <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ); ?>
    <section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('https://lwegatech.net/nare/wp-content/uploads/2025/03/legal-scaled.jpg') no-repeat;background-size: cover;background-position: center center;">
        <div class="overlay">
            <div class="page-title">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-12 align-self-end">
                            <h1 class="entry-title">The team</h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php if (have_posts()): while (have_posts()): the_post(); ?>
        <section class="single-team-member">
            <div class="container">
                <div class="row mt-5">
                    <div class="col-lg-4">
                        <div class="team-details__top-left">
                            <?php if (has_post_thumbnail()) : ?>
                                <div class="team-member-photo">
                                    <?php the_post_thumbnail('large', array('class' => 'img-fluid team-member-photo-img')); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="col-lg-8">
                        <div class="team-details__top-right">
                            <div class="team-member-info">
                            <h1 class="team-details__top-name"><?php the_title(); ?></h1>

                            <?php
                            $position = get_post_meta(get_the_ID(), '_position', true);
                            $email = get_post_meta(get_the_ID(), '_email', true);
                            $phone = get_post_meta(get_the_ID(), '_phone', true);
                            ?>

                            <?php if ($position): ?>
                                <p class="team-details__top-position"><?php echo esc_html($position); ?></p>
                            <?php endif; ?>

                            <div class="contact-info mb-5">
                                <?php if ($email): ?>
                                    <p><strong>Email:</strong> <a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_html($email); ?></a></p>
                                <?php endif; ?>
                                <?php if ($phone): ?>
                                    <p><strong>Phone:</strong> <a href="tel:<?php echo esc_attr($phone); ?>"><?php echo esc_html($phone); ?></a></p>
                                <?php endif; ?>
                            </div>

                            <div class="team-member-content">
                                <?php the_content(); ?>
                            </div>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endwhile; endif; ?>
</main>

<?php 
get_footer(); 
?>
