<?php
/** =================================================================
 *  SHORTCODE - TEAM
 *===================================================================*/
/** 
 * Team Shortcode with GSAP Scroll Effect
 */
function team_shortcode($atts) {
    ob_start();
    
    // Enqueue styles
    wp_enqueue_style('team-styles', get_template_directory_uri() . '/assets/css/team-styles.css');
    
    // Enqueue scripts
    wp_enqueue_script('gsap', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js', array(), '3.12.2', true);
    wp_enqueue_script('scroll-trigger', 'https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js', array('gsap'), '3.12.2', true);
    wp_enqueue_script('team-script', get_template_directory_uri() . '/assets/js/team-script.js', array('gsap', 'scroll-trigger'), '1.0', true);
    
    // Font Awesome
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');
    
    $atts = shortcode_atts(
        array(
            'category' => '',
            'number'   => 15,
            'order'    => 'ASC',
        ),
        $atts,
        'team'
    );

    $query_args = array(
        'post_type'      => 'team',
        'posts_per_page' => $atts['number'],
        'orderby'        => 'date',
        'order'          => $atts['order'],
    );

    if (!empty($atts['category'])) {
        $query_args['tax_query'] = array(
            array(
                'taxonomy' => 'team_category',
                'field'    => 'slug',
                'terms'    => $atts['category'],
            ),
        );
    }

    $teams_query = new WP_Query($query_args);

    if ($teams_query->have_posts()) :
        ?>
        <div class="team-section row">
            <div class="left-content col-4">
                <h2>NARE leadership</h2>
                <div class="team-intro">
                    <p>
                        Our firm is built on the expertise and dedication of a dynamic team of legal professionals.
                        Each member brings deep knowledge, sharp insight, and a commitment to delivering exceptional results for our clients. 
                    </p>
                    <p>
                        Together, we combine experience with innovation to provide strategic, client-centered legal solutions.
                    </p>
                  </div>
            </div>
            <div class="right-content col-8">
                <div class="team-members">
                    <?php while ($teams_query->have_posts()) : $teams_query->the_post();
                        $post_id = get_the_ID();
                        $position = get_post_meta($post_id, '_position', true);
                        $social_links = get_post_meta($post_id, '_social_links', true);
                        ?>
                        <div class="team-member">
                            <div class="post-thumbnail">
                                <?php 
                                if (has_post_thumbnail()) {
                                    the_post_thumbnail('medium', array('class' => 'img-fluid')); 
                                } else {
                                    echo '<img src="' . esc_url(get_template_directory_uri()) . '/assets/images/profile-pic.gif" alt="Default Image" class="img-fluid"/>';
                                }
                                ?>
                            </div>
                            <h3><?php the_title(); ?></h3>
                            <p class="position"><?php echo esc_html($position); ?></p>

                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
        <?php
        wp_reset_postdata();
    else :
        echo '<p>No Team Members found.</p>';
    endif;

    return ob_get_clean();
}
add_shortcode('team', 'team_shortcode');