<?php 
// Stats Shortcode
function stats_shortcode($atts) {
    $atts = shortcode_atts(array(
        'category' => '',
        'limit' => 4,
        'duration' => 2000 // Animation duration in milliseconds
    ), $atts);
    
    $args = array(
        'post_type' => 'stats',
        'posts_per_page' => $atts['limit'],
        'orderby' => 'menu_order',
        'order' => 'ASC'
    );
    
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'category',
                'field' => 'slug',
                'terms' => $atts['category']
            )
        );
    }
    
    $stats = new WP_Query($args);
    
    if (!$stats->have_posts()) {
        return '';
    }
    
    $output = '<div class="container-fluid"><div class="row justify-content-between">';
    
    while ($stats->have_posts()) {
        $stats->the_post();
        $icon = get_post_meta(get_the_ID(), '_stat_icon', true);
        $figure = get_post_meta(get_the_ID(), '_stat_figure', true);
        $description = get_post_meta(get_the_ID(), '_stat_description', true);
        
        // Extract the numeric value from the figure (e.g., "500+" becomes 500)
        $numeric_value = preg_replace('/[^0-9]/', '', $figure);
        $output .= '<div class="col-6 col-md-3 stat-item fade-up">';
        $output .= '<div class="stat-content fade-up">';
        $output .= '<i class="' . esc_attr($icon) . ' fa-4x text-white"></i>';
        $output .= '<div class="separator"></div>';
        $output .= '<p class="stat-text fade-up">';
        $output .= '<strong class="counter" data-target="' . esc_attr($numeric_value) . '">0</strong>';
        $output .= '<span>' . esc_html($description) . '</span>';
        $output .= '</p>';
        $output .= '</div>';
        $output .= '</div>';
    }
    
    $output .= '</div></div>';
    
    // Add the counter animation script
    $output .= '
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        const counters = document.querySelectorAll(".counter");
        const speed = ' . intval($atts['duration']) . ';
        
        function animateCounter(counter) {
            const target = +counter.getAttribute("data-target");
            const count = +counter.innerText;
            const increment = target / (speed / 16); // 16ms is roughly 1 frame
            
            if (count < target) {
                counter.innerText = Math.ceil(count + increment);
                setTimeout(() => animateCounter(counter), 16);
            } else {
                counter.innerText = target;
                // Add the "+" if the original figure had it
                // if (counter.parentElement.querySelector("span").textContent === "Clients" || 
                //     counter.parentElement.querySelector("span").textContent === "Cases Won") {
                //     counter.innerText = target + "+";
                // }
            }
        }
        
        // Start counting when element is in viewport
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    animateCounter(entry.target);
                    observer.unobserve(entry.target);
                }
            });
        }, { threshold: 0.5 });
        
        counters.forEach(counter => {
            observer.observe(counter);
        });
    });
    </script>';
    
    wp_reset_postdata();
    
    return $output;
}
add_shortcode('display_stats', 'stats_shortcode');
?>