<?php
// services Cards Shortcode
function services_cards_shortcode($atts) {
    $atts = shortcode_atts(array(
        'category' => '',
        'limit' => 3
    ), $atts);
    
    $args = array(
        'post_type' => 'services_card',
        'posts_per_page' => $atts['limit'],
        'orderby' => 'meta_value_num',
        'meta_key' => '_card_number',
        'order' => 'ASC'
    );
    
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'category',
                'field' => 'slug',
                'terms' => $atts['category']
            )
        );
    }
    
    $cards = new WP_Query($args);
    
    if (!$cards->have_posts()) {
        return '';
    }
    
    $output = '<div class="row services-cards-container">';
    
    $delay = 0;
    
    while ($cards->have_posts()) {
        $cards->the_post();
        $image_url = get_post_meta(get_the_ID(), '_card_image_url', true);
        $card_number = get_post_meta(get_the_ID(), '_card_number', true);
        $card_title = get_post_meta(get_the_ID(), '_card_title', true);
        $card_text = get_post_meta(get_the_ID(), '_card_text', true);
        $card_link = get_post_meta(get_the_ID(), '_card_link', true);
        $page_link = get_post_meta(get_the_ID(), '_page_link', true);
        $icon_class = get_post_meta(get_the_ID(), '_icon_class', true);
        $icon_color = get_post_meta(get_the_ID(), '_icon_color', true);
        
        $primary_link = !empty($page_link) ? $page_link : $card_link;
        
        $style = 'style="animation-delay: ' . ($delay * 0.5) . 's"';
        
        $output .= '<div class="col-md-4 fade-up" ' . $style . '>';
        $output .= '<div class="services-card">';
        
        // Clickable image
        $output .= '<a href="' . esc_url($primary_link) . '" class="image-card-link">';
        $output .= '<div class="image-card">';
        $output .= '<img src="' . esc_url($image_url) . '" class="card-img-top fade-up" alt="' . esc_attr($card_title) . '">';
        $output .= '</div>';
        $output .= '</a>';
        
        // Entire text card wrapped in anchor
        $output .= '<a href="' . esc_url($primary_link) . '" class="text-card-container text-decoration-none">';
        $output .= '<div class="small-card text-white">';
        $output .= '<i class="' . esc_attr($icon_class) . ' fa-2x" style="color:' . esc_attr($icon_color) . '"></i>';
        $output .= '</div>';
        $output .= '<div class="text-card">';
        $output .= '<div class="text-card-body">';
        
        $output .= '<h5 class="card-title fade-up mb-2">' . esc_html($card_title) . '</h5>';
        
        $output .= '<div class="d-flex align-items-center mb-3">';
        $output .= '<h2 class="mb-0 me-3">' . esc_html(str_pad($card_number, 2, '0', STR_PAD_LEFT)) . '</h2>';
        $output .= '<div class="divider flex-grow-1"></div>';
        $output .= '<div class="icon-box text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-2 mt-2" style="width: 60px; height: 60px; transition: all 0.3s ease;">';
        $output .= '<i class="fas fa-external-link-alt" aria-hidden="true" style="transform: rotate(45deg); font-size: 1.5rem;"></i>';
        $output .= '</div>';
        $output .= '</div>';
        
        $output .= '<p class="card-text fade-up">' . esc_html($card_text) . '</p>';
        
        $output .= '</div>'; // text-card-body
        $output .= '</div>'; // text-card
        $output .= '</a>';   // Close text card link
        
        $output .= '</div>'; // services-card
        $output .= '</div>'; // col
        $delay++; 
    }
    
    $output .= '</div>';
    
    wp_reset_postdata();
    
    return $output;
}
add_shortcode('display_services_cards', 'services_cards_shortcode');
?>
