<?php
// Register Custom Post Type for services Cards
function create_services_cards_post_type() {
    register_post_type('services_card',
        array(
            'labels' => array(
                'name' => __('services Cards'),
                'singular_name' => __('Services Card'),
                'add_new_item' => __('Add New Card'),
                'edit_item' => __('Edit Card'),
                'new_item' => __('New Card'),
                'view_item' => __('View Card'),
                'search_items' => __('Search Cards'),
            ),
            'public' => true,
            'has_archive' => false,
            'show_in_menu' => true,
            'menu_icon' => 'dashicons-images-alt2',
            'supports' => array('title'),
            'rewrite' => array('slug' => 'services-cards'),
        )
    );
}
add_action('init', 'create_services_cards_post_type');

// Add custom fields for Servicesd Cards
function add_services_cards_meta_boxes() {
    add_meta_box(
        'services_card_details',
        'Card Details',
        'services_card_meta_box_callback',
        'services_card',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_services_cards_meta_boxes');

function services_card_meta_box_callback($post) {
    wp_nonce_field('services_card_meta_box', 'services_card_meta_box_nonce');
    
    $image_url = get_post_meta($post->ID, '_card_image_url', true);
    $card_number = get_post_meta($post->ID, '_card_number', true);
    $card_title = get_post_meta($post->ID, '_card_title', true);
    $card_text = get_post_meta($post->ID, '_card_text', true);
    $card_link = get_post_meta($post->ID, '_card_link', true);
    $page_link = get_post_meta($post->ID, '_page_link', true);
    $icon_class = get_post_meta($post->ID, '_icon_class', true);
    $icon_color = get_post_meta($post->ID, '_icon_color', true);
    
    echo '<p><label for="card_image_url">Card Image URL:</label>';
    echo '<input type="text" id="card_image_url" name="card_image_url" value="' . esc_attr($image_url) . '" class="widefat">';
    echo '<button class="button upload_image_button" data-target="card_image_url">Upload Image</button></p>';
    
    echo '<p><label for="card_number">Card Number:</label>';
    echo '<input type="text" id="card_number" name="card_number" value="' . esc_attr($card_number) . '" class="widefat"></p>';
    
    echo '<p><label for="card_title">Card Title:</label>';
    echo '<input type="text" id="card_title" name="card_title" value="' . esc_attr($card_title) . '" class="widefat"></p>';
    
    echo '<p><label for="card_text">Card Text:</label>';
    echo '<textarea id="card_text" name="card_text" class="widefat">' . esc_textarea($card_text) . '</textarea></p>';
    
    echo '<p><label for="card_link">Card Link URL:</label>';
    echo '<input type="text" id="card_link" name="card_link" value="' . esc_attr($card_link) . '" class="widefat"></p>';
    
    echo '<p><label for="page_link">External Page Link:</label>';
    echo '<input type="text" id="page_link" name="page_link" value="' . esc_attr($page_link) . '" class="widefat" placeholder="https://example.com/page">';
    echo '<small>Add an external link for this card</small></p>';
    
    // Replaced SVG field with Font Awesome icon class field
    echo '<p><label for="icon_class">Font Awesome Icon Class:</label>';
    echo '<input type="text" id="icon_class" name="icon_class" value="' . esc_attr($icon_class) . '" class="widefat" placeholder="fas fa-gavel">';
    echo '<small>Example: fas fa-gavel, fas fa-briefcase, fas fa-scale-balanced</small></p>';
    
    echo '<p><label for="icon_color">Icon Color (hex):</label>';
    echo '<input type="text" id="icon_color" name="icon_color" value="' . esc_attr($icon_color ? $icon_color : '#1a3e6f') . '" class="widefat"></p>';
    
    // Media uploader script
    echo '
    <script>
    jQuery(document).ready(function($) {
        $(".upload_image_button").click(function(e) {
            e.preventDefault();
            var target = $(this).data("target");
            var frame = wp.media({
                title: "Select or Upload Image",
                button: { text: "Use this image" },
                multiple: false
            });
            
            frame.on("select", function() {
                var attachment = frame.state().get("selection").first().toJSON();
                $("#" + target).val(attachment.url);
            });
            
            frame.open();
        });
    });
    </script>';
}

function save_services_card_meta($post_id) {
    if (!isset($_POST['services_card_meta_box_nonce']) || !wp_verify_nonce($_POST['services_card_meta_box_nonce'], 'services_card_meta_box')) {
        return;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    
    $fields = array(
        'card_image_url',
        'card_number',
        'card_title',
        'card_text',
        'card_link',
        'page_link',
        'icon_class',
        'icon_color'
    );
    
    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, '_' . $field, sanitize_text_field($_POST[$field]));
        }
    }
}
add_action('save_post', 'save_services_card_meta');

// Enqueue Font Awesome (add this if not already in your theme)
function enqueue_font_awesome_for_services_cards() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_font_awesome_for_services_cards');
?>