<?php
// Commercial and Corporate Law Cards
function commercial_law_cards_shortcode() {
    ob_start();
 
    echo '<div class="category-cards-grid">';
    
    $args = array(
        'post_type' => 'page',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'page_category', 
                'field' => 'slug',
                'terms' => 'commercial-and-corporate-law', 
            )
        )
    );
    
    $query = new WP_Query($args);
    
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $iconImg = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');
            echo '<a href="' . get_permalink() . '" class="page-card-link">';
            echo '<div class="page-card">';
            if ($iconImg) {
                echo '<div class="card-icon-container">';
                echo '<img src="' . esc_url($iconImg[0]) . '" alt="' . esc_attr(get_the_title()) . '" class="card-icon" />';
                echo '</div>';
            }
            echo '<h3>' . get_the_title() . '</h3>';
            echo '<div class="card-excerpt">' . wp_trim_words(get_the_excerpt(), 20) . '</div>';
            echo '</div>';
            echo '</a>';
        }
    } else {
        echo '<p>No pages found in this category.</p>';
    }
    
    wp_reset_postdata();
    
    echo '</div>';
    
    return ob_get_clean();
}
add_shortcode('commercial_law_cards', 'commercial_law_cards_shortcode');
// Conveyancing and Real Property Law Cards
function conveyancing_law_cards_shortcode() {
    ob_start();
    
    echo '<div class="category-cards-grid">';

     $args = array(
        'post_type' => 'page',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'page_category', 
                'field' => 'slug',
                'terms' => 'Conveyancing and Real Property Loyal Practice', 
            )
        )
    );
    
    
    $query = new WP_Query($args);
    
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $iconImg = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');
            echo '<a href="' . get_permalink() . '" class="page-card-link">';
            echo '<div class="page-card">';
            if ($iconImg) {
                echo '<div class="card-icon-container">';
                echo '<img src="' . esc_url($iconImg[0]) . '" alt="' . esc_attr(get_the_title()) . '" class="card-icon" />';
                echo '</div>';
            }
            echo '<h3>' . get_the_title() . '</h3>';
            echo '<div class="card-excerpt">' . wp_trim_words(get_the_excerpt(), 20) . '</div>';
            echo '</div>';
            echo '</a>';
        }
    } else {
        echo '<p>No pages found in this category.</p>';
    }
    wp_reset_postdata();
    
    echo '</div>';
    
    return ob_get_clean();
}
add_shortcode('conveyancing_law_cards', 'conveyancing_law_cards_shortcode');

// Litigation and Dispute Resolution Cards
function litigation_law_cards_shortcode() {
    ob_start();
    echo '<div class="category-cards-grid">';
    
    $args = array(
        'post_type' => 'page',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'page_category', 
                'field' => 'slug',
                'terms' => 'litigation-and-dispute-resolution', 
            )
        )
    );
    
    $query = new WP_Query($args);
    
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $iconImg = wp_get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail');
            echo '<a href="' . get_permalink() . '" class="page-card-link">';
            echo '<div class="page-card">';
            if ($iconImg) {
                echo '<div class="card-icon-container">';
                echo '<img src="' . esc_url($iconImg[0]) . '" alt="' . esc_attr(get_the_title()) . '" class="card-icon" />';
                echo '</div>';
            }
            echo '<h3>' . get_the_title() . '</h3>';
            echo '<div class="card-excerpt">' . wp_trim_words(get_the_excerpt(), 20) . '</div>';
            echo '</div>';
            echo '</a>';
        }
    } else {
        echo '<p>No pages found in this category.</p>';
    }
    
    wp_reset_postdata();
    
    echo '</div>';
    
    return ob_get_clean();
}
add_shortcode('litigation_law_cards', 'litigation_law_cards_shortcode');

// Combined All Categories Cards
function all_law_cards_shortcode() {
    ob_start();
    
    echo do_shortcode('[commercial_law_cards]');
    echo do_shortcode('[conveyancing_law_cards]');
    echo do_shortcode('[litigation_law_cards]');
    
    return ob_get_clean();
}
add_shortcode('all_law_cards', 'all_law_cards_shortcode');

// Add CSS styles for clickable cards
function category_cards_styles() {
    ?>
    <style>
        .category-cards-grid {
            margin-bottom: 30px;
            margin-bottom: 30px;
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(330px, 1fr));
            gap: 20px;
        }
        .page-card-link {
            text-decoration: none;
            display: block;
            color: inherit;
        }
        .page-card {
            background: #f0f4f8;
            /*border: 1px solid #ddd;*/
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            height: 100%;
            display: flex;
            flex-direction: column;
            margin-bottom: 30px;
        }
        .page-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        .card-icon-container {
            text-align: left;
            margin-bottom: 30px;
        }
        .card-icon {
            width: 70px;
            height: 70px;
            object-fit: cover;
            border-radius: 50%;
        }
        .page-card h3 {
            margin: 0 0 10px 0;
            font-size: 25px;
            font-weight:800;
            text-align:left;
            margin-bottom: 30px;
            text-transform:uppercase;
        }
        .card-excerpt {
            font-size: 18px;
            font-weight:400;
            line-height: 1.4;
            display: -webkit-box;
            -webkit-line-clamp: 3;
            -webkit-box-orient: vertical;
            overflow: hidden;
            flex-grow: 1;
        }
    </style>
    <?php
}
add_action('wp_head', 'category_cards_styles');